/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestCleaner
extends CompactorTest {
    @Test
    public void nothing() throws Exception {
        this.startCleaner();
    }

    @Test
    public void cleanupAfterMajorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camtc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "camtc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camtc", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMajorPartitionCompaction() throws Exception {
        Table t = this.newTable("default", "campc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "campc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "campc", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMinorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camitc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions("default", "camitc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camitc", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path p : paths) {
            if (p.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (p.getName().equals(this.makeDeltaDirName(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + p.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void cleanupAfterMinorPartitionCompaction() throws Exception {
        Table t = this.newTable("default", "camipc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "camipc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path path : paths) {
            if (path.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (path.getName().equals(this.makeDeltaDirNameCompacted(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + path.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void blockedByLockTable() throws Exception {
        Table t = this.newTable("default", "bblt", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions("default", "bblt", 25);
        CompactionRequest rqst = new CompactionRequest("default", "bblt", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "default");
        comp.setTablename("bblt");
        comp.setOperationType(DataOperationType.SELECT);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"bblt", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void blockedByLockPartition() throws Exception {
        Table t = this.newTable("default", "bblp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "bblp", 25);
        CompactionRequest rqst = new CompactionRequest("default", "bblp", CompactionType.MINOR);
        rqst.setPartitionname("ds=Today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("bblp");
        comp.setPartitionname("ds=Today");
        comp.setOperationType(DataOperationType.DELETE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        OpenTxnsResponse resp = this.txnHandler.openTxns(new OpenTxnRequest(1, "Dracula", "Transylvania"));
        req.setTxnid(((Long)resp.getTxn_ids().get(0)).longValue());
        LockResponse res = this.txnHandler.lock(req);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"bblp", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=Today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void notBlockedBySubsequentLock() throws Exception {
        Table t = this.newTable("default", "bblt", false);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, 100L, TimeUnit.MILLISECONDS);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions("default", "bblt", 25);
        CompactionRequest rqst = new CompactionRequest("default", "bblt", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "default");
        comp.setTablename("bblt");
        comp.setOperationType(DataOperationType.INSERT);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        AtomicBoolean looped = new AtomicBoolean();
        looped.set(false);
        this.startCleaner(looped);
        while (!looped.get()) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        LockComponent comp2 = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "default");
        comp2.setTablename("bblt");
        comp.setOperationType(DataOperationType.SELECT);
        ArrayList<LockComponent> components2 = new ArrayList<LockComponent>(1);
        components2.add(comp2);
        LockRequest req2 = new LockRequest(components, "me", "localhost");
        LockResponse res2 = this.txnHandler.lock(req2);
        this.txnHandler.unlock(new UnlockRequest(res.getLockid()));
        looped.set(false);
        while (!looped.get()) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        this.stopThread();
        Thread.currentThread();
        Thread.sleep(200L);
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
    }

    @Test
    public void partitionNotBlockedBySubsequentLock() throws Exception {
        Table t = this.newTable("default", "bblt", true);
        Partition p = this.newPartition(t, "today");
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, 100L, TimeUnit.MILLISECONDS);
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "bblt", 25);
        CompactionRequest rqst = new CompactionRequest("default", "bblt", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        LockComponent comp = new LockComponent(LockType.SHARED_READ, LockLevel.PARTITION, "default");
        comp.setTablename("bblt");
        comp.setPartitionname("ds=today");
        comp.setOperationType(DataOperationType.INSERT);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        LockResponse res = this.txnHandler.lock(req);
        AtomicBoolean looped = new AtomicBoolean();
        looped.set(false);
        this.startCleaner(looped);
        while (!looped.get()) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        LockComponent comp2 = new LockComponent(LockType.SHARED_READ, LockLevel.PARTITION, "default");
        comp2.setTablename("bblt");
        comp2.setPartitionname("ds=today");
        comp.setOperationType(DataOperationType.SELECT);
        ArrayList<LockComponent> components2 = new ArrayList<LockComponent>(1);
        components2.add(comp2);
        LockRequest req2 = new LockRequest(components, "me", "localhost");
        LockResponse res2 = this.txnHandler.lock(req2);
        this.txnHandler.unlock(new UnlockRequest(res.getLockid()));
        looped.set(false);
        while (!looped.get()) {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        this.stopThread();
        Thread.currentThread();
        Thread.sleep(200L);
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
    }

    @Test
    public void cleanupAfterMajorPartitionCompactionNoBase() throws Exception {
        Table t = this.newTable("default", "campcnb", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 22L, 22);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "campcnb", 25);
        CompactionRequest rqst = new CompactionRequest("default", "campcnb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertTrue((boolean)"succeeded".equals(((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState()));
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void droppedTable() throws Exception {
        Table t = this.newTable("default", "dt", false);
        this.addDeltaFile(t, null, 1L, 22L, 22);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "dt", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dt", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.ms.dropTable("default", "dt");
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void droppedPartition() throws Exception {
        Table t = this.newTable("default", "dp", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 22L, 22);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "dp", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dp", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        CompactionInfo ci = this.txnHandler.findNextToCompact("fred");
        this.txnHandler.markCompacted(ci);
        this.txnHandler.setRunAs(ci.id, System.getProperty("user.name"));
        this.ms.dropPartition("default", "dp", Collections.singletonList("today"), true);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }

    @After
    public void tearDown() throws Exception {
        this.compactorTestCleanup();
    }
}

