/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import junit.framework.Assert;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetFilterPredicateConverter;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Test;

public class TestParquetFilterPredicate {
    @Test
    public void testFilterColumnsThatDoNoExistOnSchema() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 a; required binary stinger; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("a", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.LONG, (Object)10L, (Object)20L).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)"stinger").end().end().build();
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(not(eq(a, null)), not(eq(a, Binary{\"stinger\"})))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }

    @Test
    public void testFilterColumnsThatDoNoExistOnSchemaHighOrder1() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 a; required int32 b; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startOr().startAnd().equals("a", PredicateLeaf.Type.LONG, (Object)1L).equals("none", PredicateLeaf.Type.LONG, (Object)1L).end().startAnd().equals("a", PredicateLeaf.Type.LONG, (Object)999L).equals("none", PredicateLeaf.Type.LONG, (Object)999L).end().end().build();
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "or(eq(a, 1), eq(a, 999))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }

    @Test
    public void testFilterColumnsThatDoNoExistOnSchemaHighOrder2() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 a; required int32 b; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().startOr().equals("a", PredicateLeaf.Type.LONG, (Object)1L).equals("b", PredicateLeaf.Type.LONG, (Object)1L).end().startOr().equals("a", PredicateLeaf.Type.LONG, (Object)999L).equals("none", PredicateLeaf.Type.LONG, (Object)999L).end().end().build();
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "or(eq(a, 1), eq(b, 1))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }

    @Test
    public void testFilterFloatColumns() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {  required float a; required int32 b; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("a", PredicateLeaf.Type.FLOAT).between("a", PredicateLeaf.Type.FLOAT, (Object)10.2, (Object)20.3).in("b", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).end().end().build();
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(and(not(eq(a, null)), not(and(lteq(a, 20.3), not(lt(a, 10.2))))), not(or(or(eq(b, 1), eq(b, 2)), eq(b, 3))))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }

    @Test
    public void testFilterBetween() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {  required int32 bCol; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.LONG, (Object)1L, (Object)5L).build();
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        String expected = "and(lteq(bCol, 5), not(lt(bCol, 1)))";
        Assert.assertEquals((String)expected, (String)p.toString());
        sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.LONG, (Object)5L, (Object)1L).build();
        p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        expected = "and(lteq(bCol, 1), not(lt(bCol, 5)))";
        Assert.assertEquals((String)expected, (String)p.toString());
        sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.LONG, (Object)1L, (Object)1L).build();
        p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema);
        expected = "and(lteq(bCol, 1), not(lt(bCol, 1)))";
        Assert.assertEquals((String)expected, (String)p.toString());
    }
}

