/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util.batchgen;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.batchgen.VectorBatchGenerator;

public class VectorBatchGenerateStream {
    private final long randomSeed;
    private final VectorBatchGenerator generator;
    private final int rowCount;
    private Random random;
    private int sizeCountDown;

    public VectorBatchGenerateStream(long randomSeed, VectorBatchGenerator generator, int rowCount) {
        this.randomSeed = randomSeed;
        this.generator = generator;
        this.rowCount = rowCount;
        this.reset();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void reset() {
        this.random = new Random(this.randomSeed);
        this.sizeCountDown = this.rowCount;
    }

    public boolean isNext() {
        return this.sizeCountDown > 0;
    }

    public void fillNext(VectorizedRowBatch batch) {
        int size = Math.min(this.sizeCountDown, 1024);
        batch.reset();
        this.generator.generateBatch(batch, this.random, size);
        this.sizeCountDown -= size;
    }
}

