/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCurrentTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFExplode;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;

public class TestFunctionRegistry
extends TestCase {
    TypeInfo varchar5;
    TypeInfo varchar10;
    TypeInfo maxVarchar;
    TypeInfo char5;
    TypeInfo char10;

    protected void setUp() {
        String maxVarcharTypeName = "varchar(65535)";
        this.maxVarchar = TypeInfoFactory.getPrimitiveTypeInfo((String)maxVarcharTypeName);
        this.varchar10 = TypeInfoFactory.getPrimitiveTypeInfo((String)"varchar(10)");
        this.varchar5 = TypeInfoFactory.getPrimitiveTypeInfo((String)"varchar(5)");
        this.char10 = TypeInfoFactory.getPrimitiveTypeInfo((String)"char(10)");
        this.char5 = TypeInfoFactory.getPrimitiveTypeInfo((String)"char(5)");
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        SessionState.start((HiveConf)hiveConf);
    }

    private void implicit(TypeInfo a, TypeInfo b, boolean convertible) {
        TestFunctionRegistry.assertEquals((boolean)convertible, (boolean)TypeInfoUtils.implicitConvertible((TypeInfo)a, (TypeInfo)b));
    }

    public void testImplicitConversion() {
        this.implicit((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.longTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.floatTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit((TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, false);
        this.implicit(this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, this.varchar10, true);
        PrimitiveTypeInfo varchar10 = TypeInfoFactory.getPrimitiveTypeInfo((String)"varchar(10)");
        PrimitiveTypeInfo varchar20 = TypeInfoFactory.getPrimitiveTypeInfo((String)"varchar(20)");
        this.implicit((TypeInfo)varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        this.implicit((TypeInfo)varchar20, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)varchar10, true);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)varchar20, true);
        this.implicit((TypeInfo)varchar20, (TypeInfo)varchar10, true);
        this.implicit(this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        this.implicit((TypeInfo)TypeInfoFactory.stringTypeInfo, this.char10, true);
        this.implicit(this.char5, this.char10, true);
        this.implicit(this.char5, (TypeInfo)varchar10, true);
        this.implicit(this.varchar5, this.char10, true);
        this.implicit((TypeInfo)TypeInfoFactory.intTypeInfo, this.char10, true);
        this.implicit((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)varchar10, true);
        this.implicit((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
    }

    private static List<Method> getMethods(Class<?> udfClass, String methodName) {
        ArrayList<Method> mlist = new ArrayList<Method>();
        for (Method m : udfClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            mlist.add(m);
        }
        return mlist;
    }

    private void typeAffinity(String methodName, TypeInfo inputType, int expectedNumFoundMethods, Class expectedFoundType) {
        List<Method> mlist = TestFunctionRegistry.getMethods(TestUDF.class, methodName);
        TestFunctionRegistry.assertEquals((boolean)true, (1 < mlist.size() ? 1 : 0) != 0);
        ArrayList<TypeInfo> inputTypes = new ArrayList<TypeInfo>();
        inputTypes.add(inputType);
        FunctionRegistry.filterMethodsByTypeAffinity(mlist, inputTypes);
        TestFunctionRegistry.assertEquals((int)expectedNumFoundMethods, (int)mlist.size());
        if (expectedNumFoundMethods == 1) {
            TestFunctionRegistry.assertEquals((Object)expectedFoundType, mlist.get(0).getParameterTypes()[0]);
        }
    }

    public void testTypeAffinity() {
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.shortTypeInfo, 1, DoubleWritable.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.intTypeInfo, 1, DoubleWritable.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.floatTypeInfo, 1, DoubleWritable.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.dateTypeInfo, 1, DateWritableV2.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.timestampTypeInfo, 1, DateWritableV2.class);
        this.typeAffinity("typeaffinity1", (TypeInfo)TypeInfoFactory.stringTypeInfo, 1, Text.class);
        this.typeAffinity("typeaffinity1", this.char5, 1, Text.class);
        this.typeAffinity("typeaffinity1", this.varchar5, 1, Text.class);
        this.typeAffinity("typeaffinity2", (TypeInfo)TypeInfoFactory.shortTypeInfo, 2, null);
        this.typeAffinity("typeaffinity2", (TypeInfo)TypeInfoFactory.dateTypeInfo, 2, null);
    }

    private void verify(Class udf, String name, TypeInfo ta, TypeInfo tb, Class a, Class b, boolean throwException) {
        LinkedList<TypeInfo> args = new LinkedList<TypeInfo>();
        args.add(ta);
        args.add(tb);
        Method result = null;
        try {
            result = FunctionRegistry.getMethodInternal((Class)udf, (String)name, (boolean)false, args);
        }
        catch (UDFArgumentException e) {
            assert (throwException);
            return;
        }
        assert (!throwException);
        TestFunctionRegistry.assertEquals((int)2, (int)result.getParameterTypes().length);
        TestFunctionRegistry.assertEquals((Object)a, result.getParameterTypes()[0]);
        TestFunctionRegistry.assertEquals((Object)b, result.getParameterTypes()[1]);
    }

    public void testGetMethodInternal() {
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, HiveDecimalWritable.class, HiveDecimalWritable.class, false);
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo, DoubleWritable.class, DoubleWritable.class, false);
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, DoubleWritable.class, DoubleWritable.class, false);
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo, DoubleWritable.class, DoubleWritable.class, false);
        this.verify(TestUDF.class, "same", (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, HiveDecimalWritable.class, HiveDecimalWritable.class, false);
        this.verify(TestUDF.class, "one", (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, IntWritable.class, HiveDecimalWritable.class, false);
        this.verify(TestUDF.class, "one", (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.floatTypeInfo, IntWritable.class, DoubleWritable.class, false);
        this.verify(TestUDF.class, "one", (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, IntWritable.class, IntWritable.class, false);
        this.verify(TestUDF.class, "same", this.varchar5, this.varchar10, Text.class, Text.class, false);
        this.verify(TestUDF.class, "same", this.char5, this.char10, Text.class, Text.class, false);
        this.verify(TestUDF.class, "mismatch", (TypeInfo)TypeInfoFactory.voidTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, null, null, true);
    }

    private void common(TypeInfo a, TypeInfo b, TypeInfo result) {
        TestFunctionRegistry.assertEquals((Object)result, (Object)FunctionRegistry.getCommonClass((TypeInfo)a, (TypeInfo)b));
    }

    public void testCommonClass() {
        this.common((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.stringTypeInfo, this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common(this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common((TypeInfo)TypeInfoFactory.stringTypeInfo, this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common(this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.common(this.char5, this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    private void comparison(TypeInfo a, TypeInfo b, TypeInfo result) {
        TestFunctionRegistry.assertEquals((Object)result, (Object)FunctionRegistry.getCommonClassForComparison((TypeInfo)a, (TypeInfo)b));
    }

    public void testCommonClassComparison() {
        this.comparison((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.comparison(this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.comparison(this.varchar5, this.varchar10, this.varchar10);
        this.comparison((TypeInfo)TypeInfoFactory.stringTypeInfo, this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.comparison(this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.comparison(this.char5, this.char10, this.char10);
        this.comparison(this.char10, this.varchar5, (TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    public void testPrintTypeCompatibility() {
    }

    private void unionAll(TypeInfo a, TypeInfo b, TypeInfo result) {
        TestFunctionRegistry.assertEquals((Object)result, (Object)FunctionRegistry.getCommonClassForUnionAll((TypeInfo)a, (TypeInfo)b));
    }

    public void testCommonClassUnionAll() {
        this.unionAll((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.intTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.doubleTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        this.unionAll(this.varchar5, this.varchar10, this.varchar10);
        this.unionAll(this.varchar10, this.varchar5, this.varchar10);
        this.unionAll(this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.stringTypeInfo, this.varchar10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.unionAll(this.char5, this.char10, this.char10);
        this.unionAll(this.char10, this.char5, this.char10);
        this.unionAll(this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.stringTypeInfo, this.char10, (TypeInfo)TypeInfoFactory.stringTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.timestampTypeInfo, (TypeInfo)TypeInfoFactory.dateTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo);
        this.unionAll((TypeInfo)TypeInfoFactory.stringTypeInfo, (TypeInfo)TypeInfoFactory.decimalTypeInfo, null);
        this.unionAll((TypeInfo)TypeInfoFactory.doubleTypeInfo, this.varchar10, null);
    }

    public void testGetTypeInfoForPrimitiveCategory() {
        TestFunctionRegistry.assertEquals((Object)this.varchar10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar5), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar10), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR));
        TestFunctionRegistry.assertEquals((Object)this.varchar10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar10), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar5), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR));
        TestFunctionRegistry.assertEquals((Object)this.char10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char5), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char10), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.CHAR));
        TestFunctionRegistry.assertEquals((Object)this.char10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char10), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char5), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.CHAR));
        TestFunctionRegistry.assertEquals((Object)this.varchar10, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar5), (PrimitiveTypeInfo)((PrimitiveTypeInfo)this.char10), (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.VARCHAR));
        TestFunctionRegistry.assertEquals((Object)TypeInfoFactory.stringTypeInfo, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.varchar10), (PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING));
        TestFunctionRegistry.assertEquals((Object)TypeInfoFactory.stringTypeInfo, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING));
        TestFunctionRegistry.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)TypeInfoFactory.doubleTypeInfo, (PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE));
    }

    protected void tearDown() {
    }

    public void testIsRankingFunction() throws Exception {
        Assert.assertTrue((boolean)FunctionRegistry.isRankingFunction((String)"rank"));
        Assert.assertTrue((boolean)FunctionRegistry.isRankingFunction((String)"dense_rank"));
        Assert.assertTrue((boolean)FunctionRegistry.isRankingFunction((String)"percent_rank"));
        Assert.assertTrue((boolean)FunctionRegistry.isRankingFunction((String)"cume_dist"));
        Assert.assertFalse((boolean)FunctionRegistry.isRankingFunction((String)"min"));
    }

    public void testImpliesOrder() throws Exception {
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"rank"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"dense_rank"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"percent_rank"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"cume_dist"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"first_value"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"last_value"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"lead"));
        Assert.assertTrue((boolean)FunctionRegistry.impliesOrder((String)"lag"));
        Assert.assertFalse((boolean)FunctionRegistry.impliesOrder((String)"min"));
    }

    public void testRegisterTemporaryFunctions() throws Exception {
        FunctionInfo.FunctionResource[] emptyResources = new FunctionInfo.FunctionResource[]{};
        FunctionRegistry.registerTemporaryUDF((String)"tmp_ln", UDFLn.class, (FunctionInfo.FunctionResource[])emptyResources);
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)"tmp_ln");
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isNative());
        FunctionRegistry.registerTemporaryUDF((String)"tmp_concat", GenericUDFConcat.class, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"tmp_concat");
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isNative());
        FunctionRegistry.registerTemporaryUDF((String)"tmp_max", GenericUDAFMax.class, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"tmp_max");
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isNative());
        functionInfo = FunctionRegistry.getWindowFunctionInfo((String)"tmp_max");
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isNative());
        FunctionRegistry.registerTemporaryUDF((String)"tmp_explode", GenericUDTFExplode.class, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"tmp_explode");
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isNative());
    }

    public void testRegisterPermanentFunction() throws Exception {
        FunctionInfo.FunctionResource[] emptyResources = new FunctionInfo.FunctionResource[]{};
        FunctionRegistry.registerPermanentFunction((String)"perm_ln", (String)UDFLn.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)"perm_ln");
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isPersistent());
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isNative());
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isBuiltIn());
        functionInfo = FunctionRegistry.getFunctionInfo((String)"default.perm_ln");
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isPersistent());
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isNative());
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isBuiltIn());
        FunctionRegistry.registerPermanentFunction((String)"default.perm_concat", (String)GenericUDFConcat.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"default.perm_concat");
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isPersistent());
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isNative());
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isBuiltIn());
        FunctionRegistry.registerPermanentFunction((String)"default.perm_max", (String)GenericUDAFMax.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"default.perm_max");
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isPersistent());
        functionInfo = FunctionRegistry.getWindowFunctionInfo((String)"default.perm_max");
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isPersistent());
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isNative());
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isBuiltIn());
        FunctionRegistry.registerPermanentFunction((String)"default.perm_explode", (String)GenericUDTFExplode.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        functionInfo = FunctionRegistry.getFunctionInfo((String)"default.perm_explode");
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isPersistent());
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isNative());
        TestFunctionRegistry.assertFalse((boolean)functionInfo.isBuiltIn());
    }

    public void testBuiltInFunction() throws Exception {
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)"ln");
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isBuiltIn());
        TestFunctionRegistry.assertTrue((boolean)functionInfo.isNative());
    }

    public void testIsPermanentFunction() throws Exception {
        GenericUDFCurrentTimestamp udf = new GenericUDFCurrentTimestamp();
        ArrayList children = new ArrayList();
        ExprNodeGenericFuncDesc fnExpr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, (GenericUDF)udf, children);
        TestFunctionRegistry.assertFalse((String)"Function not added as permanent yet", (boolean)FunctionRegistry.isPermanentFunction((ExprNodeGenericFuncDesc)fnExpr));
        FunctionInfo.FunctionResource[] emptyResources = new FunctionInfo.FunctionResource[]{};
        FunctionRegistry.registerPermanentFunction((String)"default.perm_current_timestamp", (String)GenericUDFCurrentTimestamp.class.getName(), (boolean)true, (FunctionInfo.FunctionResource[])emptyResources);
        TestFunctionRegistry.assertTrue((String)"Function should now be recognized as permanent function", (boolean)FunctionRegistry.isPermanentFunction((ExprNodeGenericFuncDesc)fnExpr));
    }

    private GenericUDF getUDF(String udfName) throws Exception {
        return FunctionRegistry.getFunctionInfo((String)udfName).getGenericUDF();
    }

    private void checkRuntimeConstant(GenericUDF udf) {
        TestFunctionRegistry.assertFalse((boolean)FunctionRegistry.isDeterministic((GenericUDF)udf));
        TestFunctionRegistry.assertTrue((boolean)FunctionRegistry.isRuntimeConstant((GenericUDF)udf));
        TestFunctionRegistry.assertTrue((boolean)FunctionRegistry.isConsistentWithinQuery((GenericUDF)udf));
    }

    private void checkDeterministicFn(GenericUDF udf) {
        TestFunctionRegistry.assertTrue((boolean)FunctionRegistry.isDeterministic((GenericUDF)udf));
        TestFunctionRegistry.assertFalse((boolean)FunctionRegistry.isRuntimeConstant((GenericUDF)udf));
        TestFunctionRegistry.assertTrue((boolean)FunctionRegistry.isConsistentWithinQuery((GenericUDF)udf));
    }

    private void checkNondeterministicFn(GenericUDF udf) {
        TestFunctionRegistry.assertFalse((boolean)FunctionRegistry.isDeterministic((GenericUDF)udf));
        TestFunctionRegistry.assertFalse((boolean)FunctionRegistry.isRuntimeConstant((GenericUDF)udf));
        TestFunctionRegistry.assertFalse((boolean)FunctionRegistry.isConsistentWithinQuery((GenericUDF)udf));
    }

    public void testDeterminism() throws Exception {
        this.checkDeterministicFn(this.getUDF("+"));
        this.checkDeterministicFn(this.getUDF("ascii"));
        this.checkNondeterministicFn(this.getUDF("rand"));
        this.checkNondeterministicFn(this.getUDF("uuid"));
        this.checkRuntimeConstant(this.getUDF("current_database"));
        this.checkRuntimeConstant(this.getUDF("current_date"));
        this.checkRuntimeConstant(this.getUDF("current_timestamp"));
        this.checkRuntimeConstant(this.getUDF("current_user"));
        this.checkRuntimeConstant(this.getUDF("logged_in_user"));
    }

    public class TestUDF {
        public void same(DoubleWritable x, DoubleWritable y) {
        }

        public void same(HiveDecimalWritable x, HiveDecimalWritable y) {
        }

        public void same(Text x, Text y) {
        }

        public void one(IntWritable x, HiveDecimalWritable y) {
        }

        public void one(IntWritable x, DoubleWritable y) {
        }

        public void one(IntWritable x, IntWritable y) {
        }

        public void mismatch(DateWritableV2 x, HiveDecimalWritable y) {
        }

        public void mismatch(TimestampWritableV2 x, HiveDecimalWritable y) {
        }

        public void mismatch(BytesWritable x, DoubleWritable y) {
        }

        public void typeaffinity1(DateWritableV2 x) {
        }

        public void typeaffinity1(DoubleWritable x) {
        }

        public void typeaffinity1(Text x) {
        }

        public void typeaffinity2(IntWritable x) {
        }

        public void typeaffinity2(DoubleWritable x) {
        }
    }
}

