/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.AcidWriteSetService;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestDbTxnManager2 {
    private static final Logger LOG = LoggerFactory.getLogger(TestDbTxnManager2.class);
    private static HiveConf conf = new HiveConf(Driver.class);
    private HiveTxnManager txnMgr;
    private Context ctx;
    private Driver driver;
    private TxnStore txnHandler;
    @Rule
    public TemporaryFolder exportFolder = new TemporaryFolder();

    public TestDbTxnManager2() throws Exception {
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        TxnDbUtil.setConfValues((Configuration)conf);
        conf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
    }

    @Before
    public void setUp() throws Exception {
        SessionState.start((HiveConf)conf);
        this.ctx = new Context((Configuration)conf);
        this.driver = new Driver(new QueryState.Builder().withHiveConf(conf).nonIsolated().build(), null);
        TxnDbUtil.cleanDb((Configuration)conf);
        TxnDbUtil.prepDb((Configuration)conf);
        SessionState ss = SessionState.get();
        ss.initTxnMgr(conf);
        this.txnMgr = ss.getTxnMgr();
        Assert.assertTrue((boolean)(this.txnMgr instanceof DbTxnManager));
        this.txnHandler = TxnUtils.getTxnStore((Configuration)conf);
    }

    @After
    public void tearDown() throws Exception {
        this.driver.close();
        if (this.txnMgr != null) {
            this.txnMgr.closeTxnManager();
        }
    }

    @Test
    public void testMetadataOperationLocks() throws Exception {
        boolean isStrict = conf.getBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE, false);
        this.dropTable(new String[]{"T"});
        this.checkCmdOnDriver(this.driver.run("create table if not exists T (a int, b int)"));
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into T values (1,2)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("alter table T SET TBLPROPERTIES ('transactional'='true')", true));
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T", null, locks);
        txnMgr2.rollbackTxn();
        this.txnMgr.commitTxn();
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE, isStrict);
    }

    @Test
    public void testLocksInSubquery() throws Exception {
        this.dropTable(new String[]{"T", "S", "R"});
        this.checkCmdOnDriver(this.driver.run("create table if not exists T (a int, b int)"));
        this.checkCmdOnDriver(this.driver.run("create table if not exists S (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')"));
        this.checkCmdOnDriver(this.driver.run("create table if not exists R (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')"));
        this.checkCmdOnDriver(this.driver.compileAndRespond("delete from S where a in (select a from T where b = 1)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "one");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "S", null, locks);
        this.txnMgr.rollbackTxn();
        this.checkCmdOnDriver(this.driver.compileAndRespond("update S set a = 7 where a in (select a from T where b = 1)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "one");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "S", null, locks);
        this.txnMgr.rollbackTxn();
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into R select * from S where a in (select a from T where b = 1)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "three");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "S", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "R", null, locks);
        this.txnMgr.rollbackTxn();
    }

    @Test
    public void createTable() throws Exception {
        this.dropTable(new String[]{"T"});
        CommandProcessorResponse cpr = this.driver.compileAndRespond("create table if not exists T (a int, b int)", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", null, null, locks);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
    }

    @Test
    public void insertOverwriteCreate() throws Exception {
        this.insertOverwriteCreate(false);
    }

    @Test
    public void insertOverwriteCreateAcid() throws Exception {
        this.insertOverwriteCreate(true);
    }

    private void insertOverwriteCreate(boolean isTransactional) throws Exception {
        if (isTransactional) {
            MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)true);
        }
        this.dropTable(new String[]{"T2", "T3"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists T2(a int)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table T3(a int) stored as ORC");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("insert overwrite table T3 select a from T2", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T2", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T3", null, locks);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
        cpr = this.driver.run("drop table if exists T1");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop table if exists T2");
        this.checkCmdOnDriver(cpr);
    }

    @Test
    public void insertOverwritePartitionedCreate() throws Exception {
        this.insertOverwritePartitionedCreate(true);
    }

    @Test
    public void insertOverwritePartitionedCreateAcid() throws Exception {
        this.insertOverwritePartitionedCreate(false);
    }

    private void insertOverwritePartitionedCreate(boolean isTransactional) throws Exception {
        this.dropTable(new String[]{"T4", "T5"});
        if (isTransactional) {
            MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)true);
        }
        CommandProcessorResponse cpr = this.driver.run("create table T4(name string, gpa double) partitioned by (age int) stored as ORC");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table T5(name string, age int, gpa double)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("INSERT OVERWRITE TABLE T4 PARTITION (age) SELECT name, age, gpa FROM T5", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T5", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T4", null, locks);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
        cpr = this.driver.run("drop table if exists T5");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop table if exists T4");
        this.checkCmdOnDriver(cpr);
    }

    @Test
    public void basicBlocking() throws Exception {
        this.dropTable(new String[]{"T6"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists T6(a int)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("select a from T6", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List selectLocks = this.ctx.getHiveLocks();
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        cpr = this.driver.compileAndRespond("drop table if exists T6", true);
        this.checkCmdOnDriver(cpr);
        LockState lockState = ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T6", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T6", null, locks);
        this.txnMgr.rollbackTxn();
        lockState = ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(1).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T6", null, locks);
        txnMgr2.rollbackTxn();
        cpr = this.driver.run("drop table if exists T6");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected number of locks found", (long)0L, (long)locks.size());
        this.checkCmdOnDriver(cpr);
    }

    @Test
    public void lockConflictDbTable() throws Exception {
        this.dropTable(new String[]{"temp.T7"});
        CommandProcessorResponse cpr = this.driver.run("create database if not exists temp");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists temp.T7(a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("update temp.T7 set a = 5 where b = 6", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("drop database if exists temp", true));
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "temp", "T7", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "temp", null, null, locks);
        this.txnMgr.commitTxn();
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(locks.get(1).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "temp", null, null, locks);
        txnMgr2.commitTxn();
    }

    @Test
    public void updateSelectUpdate() throws Exception {
        this.dropTable(new String[]{"T8"});
        CommandProcessorResponse cpr = this.driver.run("create table T8(a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("delete from T8 where b = 89", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.run("start transaction"));
        cpr = this.driver.compileAndRespond("select a from T8", true);
        this.checkCmdOnDriver(cpr);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler");
        this.checkCmdOnDriver(this.driver.compileAndRespond("update T8 set a = 1 where b = 1", true));
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T8", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "T8", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "T8", null, locks);
        this.driver.releaseLocksAndCommitOrRollback(false, this.txnMgr);
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(locks.get(2).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T8", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "T8", null, locks);
        this.driver.releaseLocksAndCommitOrRollback(true, txnMgr2);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        cpr = this.driver.run("drop table if exists T6");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected number of locks found", (long)0L, (long)locks.size());
        this.checkCmdOnDriver(cpr);
    }

    @Test
    public void testLockRetryLimit() throws Exception {
        this.dropTable(new String[]{"T9"});
        conf.setIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES, 2);
        conf.setBoolVar(HiveConf.ConfVars.TXN_MGR_DUMP_LOCK_STATE_ON_ACQUIRE_TIMEOUT, true);
        CommandProcessorResponse cpr = this.driver.run("create table T9(a int)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("select * from T9", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Vincent Vega");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T9", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        cpr = this.driver.compileAndRespond("drop table T9", true);
        this.checkCmdOnDriver(cpr);
        try {
            txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Winston Winnfield");
        }
        catch (LockException ex) {
            Assert.assertEquals((String)"Got wrong lock exception", (Object)ErrorMsg.LOCK_ACQUIRE_TIMEDOUT, (Object)ex.getCanonicalErrorMsg());
        }
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T9", null, locks);
        txnMgr2.closeTxnManager();
    }

    @Test
    public void testLockBlockedBy() throws Exception {
        this.dropTable(new String[]{"TAB_BLOCKED"});
        CommandProcessorResponse cpr = this.driver.run("create table TAB_BLOCKED (a int, b int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("select * from TAB_BLOCKED", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "I AM SAM");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_BLOCKED", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        cpr = this.driver.compileAndRespond("drop table TAB_BLOCKED", true);
        this.checkCmdOnDriver(cpr);
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "SAM I AM", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_BLOCKED", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "TAB_BLOCKED", null, locks);
        Assert.assertEquals((String)"BlockedByExtId doesn't match", (long)locks.get(0).getLockid(), (long)locks.get(1).getBlockedByExtId());
        Assert.assertEquals((String)"BlockedByIntId doesn't match", (long)locks.get(0).getLockIdInternal(), (long)locks.get(1).getBlockedByIntId());
    }

    @Test
    public void testDummyTxnManagerOnAcidTable() throws Exception {
        this.dropTable(new String[]{"T10", "T11"});
        CommandProcessorResponse cpr = this.driver.run("create table T10 (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table T11 (a int, b int) clustered by(b) into 2 buckets stored as orc");
        this.checkCmdOnDriver(cpr);
        this.useDummyTxnManagerTemporarily(conf);
        cpr = this.driver.compileAndRespond("select * from T10", true);
        Assert.assertEquals((long)ErrorMsg.TXNMGR_NOT_ACID.getErrorCode(), (long)cpr.getResponseCode());
        Assert.assertTrue((boolean)cpr.getErrorMessage().contains("This command is not allowed on an ACID table"));
        this.useDummyTxnManagerTemporarily(conf);
        cpr = this.driver.compileAndRespond("insert into table T10 values (1, 2)", true);
        Assert.assertEquals((long)ErrorMsg.TXNMGR_NOT_ACID.getErrorCode(), (long)cpr.getResponseCode());
        Assert.assertTrue((boolean)cpr.getErrorMessage().contains("This command is not allowed on an ACID table"));
        this.useDummyTxnManagerTemporarily(conf);
        cpr = this.driver.compileAndRespond("update T10 set a=0 where b=1", true);
        Assert.assertEquals((long)ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getErrorCode(), (long)cpr.getResponseCode());
        Assert.assertTrue((boolean)cpr.getErrorMessage().contains("Attempt to do update or delete using transaction manager that does not support these operations."));
        this.useDummyTxnManagerTemporarily(conf);
        cpr = this.driver.compileAndRespond("delete from T10", true);
        Assert.assertEquals((long)ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getErrorCode(), (long)cpr.getResponseCode());
        Assert.assertTrue((boolean)cpr.getErrorMessage().contains("Attempt to do update or delete using transaction manager that does not support these operations."));
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
    }

    private void useDummyTxnManagerTemporarily(HiveConf hiveConf) throws Exception {
        hiveConf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager");
        this.txnMgr = SessionState.get().initTxnMgr(hiveConf);
        Assert.assertTrue((boolean)(this.txnMgr instanceof DummyTxnManager));
    }

    @Test
    public void testMetastoreTablesCleanup() throws Exception {
        this.dropTable(new String[]{"temp.T10", "temp.T11", "temp.T12p", "temp.T13p"});
        CommandProcessorResponse cpr = this.driver.run("create database if not exists temp");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table temp.T10 (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table temp.T11 (a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table temp.T12p (a int, b int) partitioned by (ds string, hour string) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table temp.T13p (a int, b int) partitioned by (ds string, hour string) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T10 values (1, 1)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T10 values (2, 2)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T11 values (3, 3)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T11 values (4, 4)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T12p partition (ds='today', hour='1') values (5, 5)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T12p partition (ds='tomorrow', hour='2') values (6, 6)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T13p partition (ds='today', hour='1') values (7, 7)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T13p partition (ds='tomorrow', hour='2') values (8, 8)");
        this.checkCmdOnDriver(cpr);
        int count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_DATABASE='temp' and CTC_TABLE in ('t10', 't11')");
        Assert.assertEquals((long)4L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_DATABASE='temp' and CTC_TABLE in ('t12p', 't13p')");
        Assert.assertEquals((long)4L, (long)count);
        conf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, true);
        cpr = this.driver.run("insert into temp.T10 values (9, 9)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T11 values (10, 10)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T12p partition (ds='today', hour='1') values (11, 11)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into temp.T13p partition (ds='today', hour='1') values (12, 12)");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from TXN_COMPONENTS where TC_DATABASE='temp' and TC_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)4L, (long)count);
        conf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN, false);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from TXN_COMPONENTS where TC_DATABASE='temp' and TC_TABLE='t10'");
        Assert.assertEquals((long)1L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_DATABASE='temp' and CTC_TABLE='t10'");
        Assert.assertEquals((long)2L, (long)count);
        cpr = this.driver.run("drop table temp.T10");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from TXN_COMPONENTS where TC_DATABASE='temp' and TC_TABLE='t10'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_DATABASE='temp' and CTC_TABLE='t10'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from TXN_COMPONENTS where TC_DATABASE='temp' and TC_TABLE='t12p' and TC_PARTITION='ds=today/hour=1'");
        Assert.assertEquals((long)1L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_DATABASE='temp' and CTC_TABLE='t12p' and CTC_PARTITION='ds=today/hour=1'");
        Assert.assertEquals((long)1L, (long)count);
        cpr = this.driver.run("alter table temp.T12p drop partition (ds='today', hour='1')");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from TXN_COMPONENTS where TC_DATABASE='temp' and TC_TABLE='t12p' and TC_PARTITION='ds=today/hour=1'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_DATABASE='temp' and CTC_TABLE='t12p' and CTC_PARTITION='ds=today/hour=1'");
        Assert.assertEquals((long)0L, (long)count);
        cpr = this.driver.run("alter table temp.T11 compact 'minor'");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t11' and CQ_STATE='i' and CQ_TYPE='i'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runWorker(conf);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t11' and CQ_STATE='r' and CQ_TYPE='i'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runCleaner(conf);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t11'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_COMPACTIONS where CC_DATABASE='temp' and CC_TABLE='t11' and CC_STATE='s' and CC_TYPE='i'");
        Assert.assertEquals((long)1L, (long)count);
        cpr = this.driver.run("alter table temp.T12p partition (ds='tomorrow', hour='2') compact 'minor'");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t12p' and CQ_PARTITION='ds=tomorrow/hour=2' and CQ_STATE='i' and CQ_TYPE='i'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runWorker(conf);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t12p' and CQ_PARTITION='ds=tomorrow/hour=2' and CQ_STATE='r' and CQ_TYPE='i'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runCleaner(conf);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t12p'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_COMPACTIONS where CC_DATABASE='temp' and CC_TABLE='t12p' and CC_STATE='s' and CC_TYPE='i'");
        Assert.assertEquals((long)1L, (long)count);
        conf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, true);
        cpr = this.driver.run("alter table temp.T11 compact 'major'");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t11' and CQ_STATE='i' and CQ_TYPE='a'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runWorker(conf);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t11' and CQ_STATE='i' and CQ_TYPE='a'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_COMPACTIONS where CC_DATABASE='temp' and CC_TABLE='t11' and CC_STATE='f' and CC_TYPE='a'");
        Assert.assertEquals((long)1L, (long)count);
        cpr = this.driver.run("alter table temp.T12p partition (ds='tomorrow', hour='2') compact 'major'");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t12p' and CQ_PARTITION='ds=tomorrow/hour=2' and CQ_STATE='i' and CQ_TYPE='a'");
        Assert.assertEquals((long)1L, (long)count);
        TestTxnCommands2.runWorker(conf);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t12p' and CQ_PARTITION='ds=tomorrow/hour=2' and CQ_STATE='i' and CQ_TYPE='a'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_COMPACTIONS where CC_DATABASE='temp' and CC_TABLE='t12p' and CC_STATE='f' and CC_TYPE='a'");
        Assert.assertEquals((long)1L, (long)count);
        conf.setBoolVar(HiveConf.ConfVars.HIVETESTMODEFAILCOMPACTION, false);
        cpr = this.driver.run("alter table temp.T11 compact 'major'");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t11' and CQ_STATE='i' and CQ_TYPE='a'");
        Assert.assertEquals((long)1L, (long)count);
        cpr = this.driver.run("alter table temp.T12p partition (ds='tomorrow', hour='2') compact 'major'");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t12p' and CQ_PARTITION='ds=tomorrow/hour=2' and CQ_STATE='i' and CQ_TYPE='a'");
        Assert.assertEquals((long)1L, (long)count);
        cpr = this.driver.run("drop table temp.T11");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t11'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_COMPACTIONS where CC_DATABASE='temp' and CC_TABLE='t11'");
        Assert.assertEquals((long)0L, (long)count);
        cpr = this.driver.run("alter table temp.T12p drop partition (ds='tomorrow', hour='2')");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t12p'");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_COMPACTIONS where CC_DATABASE='temp' and CC_TABLE='t12p'");
        Assert.assertEquals((long)0L, (long)count);
        cpr = this.driver.run("alter table temp.T13p partition (ds='today', hour='1') compact 'major'");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE='t13p' and CQ_STATE='i' and CQ_TYPE='a'");
        Assert.assertEquals((long)1L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from TXN_COMPONENTS where TC_DATABASE='temp' and TC_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)1L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_DATABASE='temp' and CTC_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)2L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)1L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_COMPACTIONS where CC_DATABASE='temp' and CC_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
        cpr = this.driver.run("drop database if exists temp cascade");
        this.checkCmdOnDriver(cpr);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from TXN_COMPONENTS where TC_DATABASE='temp' and TC_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_DATABASE='temp' and CTC_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPACTION_QUEUE where CQ_DATABASE='temp' and CQ_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
        count = TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_COMPACTIONS where CC_DATABASE='temp' and CC_TABLE in ('t10', 't11', 't12p', 't13p')");
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void checkExpectedLocks() throws Exception {
        this.dropTable(new String[]{"acidPart", "nonAcidPart"});
        CommandProcessorResponse cpr = null;
        cpr = this.driver.run("create table acidPart(a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table nonAcidPart(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("insert into nonAcidPart partition(p) values(1,2,3)", true);
        this.checkCmdOnDriver(cpr);
        LockState lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "nonAcidPart", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        this.txnMgr.rollbackTxn();
        cpr = this.driver.compileAndRespond("insert into nonAcidPart partition(p=1) values(5,6)", true);
        this.checkCmdOnDriver(cpr);
        lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "nonAcidPart", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        this.txnMgr.rollbackTxn();
        cpr = this.driver.compileAndRespond("insert into acidPart partition(p) values(1,2,3)", true);
        this.checkCmdOnDriver(cpr);
        lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "acidPart", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        this.txnMgr.rollbackTxn();
        cpr = this.driver.compileAndRespond("insert into acidPart partition(p=1) values(5,6)", true);
        this.checkCmdOnDriver(cpr);
        lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "acidPart", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        this.txnMgr.rollbackTxn();
        cpr = this.driver.compileAndRespond("update acidPart set b = 17 where a = 1", true);
        this.checkCmdOnDriver(cpr);
        lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "acidPart", null, locks);
        this.txnMgr.rollbackTxn();
        cpr = this.driver.compileAndRespond("update acidPart set b = 17 where p = 1", true);
        this.checkCmdOnDriver(cpr);
        lockState = ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "Practical", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "acidPart", null, locks);
        this.txnMgr.rollbackTxn();
    }

    @Test
    public void checkExpectedLocks2() throws Exception {
        this.dropTable(new String[]{"tab_acid", "tab_not_acid"});
        this.checkCmdOnDriver(this.driver.run("create table if not exists tab_acid (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')"));
        this.checkCmdOnDriver(this.driver.run("create table if not exists tab_not_acid (na int, nb int) partitioned by (np string) clustered by (na) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='false')"));
        this.checkCmdOnDriver(this.driver.run("insert into tab_acid partition(p) (a,b,p) values(1,2,'foo'),(3,4,'bar')"));
        this.checkCmdOnDriver(this.driver.run("insert into tab_not_acid partition(np) (na,nb,np) values(1,2,'blah'),(3,4,'doh')"));
        this.txnMgr.openTxn(this.ctx, "T1");
        this.checkCmdOnDriver(this.driver.compileAndRespond("select * from tab_acid inner join tab_not_acid on a = na", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)6L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=doh", locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "T2");
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into tab_not_acid partition(np='doh') values(5,6)", true));
        LockState ls = ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "T2", false);
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)8L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=doh", locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "tab_not_acid", "np=doh", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "_dummy_database", "_dummy_table", null, locks);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE, false);
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr3.openTxn(this.ctx, "T3");
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into tab_not_acid partition(np='blah') values(7,8)", true));
        ((DbTxnManager)txnMgr3).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(txnMgr3);
        Assert.assertEquals((String)"Unexpected lock count", (long)10L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=bar", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_acid", "p=foo", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=doh", locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "tab_not_acid", "np=doh", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "_dummy_database", "_dummy_table", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", "np=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_TXN_STRICT_LOCKING_MODE, true);
    }

    @Test
    public void testLockingOnInsertIntoNonNativeTables() throws Exception {
        this.dropTable(new String[]{"tab_not_acid"});
        this.checkCmdOnDriver(this.driver.run("create table if not exists tab_not_acid (a int, b int)   STORED BY 'org.apache.hadoop.hive.ql.metadata.StorageHandlerMock'"));
        this.txnMgr.openTxn(this.ctx, "T1");
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into tab_not_acid values(1,2)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "tab_not_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
    }

    @Test
    public void testLockingOnInsertOverwriteNonNativeTables() throws Exception {
        this.dropTable(new String[]{"tab_not_acid"});
        this.checkCmdOnDriver(this.driver.run("create table if not exists tab_not_acid (a int, b int)   STORED BY 'org.apache.hadoop.hive.ql.metadata.StorageHandlerMock'"));
        this.txnMgr.openTxn(this.ctx, "T1");
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert overwrite table tab_not_acid values(1,2)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "tab_not_acid", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
    }

    public static ShowLocksResponseElement checkLock(LockType expectedType, LockState expectedState, String expectedDb, String expectedTable, String expectedPartition, List<ShowLocksResponseElement> actuals) {
        for (ShowLocksResponseElement actual : actuals) {
            if (expectedType != actual.getType() || expectedState != actual.getState() || !StringUtils.equals((CharSequence)TestDbTxnManager2.normalizeCase(expectedDb), (CharSequence)TestDbTxnManager2.normalizeCase(actual.getDbname())) || !StringUtils.equals((CharSequence)TestDbTxnManager2.normalizeCase(expectedTable), (CharSequence)TestDbTxnManager2.normalizeCase(actual.getTablename())) || !StringUtils.equals((CharSequence)TestDbTxnManager2.normalizeCase(expectedPartition), (CharSequence)TestDbTxnManager2.normalizeCase(actual.getPartname()))) continue;
            return actual;
        }
        Assert.fail((String)("Could't find {" + expectedType + ", " + expectedState + ", " + expectedDb + ", " + expectedTable + ", " + expectedPartition + "} in " + actuals));
        throw new IllegalStateException("How did it get here?!");
    }

    private static HiveTxnManager swapTxnManager(HiveTxnManager txnMgr) {
        return SessionState.get().setTxnMgr(txnMgr);
    }

    @Test
    public void testShowLocksFilterOptions() throws Exception {
        CommandProcessorResponse cpr = this.driver.run("drop table if exists db1.t14");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop table if exists db2.t14");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop table if exists db2.t15");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop table if exists db2.t16");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop database if exists db1");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("drop database if exists db2");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create database if not exists db1");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create database if not exists db2");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists db1.t14 (a int, b int) partitioned by (ds string) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists db2.t14 (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists db2.t15 (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists db2.t16 (a int, b int) clustered by (b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        HiveTxnManager txnMgr1 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr1);
        cpr = this.driver.compileAndRespond("insert into table db1.t14 partition (ds='today') values (1, 2)", true);
        this.checkCmdOnDriver(cpr);
        txnMgr1.acquireLocks(this.driver.getPlan(), this.ctx, "Tom");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        cpr = this.driver.compileAndRespond("insert into table db1.t14 partition (ds='tomorrow') values (3, 4)", true);
        this.checkCmdOnDriver(cpr);
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Jerry");
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr3);
        cpr = this.driver.compileAndRespond("select * from db2.t15", true);
        this.checkCmdOnDriver(cpr);
        txnMgr3.acquireLocks(this.driver.getPlan(), this.ctx, "Donald");
        HiveTxnManager txnMgr4 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr4);
        cpr = this.driver.compileAndRespond("select * from db2.t16", true);
        this.checkCmdOnDriver(cpr);
        txnMgr4.acquireLocks(this.driver.getPlan(), this.ctx, "Hillary");
        HiveTxnManager txnMgr5 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr5);
        cpr = this.driver.compileAndRespond("select * from db2.t14", true);
        this.checkCmdOnDriver(cpr);
        txnMgr5.acquireLocks(this.driver.getPlan(), this.ctx, "Obama");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)7L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=today", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=tomorrow", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t15", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t16", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t14", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        locks = this.getLocksWithFilterOptions(txnMgr3, "db2", null, null);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t15", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t16", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t14", null, locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        cpr = this.driver.run("use db1");
        this.checkCmdOnDriver(cpr);
        locks = this.getLocksWithFilterOptions(this.txnMgr, null, "t14", null);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=today", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=tomorrow", locks);
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("ds", "today");
        locks = this.getLocksWithFilterOptions(this.txnMgr, null, "t14", partSpec);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db1", "t14", "ds=today", locks);
        cpr = this.driver.run("use db2");
        this.checkCmdOnDriver(cpr);
        locks = this.getLocksWithFilterOptions(txnMgr3, null, "t15", null);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "db2", "t15", null, locks);
    }

    private void checkCmdOnDriver(CommandProcessorResponse cpr) {
        Assert.assertTrue((String)cpr.toString(), (cpr.getResponseCode() == 0 ? 1 : 0) != 0);
    }

    private static String normalizeCase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    private List<ShowLocksResponseElement> getLocks() throws Exception {
        return this.getLocks(this.txnMgr);
    }

    private List<ShowLocksResponseElement> getLocks(HiveTxnManager txnMgr) throws Exception {
        ShowLocksResponse rsp = ((DbLockManager)txnMgr.getLockManager()).getLocks();
        return rsp.getLocks();
    }

    @Test
    public void testWriteSetTracking1() throws Exception {
        this.dropTable(new String[]{"TAB_PART"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("select * from TAB_PART", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Nicholas");
        this.txnMgr.commitTxn();
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true));
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true));
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Alexandra");
        txnMgr2.commitTxn();
    }

    private void dropTable(String[] tabs) throws Exception {
        for (String tab : tabs) {
            this.driver.run("drop table if exists " + tab);
        }
    }

    @Test
    public void testWriteSetTracking2() throws Exception {
        this.dropTable(new String[]{"TAB_PART", "TAB2"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists TAB2 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        this.txnMgr.openTxn(this.ctx, "Peter");
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Peter");
        txnMgr2.openTxn(this.ctx, "Catherine");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", null, locks);
        this.txnMgr.commitTxn();
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB2 set b = 9 where p = 'doh'", true));
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Catherine");
        txnMgr2.commitTxn();
    }

    @Test
    public void testWriteSetTracking3() throws Exception {
        this.dropTable(new String[]{"TAB_PART"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into TAB_PART partition(p='blah') values(1,2)"));
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true));
        long txnId = this.txnMgr.getCurrentTxnId();
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Known");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true));
        long txnId2 = txnMgr2.getCurrentTxnId();
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Unknown", false);
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "TAB_PART", "p=blah", locks);
        long writeId = this.txnMgr.getTableWriteId("default", "TAB_PART");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, writeId, "default", "TAB_PART", Collections.singletonList("p=blah"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        adp.setTxnid(txnId2);
        writeId = txnMgr2.getTableWriteId("default", "TAB_PART");
        adp.setWriteid(writeId);
        this.txnHandler.addDynamicPartitions(adp);
        LockException expectedException = null;
        try {
            txnMgr2.commitTxn();
        }
        catch (LockException e) {
            expectedException = e;
        }
        Assert.assertTrue((String)"Didn't get exception", (expectedException != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Got wrong message code", (Object)ErrorMsg.TXN_ABORTED, (Object)expectedException.getCanonicalErrorMsg());
        Assert.assertEquals((String)"Exception msg didn't match", (Object)("Aborting [txnid:" + txnId2 + "," + txnId2 + "] due to a write conflict on default/tab_part/p=blah committed by [txnid:" + txnId + "," + txnId2 + "] u/u"), (Object)expectedException.getCause().getMessage());
    }

    @Test
    public void testWriteSetTracking4() throws Exception {
        this.dropTable(new String[]{"TAB_PART", "TAB2"});
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        CommandProcessorResponse cpr = this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists TAB2 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.openTxn(this.ctx, "Long Running");
        this.checkCmdOnDriver(this.driver.compileAndRespond("select a from  TAB_PART where p = 'blah'", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Long Running");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_PART", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "Short Running");
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB2 set b = 7 where p = 'blah'", true));
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Short Running");
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_PART", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", null, locks);
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest("default", "tab2");
        rqst.setTxnIds(Collections.singletonList(txnMgr2.getCurrentTxnId()));
        AllocateTableWriteIdsResponse writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        Assert.assertEquals((long)txnMgr2.getCurrentTxnId(), (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId(), "default", "tab2", Collections.EMPTY_LIST);
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        txnMgr2.openTxn(this.ctx, "T3");
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB2 set b = 7 where p = 'two'", true));
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T3");
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB_PART", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", null, locks);
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        rqst = new AllocateTableWriteIdsRequest("default", "tab2");
        rqst.setTxnIds(Collections.singletonList(txnMgr2.getCurrentTxnId()));
        writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        Assert.assertEquals((long)txnMgr2.getCurrentTxnId(), (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId(), "default", "tab2", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        AcidWriteSetService houseKeeper = new AcidWriteSetService();
        houseKeeper.setConf((Configuration)conf);
        houseKeeper.run();
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB2 set b = 17 where a = 1", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Long Running");
        rqst = new AllocateTableWriteIdsRequest("default", "tab2");
        rqst.setTxnIds(Collections.singletonList(this.txnMgr.getCurrentTxnId()));
        writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        Assert.assertEquals((long)this.txnMgr.getCurrentTxnId(), (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId(), "default", "tab2", Collections.EMPTY_LIST);
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)0L, (long)locks.size());
        houseKeeper.run();
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
    }

    @Test
    public void testWriteSetTracking5() throws Exception {
        this.dropTable(new String[]{"TAB_PART"});
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        CommandProcessorResponse cpr = this.driver.run("create table if not exists TAB_PART (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into TAB_PART partition(p='blah') values(1,2)"));
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        this.txnMgr.openTxn(this.ctx, "Known");
        long txnId = txnMgr2.openTxn(this.ctx, "Unknown");
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Known");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB_PART set b = 7 where p = 'blah'", true));
        ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Unknown", false);
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB_PART", "p=blah", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "TAB_PART", "p=blah", locks);
        this.txnMgr.rollbackTxn();
        AllocateTableWriteIdsRequest rqst = new AllocateTableWriteIdsRequest("default", "TAB_PART");
        rqst.setTxnIds(Collections.singletonList(txnId));
        AllocateTableWriteIdsResponse writeIds = this.txnHandler.allocateTableWriteIds(rqst);
        Assert.assertEquals((long)txnId, (long)((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getTxnId());
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId, ((TxnToWriteId)writeIds.getTxnToWriteIds().get(0)).getWriteId(), "default", "TAB_PART", Arrays.asList("p=blah"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        txnMgr2.commitTxn();
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
    }

    @Test
    public void testWriteSetTracking6() throws Exception {
        this.dropTable(new String[]{"TAB2"});
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        CommandProcessorResponse cpr = this.driver.run("create table if not exists TAB2(a int, b int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("select * from TAB2 where a = 113", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Works");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB2", null, locks);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update TAB2 set b = 17 where a = 101", true));
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Horton");
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB2", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", null, locks);
        txnMgr2.commitTxn();
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB2", null, locks);
        this.txnMgr.commitTxn();
        AcidWriteSetService writeSetService = new AcidWriteSetService();
        writeSetService.setConf((Configuration)conf);
        writeSetService.run();
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
    }

    @Test
    public void testWriteSetTracking7() throws Exception {
        this.dropTable(new String[]{"tab2", "TAB2"});
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET"));
        CommandProcessorResponse cpr = this.driver.run("create table if not exists tab2 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into tab2 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')"));
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update tab2 set b = 7 where p='two'", true));
        long idTxnUpdate1 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", "p=two", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update tab2 set b = 7 where p='one'", true));
        long idTxnUpdate2 = this.txnMgr.getCurrentTxnId();
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", "p=one", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab2");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab2", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB2", "p=one", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab2");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab2", Collections.singletonList("p=one"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=one' and ws_operation_type='u'"));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='u'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)4L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_table='tab2' and ctc_partition is not null"));
        cpr = this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')"));
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update tab1 set b = 7 where b=1", true));
        long idTxnUpdate3 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T5");
        locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update tab1 set b = 7 where b = 2", true));
        long idTxnUpdate4 = this.txnMgr.getCurrentTxnId();
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T6", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)4L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "TAB1", "p=one", locks);
        writeId = txnMgr2.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=one"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(2).getLockid());
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=one' and ws_operation_type='u' and ws_table='tab1'"));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='u' and ws_table='tab1'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)4L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_table='tab1' and ctc_partition is not null"));
    }

    @Test
    public void testWriteSetTracking8() throws Exception {
        this.dropTable(new String[]{"tab1", "TAB1"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')"));
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update tab1 set b = 7 where b=1", true));
        long idTxnUpdate1 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update tab1 set b = 7 where p='two'", true));
        long idTxnUpdate2 = this.txnMgr.getCurrentTxnId();
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "TAB1", "p=two", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab1");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=one"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(2).getLockid());
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=one' and ws_operation_type='u' and ws_table='tab1'"));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='u' and ws_table='tab1'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)4L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_table='tab1' and ctc_partition is not null"));
    }

    @Test
    public void testWriteSetTracking9() throws Exception {
        this.dropTable(new String[]{"TAB1"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')"));
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update tab1 set b = 7 where b=1", true));
        long idTxnUpdate1 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("delete from tab1 where p='two' and b=2", true));
        long idTxnDelete1 = this.txnMgr.getCurrentTxnId();
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "TAB1", "p=two", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab1");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=one"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(2).getLockid());
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=" + (idTxnUpdate1 - 1L) + "  and ctc_table='tab1'")));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=" + idTxnUpdate1 + "  and ctc_table='tab1' and ctc_partition='p=one'")));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=" + idTxnDelete1 + " and ctc_table='tab1' and ctc_partition='p=two'")));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=one' and ws_operation_type='u' and ws_table='tab1'"));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='d' and ws_table='tab1'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)4L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_table='tab1' and ctc_partition is not null"));
    }

    @Test
    public void testWriteSetTracking10() throws Exception {
        this.dropTable(new String[]{"TAB1"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')"));
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("update tab1 set b = 7 where b=2", true));
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("delete from tab1 where p='two' and b=2", true));
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "TAB1", "p=two", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab1");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(2).getLockid());
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        LockException exception = null;
        try {
            this.txnMgr.commitTxn();
        }
        catch (LockException e) {
            exception = e;
        }
        Assert.assertNotEquals((String)"Expected exception", null, (Object)((Object)exception));
        Assert.assertEquals((String)"Exception msg doesn't match", (Object)"Aborting [txnid:5,5] due to a write conflict on default/tab1/p=two committed by [txnid:4,5] d/u", (Object)exception.getCause().getMessage());
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='u' and ws_table='tab1'"));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)3L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_table='tab1' and ctc_partition is not null"));
    }

    @Test
    public void testWriteSetTracking11() throws Exception {
        this.dropTable(new String[]{"TAB1"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into tab1 partition(p)(a,b,p) values(1,1,'one'),(2,2,'two')"));
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("delete from tab1 where b=2", true));
        long txnIdDelete = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2");
        List<ShowLocksResponseElement> locks = this.getLocks(txnMgr2);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        this.checkCmdOnDriver(this.driver.run("start transaction"));
        this.checkCmdOnDriver(this.driver.compileAndRespond("select * from tab1 where b=1 and p='one'", true));
        long txnIdSelect = this.txnMgr.getCurrentTxnId();
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        this.checkCmdOnDriver(this.driver.compileAndRespond("delete from tab1 where p='two' and b=2", true));
        ((DbTxnManager)this.txnMgr).acquireLocks(this.driver.getPlan(), this.ctx, "T3", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB1", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "TAB1", "p=two", locks);
        long writeId = txnMgr2.getTableWriteId("default", "tab1");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnMgr2.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        txnMgr2.commitTxn();
        ((DbLockManager)this.txnMgr.getLockManager()).checkLock(locks.get(4).getLockid());
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB1", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "TAB1", "p=one", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "TAB1", "p=two", locks);
        writeId = this.txnMgr.getTableWriteId("default", "tab1");
        adp = new AddDynamicPartitions(this.txnMgr.getCurrentTxnId(), writeId, "default", "tab1", Collections.singletonList("p=two"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='d' and ws_table='tab1' and ws_txnid=" + txnIdDelete)));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='d' and ws_table='tab1' and ws_txnid=" + txnIdSelect)));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='d' and ws_table='tab1' and ws_txnid=" + txnIdDelete)));
        Assert.assertEquals((String)("WRITE_SET mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_partition='p=two' and ws_operation_type='d' and ws_table='tab1' and ws_txnid=" + txnIdSelect)));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch: " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)4L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_table='tab1' and ctc_partition is not null"));
    }

    @Test
    public void testCompletedTxnComponents() throws Exception {
        this.dropTable(new String[]{"TAB1", "tab_not_acid2"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists tab_not_acid2 (a int, b int)");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into tab_not_acid2 values(1,1),(2,2)"));
        this.checkCmdOnDriver(this.driver.run("from tab_not_acid2 insert into tab1 partition(p='two')(a,b) select a,b insert into tab_not_acid2(a,b) select a,b "));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=6 and ctc_table='tab1'"));
    }

    @Test
    public void testMultiInsert() throws Exception {
        this.dropTable(new String[]{"TAB1", "tab_not_acid"});
        this.checkCmdOnDriver(this.driver.run("drop table if exists tab1"));
        this.checkCmdOnDriver(this.driver.run("drop table if exists tab_not_acid"));
        CommandProcessorResponse cpr = this.driver.run("create table if not exists tab1 (a int, b int) partitioned by (p string) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists tab_not_acid (a int, b int, p string)");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into tab_not_acid values(1,1,'one'),(2,2,'two')"));
        this.checkCmdOnDriver(this.driver.run("insert into tab1 partition(p) values(3,3,'one'),(4,4,'two')"));
        this.checkCmdOnDriver(this.driver.run("from tab_not_acid insert into tab1 partition(p)(a,b,p) select a,b,p insert into tab_not_acid(a,b) select a,b where p='two'"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)4L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=9"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=9 and ctc_table='tab1'"));
    }

    private List<ShowLocksResponseElement> getLocksWithFilterOptions(HiveTxnManager txnMgr, String dbName, String tblName, Map<String, String> partSpec) throws Exception {
        if (dbName == null && tblName != null) {
            dbName = SessionState.get().getCurrentDatabase();
        }
        ShowLocksRequest rqst = new ShowLocksRequest();
        rqst.setDbname(dbName);
        rqst.setTablename(tblName);
        if (partSpec != null) {
            ArrayList<String> keyList = new ArrayList<String>();
            ArrayList<String> valList = new ArrayList<String>();
            for (String partKey : partSpec.keySet()) {
                String partVal = partSpec.remove(partKey);
                keyList.add(partKey);
                valList.add(partVal);
            }
            String partName = FileUtils.makePartName(keyList, valList);
            rqst.setPartname(partName);
        }
        ShowLocksResponse rsp = ((DbLockManager)txnMgr.getLockManager()).getLocks(rqst);
        return rsp.getLocks();
    }

    @Test
    public void testShowLocksAgentInfo() throws Exception {
        CommandProcessorResponse cpr = this.driver.run("create table if not exists XYZ (a int, b int)");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("select a from XYZ where b = 8", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "XYZ");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "XYZ", null, locks);
        Assert.assertEquals((String)"Wrong AgentInfo", (Object)this.driver.getPlan().getQueryId(), (Object)locks.get(0).getAgentInfo());
    }

    @Test
    public void testMerge3Way01() throws Exception {
        this.testMerge3Way(false);
    }

    @Test
    public void testMerge3Way02() throws Exception {
        this.testMerge3Way(true);
    }

    private void testMerge3Way(boolean cc) throws Exception {
        this.dropTable(new String[]{"target", "source", "source2"});
        this.checkCmdOnDriver(this.driver.run("create table target (a int, b int) partitioned by (p int, q int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')"));
        this.checkCmdOnDriver(this.driver.run("insert into target partition(p,q) values (1,2,1,2), (3,4,1,2), (5,6,1,3), (7,8,2,2)"));
        this.checkCmdOnDriver(this.driver.run("create table source (a int, b int, p int, q int)"));
        this.checkCmdOnDriver(this.driver.run("insert into source values (9,10,1,2),        (3,4,1,2), (11,12,1,3), (5,13,1,3), (7,8,2,2), (14,15,1,1)"));
        this.checkCmdOnDriver(this.driver.run("create table source2 (a int, b int, p int, q int)"));
        this.checkCmdOnDriver(this.driver.run("insert into source2 values (9,100,1,2),      (3,4,1,2),               (5,13,1,3),       (7,8,2,2), (14,15,2,1)"));
        this.checkCmdOnDriver(this.driver.compileAndRespond("merge into target t using source s on t.a=s.b when matched and t.a=5 then update set b=s.b when matched and t.a in (3,7) then delete when not matched and t.a >= 8 then insert values(s.a, s.b, s.p, s.q)", true));
        long txnId1 = this.txnMgr.getCurrentTxnId();
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=2/q=2", locks);
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("merge into target t using source2 s on t.a=s.b when matched and t.a=" + (cc ? 5 : 9) + " then update set b=s.b when matched and t.a in (3,7) then delete when not matched and t.a >= 8 then insert values(s.a, s.b, s.p, s.q)", true));
        long txnId2 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T1", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)10L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=2/q=2", locks);
        long extLockId = TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "target", null, locks).getLockid();
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "source2", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "target", "p=2/q=2", locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId1)));
        long writeId = this.txnMgr.getTableWriteId("default", "target");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId1, writeId, "default", "target", Collections.singletonList("p=1/q=3"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        adp = new AddDynamicPartitions(txnId1, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=2/q=2"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        adp = new AddDynamicPartitions(txnId1, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=3", "p=1/q=1"));
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId1 + " and tc_operation_type='u'")));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId1 + " and tc_operation_type='d'")));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)3L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId1 + " and tc_operation_type='i'")));
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)6L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=" + txnId1)));
        Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnId1 + " and ws_operation_type='u'")));
        Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnId1 + " and ws_operation_type='d'")));
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(extLockId);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source2", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=2/q=2", locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId2)));
        writeId = txnMgr2.getTableWriteId("default", "target");
        adp = new AddDynamicPartitions(txnId2, writeId, "default", "target", Collections.singletonList(cc ? "p=1/q=3" : "p=1/p=2"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        adp = new AddDynamicPartitions(txnId2, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=2/q=2"));
        adp.setOperationType(DataOperationType.DELETE);
        this.txnHandler.addDynamicPartitions(adp);
        adp = new AddDynamicPartitions(txnId2, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=3", "p=1/q=1"));
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId2 + " and tc_operation_type='u'")));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId2 + " and tc_operation_type='d'")));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)3L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId2 + " and tc_operation_type='i'")));
        LockException expectedException = null;
        try {
            txnMgr2.commitTxn();
        }
        catch (LockException e) {
            expectedException = e;
        }
        if (cc) {
            Assert.assertNotNull((String)"didn't get exception", (Object)((Object)expectedException));
            Assert.assertEquals((Object)"Transaction manager has aborted the transaction txnid:11.  Reason: Aborting [txnid:11,11] due to a write conflict on default/target/p=1/q=3 committed by [txnid:10,11] u/u", (Object)expectedException.getMessage());
            Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=" + txnId2)));
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnId2)));
        } else {
            Assert.assertNull((String)("Unexpected exception " + expectedException), (Object)((Object)expectedException));
            Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)6L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=" + txnId2)));
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnId2 + " and ws_operation_type='u'")));
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnId2 + " and ws_operation_type='d'")));
        }
    }

    @Test
    public void testMergeUnpartitioned01() throws Exception {
        this.testMergeUnpartitioned(true);
    }

    @Test
    public void testMergeUnpartitioned02() throws Exception {
        this.testMergeUnpartitioned(false);
    }

    private void testMergeUnpartitioned(boolean causeConflict) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        this.checkCmdOnDriver(this.driver.run("create table target (a int, b int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')"));
        this.checkCmdOnDriver(this.driver.run("insert into target values (1,2), (3,4), (5,6), (7,8)"));
        this.checkCmdOnDriver(this.driver.run("create table source (a int, b int)"));
        if (causeConflict) {
            this.checkCmdOnDriver(this.driver.compileAndRespond("update target set b = 2 where a=1", true));
        } else {
            this.checkCmdOnDriver(this.driver.compileAndRespond("insert into target values(9,10),(11,12)", true));
        }
        long txnid1 = this.txnMgr.getCurrentTxnId();
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnid1)));
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        if (causeConflict) {
            Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
            TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", null, locks);
        } else {
            Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        }
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("merge into target t using source s on t.a=s.a when matched then delete when not matched then insert values(s.a,s.b)", true));
        long txnid2 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)(causeConflict ? 3L : 4L), (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, causeConflict ? LockState.WAITING : LockState.ACQUIRED, "default", "source", null, locks);
        long extLockId = TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, causeConflict ? LockState.WAITING : LockState.ACQUIRED, "default", "target", null, locks).getLockid();
        if (!causeConflict) {
            TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        }
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)(causeConflict ? 1L : 0L), (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnid1 + " and ws_operation_type=" + (causeConflict ? "'u'" : "'i'"))));
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(extLockId);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", null, locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnid2)));
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnid2 + "and tc_operation_type='d'")));
        LockException expectedException = null;
        try {
            txnMgr2.commitTxn();
        }
        catch (LockException e) {
            expectedException = e;
        }
        if (causeConflict) {
            Assert.assertTrue((String)"Didn't get exception", (expectedException != null ? 1 : 0) != 0);
            Assert.assertEquals((String)"Got wrong message code", (Object)ErrorMsg.TXN_ABORTED, (Object)expectedException.getCanonicalErrorMsg());
            Assert.assertEquals((String)"Exception msg didn't match", (Object)"Aborting [txnid:7,7] due to a write conflict on default/target committed by [txnid:6,7] d/u", (Object)expectedException.getCause().getMessage());
        } else {
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnid2 + " and ws_operation_type='d'")));
        }
    }

    @Test
    public void testDynamicPartitionInsert() throws Exception {
        this.dropTable(new String[]{"target"});
        this.checkCmdOnDriver(this.driver.run("create table target (a int, b int) partitioned by (p int, q int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')"));
        long txnid1 = this.txnMgr.openTxn(this.ctx, "T1");
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into target partition(p=1,q) values (1,2,2), (3,4,2), (5,6,3), (7,8,2)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        Assert.assertEquals((String)("HIVE_LOCKS mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from HIVE_LOCKS")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from HIVE_LOCKS where hl_txnid=" + txnid1)));
        this.txnMgr.rollbackTxn();
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnid1)));
        this.checkCmdOnDriver(this.driver.run("insert into target partition(p=1,q) values (1,2,2), (3,4,2), (5,6,3), (7,8,2)"));
        this.driver.run("select count(*) from target");
        ArrayList r = new ArrayList();
        this.driver.getResults(r);
        Assert.assertEquals((String)"", (Object)"4", r.get(0));
        Assert.assertEquals((String)("COMPLETED_TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)(txnid1 + 1L)) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from COMPLETED_TXN_COMPONENTS")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from COMPLETED_TXN_COMPONENTS where ctc_txnid=" + (txnid1 + 1L))));
        long txnid2 = this.txnMgr.openTxn(this.ctx, "T1");
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into target partition(p=1,q) values (10,2,2), (30,4,2), (50,6,3), (70,8,2)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        long writeId = this.txnMgr.getTableWriteId("default", "target");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnid2, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=2"));
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnid2)));
        this.txnMgr.commitTxn();
    }

    @Test
    public void testMergePartitioned01() throws Exception {
        this.testMergePartitioned(false);
    }

    @Test
    public void testMergePartitioned02() throws Exception {
        this.testMergePartitioned(true);
    }

    private void testMergePartitioned(boolean causeConflict) throws Exception {
        this.dropTable(new String[]{"target", "source"});
        this.checkCmdOnDriver(this.driver.run("create table target (a int, b int) partitioned by (p int, q int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='true')"));
        this.checkCmdOnDriver(this.driver.run("insert into target partition(p,q) values (1,2,1,2), (3,4,1,2), (5,6,1,3), (7,8,2,2)"));
        this.checkCmdOnDriver(this.driver.run("create table source (a1 int, b1 int, p1 int, q1 int)"));
        this.checkCmdOnDriver(this.driver.compileAndRespond("update target set b = 2 where p=1", true));
        long txnId1 = this.txnMgr.getCurrentTxnId();
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "T1");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("merge into target using source on target.p=source.p1 and target.a=source.a1 when matched then update set b = 11 when not matched then insert values(a1,b1,p1,q1)", true));
        long txnid2 = txnMgr2.getCurrentTxnId();
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "T2", false);
        locks = this.getLocks(this.txnMgr);
        Assert.assertEquals((String)"Unexpected lock count", (long)7L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "source", null, locks);
        long extLockId = TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "target", null, locks).getLockid();
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.WAITING, "default", "target", "p=2/q=2", locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId1)));
        long writeId = this.txnMgr.getTableWriteId("default", "target");
        AddDynamicPartitions adp = new AddDynamicPartitions(txnId1, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=3"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnId1 + " and tc_operation_type='u'")));
        this.txnMgr.commitTxn();
        Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnId1) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnId1 + " and ws_operation_type='u'")));
        ((DbLockManager)txnMgr2.getLockManager()).checkLock(extLockId);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)5L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "source", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "target", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=1/q=3", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_WRITE, LockState.ACQUIRED, "default", "target", "p=2/q=2", locks);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnid2)));
        writeId = txnMgr2.getTableWriteId("default", "target");
        adp = new AddDynamicPartitions(txnid2, writeId, "default", "target", Arrays.asList("p=1/q=2", "p=1/q=3"));
        adp.setOperationType(DataOperationType.INSERT);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnid2 + " and tc_operation_type='i'")));
        adp = new AddDynamicPartitions(txnid2, writeId, "default", "target", Collections.singletonList(causeConflict ? "p=1/q=2" : "p=1/q=1"));
        adp.setOperationType(DataOperationType.UPDATE);
        this.txnHandler.addDynamicPartitions(adp);
        Assert.assertEquals((String)("TXN_COMPONENTS mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from TXN_COMPONENTS")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from TXN_COMPONENTS where tc_txnid=" + txnid2 + " and tc_operation_type='u'")));
        LockException expectedException = null;
        try {
            txnMgr2.commitTxn();
        }
        catch (LockException e) {
            expectedException = e;
        }
        if (causeConflict) {
            Assert.assertTrue((String)"Didn't get exception", (expectedException != null ? 1 : 0) != 0);
            Assert.assertEquals((String)"Got wrong message code", (Object)ErrorMsg.TXN_ABORTED, (Object)expectedException.getCanonicalErrorMsg());
            Assert.assertEquals((String)"Exception msg didn't match", (Object)"Aborting [txnid:7,7] due to a write conflict on default/target/p=1/q=2 committed by [txnid:6,7] u/u", (Object)expectedException.getCause().getMessage());
        } else {
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnid2 + " and ws_operation_type='u'")));
            Assert.assertEquals((String)("WRITE_SET mismatch(" + JavaUtils.txnIdToString((long)txnid2) + "): " + TxnDbUtil.queryToString((Configuration)conf, (String)"select * from WRITE_SET")), (long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)conf, (String)("select count(*) from WRITE_SET where ws_txnid=" + txnid2)));
        }
    }

    @Test
    public void testShowTablesLock() throws Exception {
        this.dropTable(new String[]{"T", "T2"});
        CommandProcessorResponse cpr = this.driver.run("create table T (a int, b int)");
        this.checkCmdOnDriver(cpr);
        long txnid1 = this.txnMgr.openTxn(this.ctx, "Fifer");
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into T values(1,3)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "t", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        DbTxnManager txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "Fidler");
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("show tables", true));
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Fidler");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "t", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", null, null, locks);
        this.txnMgr.commitTxn();
        txnMgr2.rollbackTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks((HiveTxnManager)txnMgr2).size());
        TestDbTxnManager2.swapTxnManager(this.txnMgr);
        cpr = this.driver.run("create table T2 (a int, b int) partitioned by (p int) clustered by (a) into 2  buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.compileAndRespond("insert into T2 partition(p=1) values(1,3)", true));
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "t2", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        txnMgr2 = (DbTxnManager)TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        txnMgr2.openTxn(this.ctx, "Fidler");
        TestDbTxnManager2.swapTxnManager((HiveTxnManager)txnMgr2);
        this.checkCmdOnDriver(this.driver.compileAndRespond("show tables", true));
        txnMgr2.acquireLocks(this.driver.getPlan(), this.ctx, "Fidler", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "t2", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "_dummy_database", "_dummy_table", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", null, null, locks);
        this.txnMgr.commitTxn();
        txnMgr2.commitTxn();
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks().size());
        Assert.assertEquals((String)"Lock remained", (long)0L, (long)this.getLocks((HiveTxnManager)txnMgr2).size());
    }

    @Test
    public void testFairness() throws Exception {
        this.dropTable(new String[]{"T6"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists T6(a int)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("select a from T6", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        cpr = this.driver.compileAndRespond("drop table if exists T6", true);
        this.checkCmdOnDriver(cpr);
        LockState lockState = ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)2L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T6", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T6", null, locks);
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr3);
        cpr = this.driver.compileAndRespond("select a from T6", true);
        this.checkCmdOnDriver(cpr);
        ((DbTxnManager)txnMgr3).acquireLocks(this.driver.getPlan(), this.ctx, "Fifer", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T6", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T6", null, locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T6", null, locks);
    }

    @Test
    public void testFairness2() throws Exception {
        this.dropTable(new String[]{"T7"});
        CommandProcessorResponse cpr = this.driver.run("create table if not exists T7 (a int) partitioned by (p int) stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into T7 partition(p) values(1,1),(1,2)"));
        cpr = this.driver.compileAndRespond("select a from T7 ", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr2);
        cpr = this.driver.compileAndRespond("alter table T7 drop partition (p=1)", true);
        this.checkCmdOnDriver(cpr);
        LockState lockState = ((DbTxnManager)txnMgr2).acquireLocks(this.driver.getPlan(), this.ctx, "Fiddler", false);
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)4L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=2", locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T7", "p=1", locks);
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        TestDbTxnManager2.swapTxnManager(txnMgr3);
        cpr = this.driver.compileAndRespond("select a from T7", true);
        this.checkCmdOnDriver(cpr);
        ((DbTxnManager)txnMgr3).acquireLocks(this.driver.getPlan(), this.ctx, "Fifer", false);
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)7L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=2", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", "p=2", locks);
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.WAITING, "default", "T7", "p=1", locks);
        this.txnMgr.commitTxn();
        lockState = ((DbLockManager)txnMgr2.getLockManager()).checkLock(locks.get(6).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)4L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T7", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.WAITING, "default", "T7", "p=2", locks);
        txnMgr2.rollbackTxn();
        lockState = ((DbLockManager)txnMgr2.getLockManager()).checkLock(locks.get(1).getLockid());
        locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)3L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", null, locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=1", locks);
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", "T7", "p=2", locks);
    }

    @Test
    public void testValidWriteIdListSnapshot() throws Exception {
        this.dropTable(new String[]{"temp.T7"});
        CommandProcessorResponse cpr = this.driver.run("create database if not exists temp");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table if not exists temp.T7(a int, b int) clustered by(b) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        long baseTxnId = this.txnMgr.openTxn(this.ctx, "u0");
        long baseWriteId = this.txnMgr.getTableWriteId("temp", "T7");
        Assert.assertEquals((long)1L, (long)baseWriteId);
        this.txnMgr.commitTxn();
        HiveTxnManager txnMgr1 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        long underHwmOpenTxnId = txnMgr1.openTxn(this.ctx, "u1");
        Assert.assertTrue((String)"Invalid txn ID", (underHwmOpenTxnId > baseTxnId ? 1 : 0) != 0);
        HiveTxnManager txnMgr2 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        long testTxnId = txnMgr2.openTxn(this.ctx, "u2");
        Assert.assertTrue((String)"Invalid txn ID", (testTxnId > underHwmOpenTxnId ? 1 : 0) != 0);
        String testValidTxns = txnMgr2.getValidTxns().toString();
        ValidWriteIdList testValidWriteIds = txnMgr2.getValidWriteIds(Collections.singletonList("temp.t7"), testValidTxns).getTableValidWriteIdList("temp.t7");
        Assert.assertEquals((long)baseWriteId, (long)testValidWriteIds.getHighWatermark());
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(baseWriteId));
        HiveTxnManager txnMgr3 = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        long aboveHwmOpenTxnId = txnMgr3.openTxn(this.ctx, "u3");
        Assert.assertTrue((String)"Invalid txn ID", (aboveHwmOpenTxnId > testTxnId ? 1 : 0) != 0);
        long aboveHwmOpenWriteId = txnMgr3.getTableWriteId("temp", "T7");
        Assert.assertEquals((long)2L, (long)aboveHwmOpenWriteId);
        long underHwmOpenWriteId = txnMgr1.getTableWriteId("temp", "T7");
        Assert.assertEquals((long)3L, (long)underHwmOpenWriteId);
        testValidWriteIds = txnMgr2.getValidWriteIds(Collections.singletonList("temp.t7"), testValidTxns).getTableValidWriteIdList("temp.t7");
        Assert.assertEquals((long)underHwmOpenWriteId, (long)testValidWriteIds.getHighWatermark());
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(baseWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(underHwmOpenWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(aboveHwmOpenWriteId));
        txnMgr1.commitTxn();
        testValidWriteIds = txnMgr2.getValidWriteIds(Collections.singletonList("temp.t7"), testValidTxns).getTableValidWriteIdList("temp.t7");
        Assert.assertEquals((long)underHwmOpenWriteId, (long)testValidWriteIds.getHighWatermark());
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(baseWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(underHwmOpenWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(aboveHwmOpenWriteId));
        long testWriteId = txnMgr2.getTableWriteId("temp", "T7");
        Assert.assertEquals((long)4L, (long)testWriteId);
        testValidWriteIds = txnMgr2.getValidWriteIds(Collections.singletonList("temp.t7"), testValidTxns).getTableValidWriteIdList("temp.t7");
        Assert.assertEquals((long)testWriteId, (long)testValidWriteIds.getHighWatermark());
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(baseWriteId));
        Assert.assertTrue((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(testWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(underHwmOpenWriteId));
        Assert.assertFalse((String)"Invalid write ID list", (boolean)testValidWriteIds.isWriteIdValid(aboveHwmOpenWriteId));
        txnMgr2.commitTxn();
        txnMgr3.commitTxn();
        cpr = this.driver.run("drop database if exists temp cascade");
        this.checkCmdOnDriver(cpr);
    }

    @Test
    public void testAddPartitionLocks() throws Exception {
        this.dropTable(new String[]{"T", "Tstage"});
        CommandProcessorResponse cpr = this.driver.run("create table T (a int, b int) partitioned by (p int) stored as orc tblproperties('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("create table Tstage (a int, b int)  clustered by (a) into 2 buckets stored as orc tblproperties('transactional'='false')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into Tstage values(0,2),(1,4)");
        this.checkCmdOnDriver(cpr);
        String exportLoc = this.exportFolder.newFolder("1").toString();
        cpr = this.driver.run("export table Tstage to '" + exportLoc + "'");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("ALTER TABLE T ADD if not exists PARTITION (p=0) location '" + exportLoc + "/data'", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T", null, locks);
    }

    @Test
    public void testLoadData() throws Exception {
        this.dropTable(new String[]{"T2"});
        CommandProcessorResponse cpr = this.driver.run("create table T2(a int) stored as ORC TBLPROPERTIES ('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into T2 values(1)"));
        String exportLoc = this.exportFolder.newFolder("1").toString();
        this.checkCmdOnDriver(this.driver.run("export table T2 to '" + exportLoc + "/2'"));
        cpr = this.driver.compileAndRespond("load data inpath '" + exportLoc + "/2/data' overwrite into table T2");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T2", null, locks);
        this.txnMgr.commitTxn();
    }

    @Test
    public void testMmConversionLocks() throws Exception {
        this.dropTable(new String[]{"T"});
        CommandProcessorResponse cpr = this.driver.run("create table T (a int, b int) tblproperties('transactional'='false')");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.run("insert into T values(0,2),(1,4)");
        this.checkCmdOnDriver(cpr);
        cpr = this.driver.compileAndRespond("ALTER TABLE T set tblproperties('transactional'='true', 'transactional_properties'='insert_only')", true);
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T", null, locks);
    }

    @Test
    public void testTruncate() throws Exception {
        this.dropTable(new String[]{"T"});
        CommandProcessorResponse cpr = this.driver.run("create table T (a int, b int) stored as orc tblproperties('transactional'='true')");
        this.checkCmdOnDriver(cpr);
        this.checkCmdOnDriver(this.driver.run("insert into T values(0,2),(1,4)"));
        this.checkCmdOnDriver(this.driver.run("truncate table T"));
        cpr = this.driver.compileAndRespond("truncate table T");
        this.checkCmdOnDriver(cpr);
        this.txnMgr.acquireLocks(this.driver.getPlan(), this.ctx, "Fifer");
        List<ShowLocksResponseElement> locks = this.getLocks();
        Assert.assertEquals((String)"Unexpected lock count", (long)1L, (long)locks.size());
        TestDbTxnManager2.checkLock(LockType.EXCLUSIVE, LockState.ACQUIRED, "default", "T", null, locks);
    }

    static {
        conf.set("fs.defaultFS", "file:///");
    }
}

