/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookWithParseHooks;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestQueryHooks {
    private static HiveConf conf;

    @BeforeClass
    public static void setUpBeforeClass() {
        conf = new HiveConf(TestQueryHooks.class);
        conf.set("fs.defaultFS", "file:///");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
    }

    @Test
    public void testAllQueryLifeTimeWithParseHooks() throws Exception {
        String query = "select 1";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHookWithParseHooks mockHook = (QueryLifeTimeHookWithParseHooks)Mockito.mock(QueryLifeTimeHookWithParseHooks.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook((QueryLifeTimeHook)mockHook);
        int ret = driver.run(query).getResponseCode();
        Assert.assertEquals((String)"Expected query to succeed", (long)0L, (long)ret);
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeParse((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterParse((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)false));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeCompile((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterCompile((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)false));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeExecution((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterExecution((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)false));
    }

    @Test
    public void testQueryLifeTimeWithParseHooksWithParseError() throws Exception {
        String query = "invalidquery";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHookWithParseHooks mockHook = (QueryLifeTimeHookWithParseHooks)Mockito.mock(QueryLifeTimeHookWithParseHooks.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook((QueryLifeTimeHook)mockHook);
        int ret = driver.run(query).getResponseCode();
        Assert.assertNotEquals((String)"Expected parsing to fail", (long)0L, (long)ret);
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeParse((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterParse((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)true));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).beforeCompile((QueryLifeTimeHookContext)Matchers.any());
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).afterCompile((QueryLifeTimeHookContext)Matchers.any(), Matchers.anyBoolean());
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).beforeExecution((QueryLifeTimeHookContext)Matchers.any());
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).afterExecution((QueryLifeTimeHookContext)Matchers.any(), Matchers.anyBoolean());
    }

    @Test
    public void testQueryLifeTimeWithParseHooksWithCompileError() throws Exception {
        String query = "select * from foo";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHookWithParseHooks mockHook = (QueryLifeTimeHookWithParseHooks)Mockito.mock(QueryLifeTimeHookWithParseHooks.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook((QueryLifeTimeHook)mockHook);
        int ret = driver.run(query).getResponseCode();
        Assert.assertNotEquals((String)"Expected compilation to fail", (long)0L, (long)ret);
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeParse((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterParse((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)false));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).beforeCompile((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook)).afterCompile((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)true));
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).beforeExecution((QueryLifeTimeHookContext)Matchers.any());
        ((QueryLifeTimeHookWithParseHooks)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).afterExecution((QueryLifeTimeHookContext)Matchers.any(), Matchers.anyBoolean());
    }

    @Test
    public void testAllQueryLifeTimeHooks() throws Exception {
        String query = "select 1";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHook mockHook = (QueryLifeTimeHook)Mockito.mock(QueryLifeTimeHook.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook(mockHook);
        int ret = driver.run(query).getResponseCode();
        Assert.assertEquals((String)"Expected query to succeed", (long)0L, (long)ret);
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).beforeCompile((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).afterCompile((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)false));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).beforeExecution((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).afterExecution((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)false));
    }

    @Test
    public void testQueryLifeTimeWithCompileError() throws Exception {
        String query = "select * from foo";
        QueryLifeTimeHookContextMatcher argMatcher = new QueryLifeTimeHookContextMatcher(query);
        QueryLifeTimeHook mockHook = (QueryLifeTimeHook)Mockito.mock(QueryLifeTimeHook.class);
        Driver driver = this.createDriver();
        driver.getHookRunner().addLifeTimeHook(mockHook);
        int ret = driver.run(query).getResponseCode();
        Assert.assertNotEquals((String)"Expected compilation to fail", (long)0L, (long)ret);
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).beforeCompile((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook)).afterCompile((QueryLifeTimeHookContext)Matchers.argThat((ArgumentMatcher)argMatcher), Matchers.eq((boolean)true));
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).beforeExecution((QueryLifeTimeHookContext)Matchers.any());
        ((QueryLifeTimeHook)Mockito.verify((Object)mockHook, (VerificationMode)Mockito.never())).afterExecution((QueryLifeTimeHookContext)Matchers.any(), Matchers.anyBoolean());
    }

    private Driver createDriver() throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver(conf);
        return driver;
    }

    private static final class QueryLifeTimeHookContextMatcher
    implements ArgumentMatcher<QueryLifeTimeHookContext> {
        private final String command;

        private QueryLifeTimeHookContextMatcher(String command) {
            this.command = command;
        }

        public boolean matches(QueryLifeTimeHookContext queryLifeTimeHookContext) {
            return queryLifeTimeHookContext.getCommand().equals(this.command);
        }
    }
}

