/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DAGTraversalTest {
    @Test
    public void shouldCountNumberOfLeafNodesCorrectly() {
        Task<? extends Serializable> taskWith5NodeTree = this.linearTree(5);
        Task<? extends Serializable> taskWith1NodeTree = this.linearTree(1);
        Task<? extends Serializable> taskWith3NodeTree = this.linearTree(3);
        Task rootTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)rootTask.getDependentTasks()).thenReturn(Arrays.asList(taskWith1NodeTree, taskWith3NodeTree, taskWith5NodeTree));
        CountLeafFunction function = new CountLeafFunction();
        DAGTraversal.traverse(Collections.singletonList(rootTask), (DAGTraversal.Function)function);
        Assert.assertEquals((long)3L, (long)function.count);
    }

    private Task<? extends Serializable> linearTree(int numOfNodes) {
        Task current = null;
        Task head = null;
        for (int i = 0; i < numOfNodes; ++i) {
            Task task = (Task)Mockito.mock(Task.class);
            if (current != null) {
                Mockito.when((Object)current.getDependentTasks()).thenReturn(Collections.singletonList(task));
            }
            if (head == null) {
                head = task;
            }
            current = task;
        }
        return head;
    }

    static class CountLeafFunction
    implements DAGTraversal.Function {
        int count = 0;

        CountLeafFunction() {
        }

        public void process(Task<? extends Serializable> task) {
            if (task.getDependentTasks() == null || task.getDependentTasks().isEmpty()) {
                ++this.count;
            }
        }

        public boolean skipProcessing(Task<? extends Serializable> task) {
            return false;
        }
    }
}

