/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.testutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

public class DataBuilder {
    private final List<String> columnNames = new ArrayList<String>();
    private final List<ObjectInspector> columnTypes = new ArrayList<ObjectInspector>();
    private final List<List<Object>> rows = new ArrayList<List<Object>>();

    public void setColumnNames(String ... names) {
        for (String name : names) {
            this.columnNames.add(name);
        }
    }

    public void setColumnTypes(ObjectInspector ... types) {
        for (ObjectInspector type : types) {
            this.columnTypes.add(type);
        }
    }

    public void addRow(Object ... columns) {
        List<Object> objects = Arrays.asList(columns);
        this.rows.add(objects);
    }

    public InspectableObject[] createRows() {
        InspectableObject[] toReturn = new InspectableObject[this.rows.size()];
        for (int i = 0; i < toReturn.length; ++i) {
            toReturn[i] = new InspectableObject();
            toReturn[i].o = this.rows.get(i);
            toReturn[i].oi = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, this.columnTypes);
        }
        return toReturn;
    }
}

