/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.io.parquet.serde.StandardParquetHiveMapInspector;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Test;

public class TestStandardParquetHiveMapInspector
extends TestCase {
    private StandardParquetHiveMapInspector inspector;

    public void setUp() {
        this.inspector = new StandardParquetHiveMapInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
    }

    @Test
    public void testNullMap() {
        TestStandardParquetHiveMapInspector.assertNull((String)"Should be null", (Object)this.inspector.getMapValueElement(null, (Object)new IntWritable(0)));
    }

    @Test
    public void testNullContainer() {
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, null);
        TestStandardParquetHiveMapInspector.assertNull((String)"Should be null", (Object)this.inspector.getMapValueElement((Object)map, (Object)new IntWritable(0)));
    }

    @Test
    public void testEmptyContainer() {
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, (Writable[])new ArrayWritable[0]);
        TestStandardParquetHiveMapInspector.assertNull((String)"Should be null", (Object)this.inspector.getMapValueElement((Object)map, (Object)new IntWritable(0)));
    }

    @Test
    public void testRegularMap() {
        Writable[] entry1 = new Writable[]{new IntWritable(0), new IntWritable(1)};
        Writable[] entry2 = new Writable[]{new IntWritable(2), new IntWritable(3)};
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, new Writable[]{new ArrayWritable(Writable.class, entry1), new ArrayWritable(Writable.class, entry2)});
        TestStandardParquetHiveMapInspector.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(1), (Object)this.inspector.getMapValueElement((Object)map, (Object)new IntWritable(0)));
        TestStandardParquetHiveMapInspector.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(3), (Object)this.inspector.getMapValueElement((Object)map, (Object)new IntWritable(2)));
        TestStandardParquetHiveMapInspector.assertNull((String)"Wrong result of inspection", (Object)this.inspector.getMapValueElement((Object)map, (Object)new ShortWritable(0)));
        TestStandardParquetHiveMapInspector.assertNull((String)"Wrong result of inspection", (Object)this.inspector.getMapValueElement((Object)map, (Object)new ShortWritable(2)));
    }

    @Test
    public void testHashMap() {
        HashMap<IntWritable, IntWritable> map = new HashMap<IntWritable, IntWritable>();
        map.put(new IntWritable(0), new IntWritable(1));
        map.put(new IntWritable(2), new IntWritable(3));
        map.put(new IntWritable(4), new IntWritable(5));
        map.put(new IntWritable(6), new IntWritable(7));
        TestStandardParquetHiveMapInspector.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(1), (Object)this.inspector.getMapValueElement(map, (Object)new IntWritable(0)));
        TestStandardParquetHiveMapInspector.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(3), (Object)this.inspector.getMapValueElement(map, (Object)new IntWritable(2)));
        TestStandardParquetHiveMapInspector.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(5), (Object)this.inspector.getMapValueElement(map, (Object)new IntWritable(4)));
        TestStandardParquetHiveMapInspector.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(7), (Object)this.inspector.getMapValueElement(map, (Object)new IntWritable(6)));
        TestStandardParquetHiveMapInspector.assertNull((String)"Wrong result of inspection", (Object)this.inspector.getMapValueElement(map, (Object)new ShortWritable(0)));
        TestStandardParquetHiveMapInspector.assertNull((String)"Wrong result of inspection", (Object)this.inspector.getMapValueElement(map, (Object)new ShortWritable(2)));
        TestStandardParquetHiveMapInspector.assertNull((String)"Wrong result of inspection", (Object)this.inspector.getMapValueElement(map, (Object)new ShortWritable(4)));
        TestStandardParquetHiveMapInspector.assertNull((String)"Wrong result of inspection", (Object)this.inspector.getMapValueElement(map, (Object)new ShortWritable(6)));
    }
}

