/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileStorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.junit.Assert;

public class StorageFormats {
    public static final Object[][] ADDITIONAL_STORAGE_FORMATS = new Object[][]{{"rcfile_columnar", ColumnarSerDe.class.getName(), RCFileInputFormat.class.getName(), RCFileOutputFormat.class.getName()}};

    protected static Object[] createTestArguments(String name, String serdeClass, String inputFormatClass, String outputFormatClass) {
        Object[] args = new Object[]{name, serdeClass, inputFormatClass, outputFormatClass};
        return args;
    }

    public static Collection<Object[]> asParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        Configuration conf = new Configuration();
        for (StorageFormatDescriptor descriptor : ServiceLoader.load(StorageFormatDescriptor.class)) {
            String serdeClass = descriptor.getSerde();
            if (serdeClass == null) {
                serdeClass = descriptor instanceof RCFileStorageFormatDescriptor ? HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEDEFAULTRCFILESERDE) : HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEDEFAULTSERDE);
            }
            String[] names = new String[descriptor.getNames().size()];
            names = descriptor.getNames().toArray(names);
            Object[] arguments = StorageFormats.createTestArguments(names[0], serdeClass, descriptor.getInputFormat(), descriptor.getOutputFormat());
            parameters.add(arguments);
        }
        for (int i = 0; i < ADDITIONAL_STORAGE_FORMATS.length; ++i) {
            String serdeClass = (String)ADDITIONAL_STORAGE_FORMATS[i][1];
            String name = (String)ADDITIONAL_STORAGE_FORMATS[i][0];
            String inputFormatClass = (String)ADDITIONAL_STORAGE_FORMATS[i][2];
            String outputFormatClass = (String)ADDITIONAL_STORAGE_FORMATS[i][3];
            Assert.assertTrue((String)"InputFormat for storage format not set", (inputFormatClass != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"OutputFormat for storage format not set", (outputFormatClass != null ? 1 : 0) != 0);
            Object[] arguments = StorageFormats.createTestArguments(name, serdeClass, inputFormatClass, outputFormatClass);
            parameters.add(arguments);
        }
        return parameters;
    }

    public static Collection<Object[]> names() {
        ArrayList<Object[]> names = new ArrayList<Object[]>();
        for (StorageFormatDescriptor descriptor : ServiceLoader.load(StorageFormatDescriptor.class)) {
            String[] formatNames = new String[descriptor.getNames().size()];
            formatNames = descriptor.getNames().toArray(formatNames);
            String[] params = new String[]{formatNames[0]};
            names.add(params);
        }
        return names;
    }
}

