/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFHourString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFHourTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMinuteString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMinuteTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMonthString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMonthTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFSecondString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFSecondTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.RandomTypeUtil;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TestVectorTimestampExpressions {
    private SimpleDateFormat dateFormat = TestVectorTimestampExpressions.getFormatter();

    private static SimpleDateFormat getFormatter() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter;
    }

    private Timestamp[] getAllBoundaries(int minYear, int maxYear) {
        ArrayList<Timestamp> boundaries = new ArrayList<Timestamp>(1);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(0L);
        for (int year = minYear; year <= maxYear; ++year) {
            c.set(year, 0, 1, 0, 0, 0);
            if (c.get(1) < 0 || c.get(1) >= 10000) continue;
            long exactly = c.getTimeInMillis();
            long before = exactly - 1000L;
            long after = exactly + 1000L;
            if (minYear != 0) {
                boundaries.add(new Timestamp(before));
            }
            boundaries.add(new Timestamp(exactly));
            if (year == maxYear) continue;
            boundaries.add(new Timestamp(after));
        }
        return boundaries.toArray(new Timestamp[0]);
    }

    private Timestamp[] getAllBoundaries() {
        return this.getAllBoundaries(1900, 3000);
    }

    private VectorizedRowBatch getVectorizedRandomRowBatchTimestampLong(int seed, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        TimestampColumnVector tcv = new TimestampColumnVector(size);
        Random rand = new Random(seed);
        for (int i = 0; i < size; ++i) {
            tcv.set(i, RandomTypeUtil.getRandTimestamp((Random)rand).toSqlTimestamp());
        }
        batch.cols[0] = tcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRandomRowBatchStringLong(int seed, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        BytesColumnVector bcv = new BytesColumnVector(size);
        Random rand = new Random(seed);
        for (int i = 0; i < size; ++i) {
            byte[] encoded = this.encodeTime(RandomTypeUtil.getRandTimestamp((Random)rand).toSqlTimestamp());
            bcv.vector[i] = encoded;
            bcv.start[i] = 0;
            bcv.length[i] = encoded.length;
        }
        batch.cols[0] = bcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRandomRowBatch(int seed, int size, TestType testType) {
        switch (testType) {
            case TIMESTAMP_LONG: {
                return this.getVectorizedRandomRowBatchTimestampLong(seed, size);
            }
            case STRING_LONG: {
                return this.getVectorizedRandomRowBatchStringLong(seed, size);
            }
        }
        throw new IllegalArgumentException();
    }

    private VectorizedRowBatch getVectorizedRowBatchTimestampLong(Timestamp[] inputs, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        TimestampColumnVector tcv = new TimestampColumnVector(size);
        for (int i = 0; i < size; ++i) {
            tcv.set(i, inputs[i % inputs.length]);
        }
        batch.cols[0] = tcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRowBatchStringLong(Timestamp[] inputs, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        BytesColumnVector bcv = new BytesColumnVector(size);
        for (int i = 0; i < size; ++i) {
            byte[] encoded = this.encodeTime(inputs[i % inputs.length]);
            bcv.vector[i] = encoded;
            bcv.start[i] = 0;
            bcv.length[i] = encoded.length;
        }
        batch.cols[0] = bcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRowBatchStringLong(byte[] vector, int start, int length) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, 1);
        BytesColumnVector bcv = new BytesColumnVector(1);
        bcv.vector[0] = vector;
        bcv.start[0] = start;
        bcv.length[0] = length;
        batch.cols[0] = bcv;
        batch.cols[1] = new LongColumnVector(1);
        batch.size = 1;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRowBatch(Timestamp[] inputs, int size, TestType testType) {
        switch (testType) {
            case TIMESTAMP_LONG: {
                return this.getVectorizedRowBatchTimestampLong(inputs, size);
            }
            case STRING_LONG: {
                return this.getVectorizedRowBatchStringLong(inputs, size);
            }
        }
        throw new IllegalArgumentException();
    }

    private byte[] encodeTime(Timestamp timestamp) {
        ByteBuffer encoded;
        long time = timestamp.getTime();
        try {
            String formatted = this.dateFormat.format(new Date(time));
            encoded = Text.encode((String)formatted);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        return Arrays.copyOf(encoded.array(), encoded.limit());
    }

    private Timestamp decodeTime(byte[] time) {
        try {
            return new Timestamp(this.dateFormat.parse(Text.decode((byte[])time)).getTime());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Timestamp readVectorElementAt(ColumnVector col, int i) {
        if (col instanceof TimestampColumnVector) {
            return ((TimestampColumnVector)col).asScratchTimestamp(i);
        }
        if (col instanceof BytesColumnVector) {
            byte[] timeBytes = ((BytesColumnVector)col).vector[i];
            return this.decodeTime(timeBytes);
        }
        throw new IllegalArgumentException();
    }

    private void compareToUDFYearLong(Timestamp t, int y) throws HiveException {
        UDFYear udf = new UDFYear();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)t.getTime(), (int)t.getNanos()));
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFYear(VectorizedRowBatch batch, TestType testType) throws HiveException {
        VectorUDFYearTimestamp udf = null;
        if (testType == TestType.TIMESTAMP_LONG) {
            udf = new VectorUDFYearTimestamp(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo});
        } else {
            udf = new VectorUDFYearString(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        }
        udf.transientInit();
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                Timestamp t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFYearLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFYear(TestType testType) throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch, testType);
        Timestamp[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFYear(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFYear(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFYear(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFYear(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFYear(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFYear(batch, testType);
    }

    @Test
    public void testVectorUDFYearTimestamp() throws HiveException {
        this.testVectorUDFYear(TestType.TIMESTAMP_LONG);
    }

    @Test
    public void testVectorUDFYearString() throws HiveException {
        this.testVectorUDFYear(TestType.STRING_LONG);
        VectorizedRowBatch batch = this.getVectorizedRowBatchStringLong(new byte[]{50, 50, 48, 49, 51}, 1, 3);
        VectorUDFYearString udf = new VectorUDFYearString(0, 1);
        udf.evaluate(batch);
        LongColumnVector lcv = (LongColumnVector)batch.cols[1];
        Assert.assertEquals((boolean)false, (boolean)batch.cols[0].isNull[0]);
        Assert.assertEquals((boolean)true, (boolean)lcv.isNull[0]);
    }

    private void compareToUDFDayOfMonthLong(Timestamp t, int y) throws HiveException {
        UDFDayOfMonth udf = new UDFDayOfMonth();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)t.getTime(), (int)t.getNanos()));
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFDayOfMonth(VectorizedRowBatch batch, TestType testType) throws HiveException {
        VectorUDFDayOfMonthTimestamp udf = null;
        if (testType == TestType.TIMESTAMP_LONG) {
            udf = new VectorUDFDayOfMonthTimestamp(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo});
        } else {
            udf = new VectorUDFDayOfMonthString(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        }
        udf.transientInit();
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                Timestamp t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFDayOfMonthLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFDayOfMonth(TestType testType) throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch, testType);
        Timestamp[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFDayOfMonth(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFDayOfMonth(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFDayOfMonth(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFDayOfMonth(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFDayOfMonth(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFDayOfMonth(batch, testType);
    }

    @Test
    public void testVectorUDFDayOfMonthTimestamp() throws HiveException {
        this.testVectorUDFDayOfMonth(TestType.TIMESTAMP_LONG);
    }

    @Test
    public void testVectorUDFDayOfMonthString() throws HiveException {
        this.testVectorUDFDayOfMonth(TestType.STRING_LONG);
    }

    private void compareToUDFHourLong(Timestamp t, int y) throws HiveException {
        UDFHour udf = new UDFHour();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)t.getTime(), (int)t.getNanos()));
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFHour(VectorizedRowBatch batch, TestType testType) throws HiveException {
        VectorUDFHourTimestamp udf = null;
        if (testType == TestType.TIMESTAMP_LONG) {
            udf = new VectorUDFHourTimestamp(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo});
        } else {
            udf = new VectorUDFHourString(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        }
        udf.transientInit();
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                Timestamp t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFHourLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFHour(TestType testType) throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFHour(batch, testType);
        Timestamp[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFHour(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFHour(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFHour(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFHour(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFHour(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFHour(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFHour(batch, testType);
    }

    @Test
    public void testVectorUDFHourTimestamp() throws HiveException {
        this.testVectorUDFHour(TestType.TIMESTAMP_LONG);
    }

    @Test
    public void testVectorUDFHourString() throws HiveException {
        this.testVectorUDFHour(TestType.STRING_LONG);
    }

    private void compareToUDFMinuteLong(Timestamp t, int y) throws HiveException {
        UDFMinute udf = new UDFMinute();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)t.getTime(), (int)t.getNanos()));
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFMinute(VectorizedRowBatch batch, TestType testType) throws HiveException {
        VectorUDFMinuteTimestamp udf = null;
        if (testType == TestType.TIMESTAMP_LONG) {
            udf = new VectorUDFMinuteTimestamp(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo});
        } else {
            udf = new VectorUDFMinuteString(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        }
        udf.transientInit();
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                Timestamp t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFMinuteLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFMinute(TestType testType) throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMinute(batch, testType);
        Timestamp[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMinute(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFMinute(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMinute(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFMinute(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMinute(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMinute(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMinute(batch, testType);
    }

    @Test
    public void testVectorUDFMinuteLong() throws HiveException {
        this.testVectorUDFMinute(TestType.TIMESTAMP_LONG);
    }

    @Test
    public void testVectorUDFMinuteString() throws HiveException {
        this.testVectorUDFMinute(TestType.STRING_LONG);
    }

    private void compareToUDFMonthLong(Timestamp t, int y) throws HiveException {
        UDFMonth udf = new UDFMonth();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)t.getTime(), (int)t.getNanos()));
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFMonth(VectorizedRowBatch batch, TestType testType) throws HiveException {
        VectorUDFMonthTimestamp udf;
        if (testType == TestType.TIMESTAMP_LONG) {
            udf = new VectorUDFMonthTimestamp(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo});
        } else {
            udf = new VectorUDFMonthString(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        }
        udf.transientInit();
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                Timestamp t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFMonthLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFMonth(TestType testType) throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch, testType);
        Timestamp[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMonth(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFMonth(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMonth(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFMonth(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMonth(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMonth(batch, testType);
    }

    @Test
    public void testVectorUDFMonthTimestamp() throws HiveException {
        this.testVectorUDFMonth(TestType.TIMESTAMP_LONG);
    }

    @Test
    public void testVectorUDFMonthString() throws HiveException {
        this.testVectorUDFMonth(TestType.STRING_LONG);
    }

    private void compareToUDFSecondLong(Timestamp t, int y) throws HiveException {
        UDFSecond udf = new UDFSecond();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)t.getTime(), (int)t.getNanos()));
        IntWritable res = (IntWritable)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tsw)});
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFSecond(VectorizedRowBatch batch, TestType testType) throws HiveException {
        VectorUDFSecondTimestamp udf;
        if (testType == TestType.TIMESTAMP_LONG) {
            udf = new VectorUDFSecondTimestamp(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo});
        } else {
            udf = new VectorUDFSecondString(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        }
        udf.transientInit();
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                Timestamp t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFSecondLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFSecond(TestType testType) throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFSecond(batch, testType);
        Timestamp[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFSecond(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFSecond(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFSecond(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFSecond(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFSecond(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFSecond(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFSecond(batch, testType);
    }

    @Test
    public void testVectorUDFSecondLong() throws HiveException {
        this.testVectorUDFSecond(TestType.TIMESTAMP_LONG);
    }

    @Test
    public void testVectorUDFSecondString() throws HiveException {
        this.testVectorUDFSecond(TestType.STRING_LONG);
    }

    private void compareToUDFUnixTimeStampLong(Timestamp ts, long y) {
        long seconds = ts.getTime() / 1000L;
        if (seconds != y) {
            System.out.printf("%d vs %d for %s\n", seconds, y, ts.toString());
            Assert.assertTrue((boolean)false);
        }
    }

    private void verifyUDFUnixTimeStamp(VectorizedRowBatch batch, TestType testType) throws HiveException {
        VectorUDFUnixTimeStampTimestamp udf;
        if (testType == TestType.TIMESTAMP_LONG) {
            udf = new VectorUDFUnixTimeStampTimestamp(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo});
        } else {
            udf = new VectorUDFUnixTimeStampString(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        }
        udf.transientInit();
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[1].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                Timestamp t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFUnixTimeStampLong(t, y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFUnixTimeStamp(TestType testType) throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch, testType);
        Timestamp[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFUnixTimeStamp(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFUnixTimeStamp(batch, testType);
    }

    @Test
    public void testVectorUDFUnixTimeStampTimestamp() throws HiveException {
        this.testVectorUDFUnixTimeStamp(TestType.TIMESTAMP_LONG);
    }

    @Test
    public void testVectorUDFUnixTimeStampString() throws HiveException {
        this.testVectorUDFUnixTimeStamp(TestType.STRING_LONG);
    }

    private void compareToUDFWeekOfYearLong(Timestamp t, int y) {
        UDFWeekOfYear udf = new UDFWeekOfYear();
        TimestampWritableV2 tsw = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)t.getTime(), (int)t.getNanos()));
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFWeekOfYear(VectorizedRowBatch batch, TestType testType) throws HiveException {
        VectorUDFWeekOfYearTimestamp udf;
        if (testType == TestType.TIMESTAMP_LONG) {
            udf = new VectorUDFWeekOfYearTimestamp(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.timestampTypeInfo});
        } else {
            udf = new VectorUDFWeekOfYearString(0, 1);
            udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        }
        udf.transientInit();
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                Timestamp t = this.readVectorElementAt(batch.cols[0], i);
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFWeekOfYearLong(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    private void testVectorUDFWeekOfYear(TestType testType) throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1024, testType);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch, testType);
        Timestamp[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length, testType);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFWeekOfYear(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        this.verifyUDFWeekOfYear(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFWeekOfYear(batch, testType);
        batch = this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(0L)}, 1, testType);
        batch.cols[0].isRepeating = true;
        batch.selectedInUse = true;
        batch.selected = new int[]{42};
        this.verifyUDFWeekOfYear(batch, testType);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFWeekOfYear(batch, testType);
        batch = this.getVectorizedRandomRowBatch(200, 1024, testType);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch, testType);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFWeekOfYear(batch, testType);
    }

    @Test
    public void testVectorUDFWeekOfYearTimestamp() throws HiveException {
        this.testVectorUDFWeekOfYear(TestType.TIMESTAMP_LONG);
    }

    @Test
    public void testVectorUDFWeekOfYearString() throws HiveException {
        this.testVectorUDFWeekOfYear(TestType.STRING_LONG);
    }

    public static void main(String[] args) throws HiveException {
        TestVectorTimestampExpressions self = new TestVectorTimestampExpressions();
        self.testVectorUDFYearTimestamp();
        self.testVectorUDFMonthTimestamp();
        self.testVectorUDFDayOfMonthTimestamp();
        self.testVectorUDFHourTimestamp();
        self.testVectorUDFWeekOfYearTimestamp();
        self.testVectorUDFUnixTimeStampTimestamp();
        self.testVectorUDFYearString();
        self.testVectorUDFMonthString();
        self.testVectorUDFDayOfMonthString();
        self.testVectorUDFHourString();
        self.testVectorUDFWeekOfYearString();
        self.testVectorUDFUnixTimeStampString();
    }

    private static enum TestType {
        TIMESTAMP_LONG,
        STRING_LONG;

    }
}

