/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import junit.framework.Assert;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.Utilities;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TestMapJoinKey {
    @Test
    public void testEqualityHashCode() throws Exception {
        MapJoinKeyObject key1 = new MapJoinKeyObject((Object[])new String[]{"key"});
        MapJoinKeyObject key2 = new MapJoinKeyObject((Object[])new String[]{"key"});
        Utilities.testEquality(key1, key2);
        key1 = new MapJoinKeyObject(new Object[]{148, null});
        key2 = new MapJoinKeyObject(new Object[]{148, null});
        Utilities.testEquality(key1, key2);
        key1 = new MapJoinKeyObject(new Object[]{null, "key1"});
        key2 = new MapJoinKeyObject(new Object[]{null, "key2"});
        Assert.assertFalse((boolean)key1.equals((Object)key2));
    }

    @Test
    public void testSerialization() throws Exception {
        MapJoinKeyObject key1 = new MapJoinKeyObject(new Object[]{new Text("field0"), null, new Text("field2")});
        MapJoinKeyObject key2 = Utilities.serde(key1, "f0,f1,f2", "string,string,string");
        Utilities.testEquality(key1, key2);
    }
}

