/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.NoMatchingMethodException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseDTI;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@Description(name="+", value="a _FUNC_ b - Returns a+b")
public class GenericUDFOPDTIPlus
extends GenericUDFBaseDTI {
    protected transient DateTimeMath dtm = new DateTimeMath();
    protected transient OperationType plusOpType;
    protected transient int intervalArg1Idx;
    protected transient int intervalArg2Idx;
    protected transient int dtArgIdx;
    protected transient ObjectInspectorConverters.Converter dtConverter;
    protected transient TimestampWritableV2 timestampResult = new TimestampWritableV2();
    protected transient DateWritableV2 dateResult = new DateWritableV2();
    protected transient HiveIntervalDayTimeWritable intervalDayTimeResult = new HiveIntervalDayTimeWritable();
    protected transient HiveIntervalYearMonthWritable intervalYearMonthResult = new HiveIntervalYearMonthWritable();

    public GenericUDFOPDTIPlus() {
        this.opName = this.getClass().getSimpleName();
        this.opDisplayName = "+";
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentException(this.opName + " requires two arguments.");
        }
        AbstractPrimitiveWritableObjectInspector resultOI = null;
        for (int i = 0; i < 2; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of " + this.opName + "  is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        this.inputOIs = new PrimitiveObjectInspector[]{(PrimitiveObjectInspector)arguments[0], (PrimitiveObjectInspector)arguments[1]};
        PrimitiveObjectInspector leftOI = this.inputOIs[0];
        PrimitiveObjectInspector rightOI = this.inputOIs[1];
        if (this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH, PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH)) {
            this.plusOpType = OperationType.INTERVALYM_PLUS_INTERVALYM;
            this.intervalArg1Idx = 0;
            this.intervalArg2Idx = 1;
            resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.intervalYearMonthTypeInfo);
        } else if (this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.DATE, PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH)) {
            this.plusOpType = OperationType.INTERVALYM_PLUS_DATE;
            this.dtArgIdx = 0;
            this.intervalArg1Idx = 1;
            resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.dateTypeInfo);
        } else if (this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH, PrimitiveObjectInspector.PrimitiveCategory.DATE)) {
            this.plusOpType = OperationType.INTERVALYM_PLUS_DATE;
            this.intervalArg1Idx = 0;
            this.dtArgIdx = 1;
            resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.dateTypeInfo);
        } else if (this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH)) {
            this.plusOpType = OperationType.INTERVALYM_PLUS_TIMESTAMP;
            this.dtArgIdx = 0;
            this.intervalArg1Idx = 1;
            resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.timestampTypeInfo);
        } else if (this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH, PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP)) {
            this.plusOpType = OperationType.INTERVALYM_PLUS_TIMESTAMP;
            this.intervalArg1Idx = 0;
            this.dtArgIdx = 1;
            resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.timestampTypeInfo);
        } else if (this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME, PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME)) {
            this.plusOpType = OperationType.INTERVALDT_PLUS_INTERVALDT;
            this.intervalArg1Idx = 0;
            this.intervalArg2Idx = 1;
            resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.intervalDayTimeTypeInfo);
        } else if (this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME, PrimitiveObjectInspector.PrimitiveCategory.DATE) || this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME, PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP)) {
            this.plusOpType = OperationType.INTERVALDT_PLUS_TIMESTAMP;
            this.intervalArg1Idx = 0;
            this.dtArgIdx = 1;
            resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.timestampTypeInfo);
            this.dtConverter = ObjectInspectorConverters.getConverter((ObjectInspector)leftOI, (ObjectInspector)resultOI);
        } else if (this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.DATE, PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME) || this.checkArgs(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME)) {
            this.plusOpType = OperationType.INTERVALDT_PLUS_TIMESTAMP;
            this.intervalArg1Idx = 1;
            this.dtArgIdx = 0;
            resultOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.timestampTypeInfo);
            this.dtConverter = ObjectInspectorConverters.getConverter((ObjectInspector)leftOI, (ObjectInspector)resultOI);
        } else {
            ArrayList<TypeInfo> argTypeInfos = new ArrayList<TypeInfo>(2);
            argTypeInfos.add(leftOI.getTypeInfo());
            argTypeInfos.add(rightOI.getTypeInfo());
            throw new NoMatchingMethodException(this.getClass(), argTypeInfos, null);
        }
        return resultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        switch (this.plusOpType) {
            case INTERVALYM_PLUS_INTERVALYM: {
                HiveIntervalYearMonth iym1 = PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth(arguments[this.intervalArg1Idx].get(), this.inputOIs[this.intervalArg1Idx]);
                HiveIntervalYearMonth iym2 = PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth(arguments[this.intervalArg2Idx].get(), this.inputOIs[this.intervalArg2Idx]);
                return this.handleIntervalYearMonthResult(this.dtm.add(iym1, iym2));
            }
            case INTERVALYM_PLUS_DATE: {
                HiveIntervalYearMonth iym1 = PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth(arguments[this.intervalArg1Idx].get(), this.inputOIs[this.intervalArg1Idx]);
                Date dt1 = PrimitiveObjectInspectorUtils.getDate(arguments[this.dtArgIdx].get(), this.inputOIs[this.dtArgIdx]);
                return this.handleDateResult(this.dtm.add(dt1, iym1));
            }
            case INTERVALYM_PLUS_TIMESTAMP: {
                HiveIntervalYearMonth iym1 = PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth(arguments[this.intervalArg1Idx].get(), this.inputOIs[this.intervalArg1Idx]);
                Timestamp ts1 = PrimitiveObjectInspectorUtils.getTimestamp(arguments[this.dtArgIdx].get(), this.inputOIs[this.dtArgIdx]);
                return this.handleTimestampResult(this.dtm.add(ts1, iym1));
            }
            case INTERVALDT_PLUS_INTERVALDT: {
                HiveIntervalDayTime idt1 = PrimitiveObjectInspectorUtils.getHiveIntervalDayTime(arguments[this.intervalArg1Idx].get(), this.inputOIs[this.intervalArg1Idx]);
                HiveIntervalDayTime idt2 = PrimitiveObjectInspectorUtils.getHiveIntervalDayTime(arguments[this.intervalArg2Idx].get(), this.inputOIs[this.intervalArg2Idx]);
                return this.handleIntervalDayTimeResult(this.dtm.add(idt1, idt2));
            }
            case INTERVALDT_PLUS_TIMESTAMP: {
                HiveIntervalDayTime idt1 = PrimitiveObjectInspectorUtils.getHiveIntervalDayTime(arguments[this.intervalArg1Idx].get(), this.inputOIs[this.intervalArg1Idx]);
                Timestamp ts1 = PrimitiveObjectInspectorUtils.getTimestamp(arguments[this.dtArgIdx].get(), this.inputOIs[this.dtArgIdx]);
                return this.handleTimestampResult(this.dtm.add(ts1, idt1));
            }
        }
        throw new HiveException("Unknown PlusOpType " + this.plusOpType);
    }

    protected DateWritableV2 handleDateResult(Date result) {
        if (result == null) {
            return null;
        }
        this.dateResult.set(result);
        return this.dateResult;
    }

    protected TimestampWritableV2 handleTimestampResult(Timestamp result) {
        if (result == null) {
            return null;
        }
        this.timestampResult.set(result);
        return this.timestampResult;
    }

    protected HiveIntervalYearMonthWritable handleIntervalYearMonthResult(HiveIntervalYearMonth result) {
        if (result == null) {
            return null;
        }
        this.intervalYearMonthResult.set(result);
        return this.intervalYearMonthResult;
    }

    protected HiveIntervalDayTimeWritable handleIntervalDayTimeResult(HiveIntervalDayTime result) {
        if (result == null) {
            return null;
        }
        this.intervalDayTimeResult.set(result);
        return this.intervalDayTimeResult;
    }

    static enum OperationType {
        INTERVALYM_PLUS_INTERVALYM,
        INTERVALYM_PLUS_DATE,
        INTERVALYM_PLUS_TIMESTAMP,
        INTERVALDT_PLUS_INTERVALDT,
        INTERVALDT_PLUS_TIMESTAMP;

    }
}

