/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.dynamic_type;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDeFieldType;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDeTypeBase;
import org.apache.hadoop.hive.serde2.dynamic_type.thrift_grammar;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.thrift.WriteNullsProtocol;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;

public class DynamicSerDeTypeMap
extends DynamicSerDeTypeBase {
    private final byte FD_KEYTYPE = 0;
    private final byte FD_VALUETYPE = 1;
    TMap serializeMap = null;

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public Class getRealType() {
        try {
            Class c = this.getKeyType().getRealType();
            Class c2 = this.getValueType().getRealType();
            Object o = c.newInstance();
            Object o2 = c2.newInstance();
            Map l = Collections.singletonMap(o, o2);
            return l.getClass();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public DynamicSerDeTypeMap(int i) {
        super(i);
    }

    public DynamicSerDeTypeMap(thrift_grammar p, int i) {
        super(p, i);
    }

    public DynamicSerDeTypeBase getKeyType() {
        return ((DynamicSerDeFieldType)this.jjtGetChild(0)).getMyType();
    }

    public DynamicSerDeTypeBase getValueType() {
        return ((DynamicSerDeFieldType)this.jjtGetChild(1)).getMyType();
    }

    @Override
    public String toString() {
        return "map<" + this.getKeyType().toString() + "," + this.getValueType().toString() + ">";
    }

    @Override
    public Map<Object, Object> deserialize(Object reuse, TProtocol iprot) throws SerDeException, TException, IllegalAccessException {
        Map<Object, Object> deserializeReuse;
        if (reuse != null && reuse.getClass() == LinkedHashMap.class) {
            deserializeReuse = (Map)reuse;
            deserializeReuse.clear();
        } else {
            deserializeReuse = new LinkedHashMap();
        }
        TMap themap = iprot.readMapBegin();
        if (themap == null) {
            return null;
        }
        int mapSize = themap.size;
        for (int i = 0; i < mapSize; ++i) {
            Object key = this.getKeyType().deserialize(null, iprot);
            Object value = this.getValueType().deserialize(null, iprot);
            deserializeReuse.put(key, value);
        }
        iprot.readMapEnd();
        return deserializeReuse;
    }

    @Override
    public void serialize(Object o, ObjectInspector oi, TProtocol oprot) throws TException, SerDeException, NoSuchFieldException, IllegalAccessException {
        WriteNullsProtocol nullProtocol;
        DynamicSerDeTypeBase keyType = this.getKeyType();
        DynamicSerDeTypeBase valueType = this.getValueType();
        WriteNullsProtocol writeNullsProtocol = nullProtocol = oprot instanceof WriteNullsProtocol ? (WriteNullsProtocol)((Object)oprot) : null;
        assert (oi.getCategory() == ObjectInspector.Category.MAP);
        MapObjectInspector moi = (MapObjectInspector)oi;
        ObjectInspector koi = moi.getMapKeyObjectInspector();
        ObjectInspector voi = moi.getMapValueObjectInspector();
        Map<?, ?> map = moi.getMap(o);
        this.serializeMap = new TMap(keyType.getType(), valueType.getType(), map.size());
        oprot.writeMapBegin(this.serializeMap);
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> element;
            Map.Entry<?, ?> it = element = iterator.next();
            Object key = it.getKey();
            Object value = it.getValue();
            keyType.serialize(key, koi, oprot);
            if (value == null) {
                assert (nullProtocol != null);
                nullProtocol.writeNull();
                continue;
            }
            valueType.serialize(value, voi, oprot);
        }
        oprot.writeMapEnd();
    }

    @Override
    public byte getType() {
        return 13;
    }
}

