/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Deletion from MapR DB Json Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DeleteWork
implements Serializable {
    private final Set<String> values;
    private final String targetMapRDbTableName;
    private final String sourceMapRDbTableName;
    private final DeleteOperation deleteOperation;

    public DeleteWork(String targetMapRDbTableName) {
        this.values = new HashSet<String>();
        this.targetMapRDbTableName = targetMapRDbTableName;
        this.sourceMapRDbTableName = "";
        this.deleteOperation = DeleteOperation.DELETE_ALL;
    }

    public DeleteWork(Set<String> values, String targetMapRDbTableName, DeleteOperation deleteOperation) {
        this.values = values;
        this.targetMapRDbTableName = targetMapRDbTableName;
        this.sourceMapRDbTableName = "";
        this.deleteOperation = deleteOperation;
    }

    public DeleteWork(String targetMapRDbTableName, String sourceMapRDbTableName) {
        this.values = Collections.unmodifiableSet(new HashSet());
        this.targetMapRDbTableName = targetMapRDbTableName;
        this.sourceMapRDbTableName = sourceMapRDbTableName;
        this.deleteOperation = DeleteOperation.DELETE_WHEN_MATCHED;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public String getTargetMapRDbTableName() {
        return this.targetMapRDbTableName;
    }

    public String getSourceMapRDbTableName() {
        return this.sourceMapRDbTableName;
    }

    public DeleteOperation getDeleteOperation() {
        return this.deleteOperation;
    }

    public String getValue() {
        Iterator<String> iterator = this.values.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new RuntimeException("Set has no next value");
    }

    public static enum DeleteOperation {
        DELETE_ALL,
        DELETE_ALL_IN_SET,
        DELETE_ALL_EXCEPT_IN_SET,
        DELETE_SINGLE,
        DELETE_WHEN_MATCHED;

    }
}

