/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUtils {
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    private static final Logger LOG = LoggerFactory.getLogger(HdfsUtils.class);
    private static String HDFS_ID_PATH_PREFIX = "/.reserved/.inodes/";

    public static Object getFileId(FileSystem fileSystem, Path path, boolean allowSynthetic, boolean checkDefaultFs) throws IOException {
        if (fileSystem instanceof DistributedFileSystem) {
            Long result;
            DistributedFileSystem dfs = (DistributedFileSystem)fileSystem;
            if ((!checkDefaultFs || HdfsUtils.isDefaultFs(dfs)) && (result = Long.valueOf(SHIMS.getFileId((FileSystem)dfs, path.toUri().getPath()))) != null) {
                return result;
            }
        }
        if (!allowSynthetic) {
            LOG.warn("Cannot get unique file ID from " + fileSystem.getClass().getSimpleName() + "; returning null");
            return null;
        }
        FileStatus fs = fileSystem.getFileStatus(path);
        return new SyntheticFileId(path, fs.getLen(), fs.getModificationTime());
    }

    @VisibleForTesting
    public static long createTestFileId(String pathStr, FileStatus fs, boolean doLog, String fsName) {
        int nameHash = pathStr.hashCode();
        long fileSize = fs.getLen();
        long modTime = fs.getModificationTime();
        int fileSizeHash = (int)(fileSize ^ fileSize >>> 32);
        int modTimeHash = (int)(modTime ^ modTime >>> 32);
        int combinedHash = modTimeHash ^ fileSizeHash;
        long id = ((long)nameHash & 0xFFFFFFFFL) << 32 | (long)combinedHash & 0xFFFFFFFFL;
        if (doLog) {
            LOG.warn("Cannot get unique file ID from " + fsName + "; using " + id + " (" + pathStr + "," + nameHash + "," + fileSize + ")");
        }
        return id;
    }

    public static List<FileStatus> listLocatedStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        RemoteIterator itr = fs.listLocatedStatus(path);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            FileStatus stat = (FileStatus)itr.next();
            if (filter != null && !filter.accept(stat.getPath())) continue;
            result.add(stat);
        }
        return result;
    }

    public static Path getFileIdPath(FileSystem fileSystem, Path path, long fileId) {
        return fileSystem instanceof DistributedFileSystem ? new Path(HDFS_ID_PATH_PREFIX + fileId) : path;
    }

    public static boolean isDefaultFs(DistributedFileSystem fs) {
        URI uri = fs.getUri();
        String scheme = uri.getScheme();
        if (scheme == null) {
            return true;
        }
        URI defaultUri = FileSystem.getDefaultUri((Configuration)fs.getConf());
        if (!defaultUri.getScheme().equalsIgnoreCase(scheme)) {
            return false;
        }
        String defaultAuthority = defaultUri.getAuthority();
        String authority = uri.getAuthority();
        if (authority == null) {
            return true;
        }
        if (defaultAuthority == null) {
            return false;
        }
        if (!defaultUri.getHost().equalsIgnoreCase(uri.getHost())) {
            return false;
        }
        int defaultPort = defaultUri.getPort();
        int port = uri.getPort();
        if (port == -1) {
            return true;
        }
        return defaultPort == -1 ? port == 8020 : port == defaultPort;
    }
}

