/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUnaryUDFDirect;

public class StringTrim
extends StringUnaryUDFDirect {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public StringTrim(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    public StringTrim() {
    }

    @Override
    protected void func(BytesColumnVector outV, byte[][] vector, int[] start, int[] length, int batchIndex) {
        int rightIndex;
        int leftIndex;
        byte[] bytes = vector[batchIndex];
        int startIndex = start[batchIndex];
        int end = startIndex + length[batchIndex];
        for (leftIndex = startIndex; leftIndex < end && bytes[leftIndex] == 32; ++leftIndex) {
        }
        if (leftIndex == end) {
            outV.setVal(batchIndex, EMPTY_BYTES, 0, 0);
            return;
        }
        int rightLimit = leftIndex + 1;
        for (rightIndex = end - 1; rightIndex >= rightLimit && bytes[rightIndex] == 32; --rightIndex) {
        }
        int resultLength = rightIndex - leftIndex + 1;
        if (resultLength <= 0) {
            throw new RuntimeException("Not expected");
        }
        outV.setVal(batchIndex, bytes, leftIndex, resultLength);
    }
}

