/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.util.DescriptionTest;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class MapJoinTestDescription
extends DescriptionTest {
    final VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation;
    public String[] bigTableColumnNames;
    public TypeInfo[] bigTableTypeInfos;
    public int[] bigTableKeyColumnNums;
    public String[] smallTableValueColumnNames;
    public TypeInfo[] smallTableValueTypeInfos;
    public int[] bigTableRetainColumnNums;
    public int[] smallTableRetainKeyColumnNums;
    public int[] smallTableRetainValueColumnNums;
    public SmallTableGenerationParameters smallTableGenerationParameters;
    public List<String> bigTableColumnNamesList;
    public String[] bigTableKeyColumnNames;
    public TypeInfo[] bigTableKeyTypeInfos;
    public List<String> smallTableValueColumnNamesList;
    public ObjectInspector[] bigTableObjectInspectors;
    public List<ObjectInspector> bigTableObjectInspectorsList;
    public StandardStructObjectInspector bigTableStandardObjectInspector;
    public PrimitiveTypeInfo[] smallTableValuePrimitiveTypeInfos;
    public ObjectInspector[] smallTableObjectInspectors;
    public PrimitiveObjectInspector.PrimitiveCategory[] smallTablePrimitiveCategories;
    public List<ObjectInspector> smallTableObjectInspectorsList;
    public StandardStructObjectInspector smallTableStandardObjectInspector;
    public ObjectInspector[] inputObjectInspectors;
    public String[] outputColumnNames;
    public TypeInfo[] outputTypeInfos;
    public ObjectInspector[] outputObjectInspectors;

    public MapJoinTestDescription(HiveConf hiveConf, VectorMapJoinDesc.VectorMapJoinVariation vectorMapJoinVariation, String[] bigTableColumnNames, TypeInfo[] bigTableTypeInfos, int[] bigTableKeyColumnNums, String[] smallTableValueColumnNames, TypeInfo[] smallTableValueTypeInfos, int[] bigTableRetainColumnNums, int[] smallTableRetainKeyColumnNums, int[] smallTableRetainValueColumnNums, SmallTableGenerationParameters smallTableGenerationParameters) {
        super(hiveConf);
        this.vectorMapJoinVariation = vectorMapJoinVariation;
        this.bigTableColumnNames = bigTableColumnNames;
        this.bigTableTypeInfos = bigTableTypeInfos;
        this.bigTableKeyColumnNums = bigTableKeyColumnNums;
        this.smallTableValueColumnNames = smallTableValueColumnNames;
        this.smallTableValueTypeInfos = smallTableValueTypeInfos;
        this.bigTableRetainColumnNums = bigTableRetainColumnNums;
        this.smallTableRetainKeyColumnNums = smallTableRetainKeyColumnNums;
        this.smallTableRetainValueColumnNums = smallTableRetainValueColumnNums;
        this.smallTableGenerationParameters = smallTableGenerationParameters;
        switch (vectorMapJoinVariation) {
            case INNER_BIG_ONLY: 
            case LEFT_SEMI: {
                this.trimAwaySmallTableValueInfo();
                break;
            }
            case INNER: 
            case OUTER: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator variation " + vectorMapJoinVariation);
            }
        }
        this.computeDerived();
    }

    public SmallTableGenerationParameters getSmallTableGenerationParameters() {
        return this.smallTableGenerationParameters;
    }

    public void computeDerived() {
        int i;
        int i2;
        this.bigTableColumnNamesList = Arrays.asList(this.bigTableColumnNames);
        this.bigTableKeyColumnNames = new String[this.bigTableKeyColumnNums.length];
        this.bigTableKeyTypeInfos = new TypeInfo[this.bigTableKeyColumnNums.length];
        for (i2 = 0; i2 < this.bigTableKeyColumnNums.length; ++i2) {
            this.bigTableKeyColumnNames[i2] = this.bigTableColumnNames[this.bigTableKeyColumnNums[i2]];
            this.bigTableKeyTypeInfos[i2] = this.bigTableTypeInfos[this.bigTableKeyColumnNums[i2]];
        }
        this.smallTableValueColumnNamesList = Arrays.asList(this.smallTableValueColumnNames);
        this.bigTableObjectInspectors = new ObjectInspector[this.bigTableTypeInfos.length];
        for (i2 = 0; i2 < this.bigTableTypeInfos.length; ++i2) {
            this.bigTableObjectInspectors[i2] = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)this.bigTableTypeInfos[i2]));
        }
        this.bigTableObjectInspectorsList = Arrays.asList(this.bigTableObjectInspectors);
        this.smallTableObjectInspectors = new ObjectInspector[this.smallTableValueTypeInfos.length];
        this.smallTablePrimitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[this.smallTableValueTypeInfos.length];
        this.smallTableValuePrimitiveTypeInfos = new PrimitiveTypeInfo[this.smallTableValueTypeInfos.length];
        for (i2 = 0; i2 < this.smallTableValueTypeInfos.length; ++i2) {
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)this.smallTableValueTypeInfos[i2];
            this.smallTableObjectInspectors[i2] = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo);
            this.smallTablePrimitiveCategories[i2] = primitiveTypeInfo.getPrimitiveCategory();
            this.smallTableValuePrimitiveTypeInfos[i2] = primitiveTypeInfo;
        }
        this.smallTableObjectInspectorsList = Arrays.asList(this.smallTableObjectInspectors);
        this.bigTableStandardObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.bigTableColumnNamesList, Arrays.asList(this.bigTableObjectInspectors));
        this.smallTableStandardObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.smallTableValueColumnNamesList, Arrays.asList(this.smallTableObjectInspectors));
        this.inputObjectInspectors = new ObjectInspector[]{this.bigTableStandardObjectInspector, this.smallTableStandardObjectInspector};
        int outputLength = this.bigTableRetainColumnNums.length + this.smallTableRetainKeyColumnNums.length + this.smallTableRetainValueColumnNums.length;
        this.outputColumnNames = this.createOutputColumnNames(outputLength);
        this.outputTypeInfos = new TypeInfo[outputLength];
        int outputIndex = 0;
        for (i = 0; i < this.bigTableRetainColumnNums.length; ++i) {
            this.outputTypeInfos[outputIndex++] = this.bigTableTypeInfos[this.bigTableRetainColumnNums[i]];
        }
        for (i = 0; i < this.smallTableRetainValueColumnNums.length; ++i) {
            this.outputTypeInfos[outputIndex++] = this.smallTableValueTypeInfos[this.smallTableRetainValueColumnNums[i]];
        }
        this.outputObjectInspectors = new ObjectInspector[outputLength];
        for (i = 0; i < outputLength; ++i) {
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)this.outputTypeInfos[i];
            this.outputObjectInspectors[i] = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo);
        }
    }

    public void trimAwaySmallTableValueInfo() {
        this.smallTableValueColumnNames = new String[0];
        this.smallTableValueTypeInfos = new TypeInfo[0];
        this.smallTableRetainKeyColumnNums = new int[0];
        this.smallTableRetainValueColumnNums = new int[0];
    }

    private String[] createOutputColumnNames(int outputColumnCount) {
        String[] outputColumnNames = new String[outputColumnCount];
        int counter = 1;
        for (int i = 0; i < outputColumnCount; ++i) {
            outputColumnNames[i] = "out" + counter++;
        }
        return outputColumnNames;
    }

    public static class SmallTableGenerationParameters {
        private ValueOption valueOption = ValueOption.NO_RESTRICTION;
        private int keyOutOfAThousand = 50;
        private int noMatchKeyOutOfAThousand = 50;

        public void setValueOption(ValueOption valueOption) {
            this.valueOption = valueOption;
        }

        public ValueOption getValueOption() {
            return this.valueOption;
        }

        public void setKeyOutOfAThousand(int keyOutOfAThousand) {
            this.keyOutOfAThousand = keyOutOfAThousand;
        }

        public int getKeyOutOfAThousand() {
            return this.keyOutOfAThousand;
        }

        public void setNoMatchKeyOutOfAThousand(int noMatchKeyOutOfAThousand) {
            this.noMatchKeyOutOfAThousand = noMatchKeyOutOfAThousand;
        }

        public int getNoMatchKeyOutOfAThousand() {
            return this.noMatchKeyOutOfAThousand;
        }

        public static enum ValueOption {
            NO_RESTRICTION,
            ONLY_ONE,
            ONLY_TWO,
            AT_LEAST_TWO;

        }
    }
}

