/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class TestGenericUDFAbs
extends TestCase {
    public void testInt() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableIntObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new IntWritable(107));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        IntWritable output = (IntWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for INT failed ", (int)107, (int)output.get());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new IntWritable(-107));
        args[0] = valueObj;
        output = (IntWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for INT failed ", (int)107, (int)output.get());
    }

    public void testLong() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableLongObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new LongWritable(107L));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        LongWritable output = (LongWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for LONG failed ", (long)107L, (long)output.get());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new LongWritable(-107L));
        args[0] = valueObj;
        output = (LongWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for LONG failed ", (long)107L, (long)output.get());
    }

    public void testDouble() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableDoubleObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new DoubleWritable(107.78));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for Double failed ", (Object)107.78, (Object)output.get());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new DoubleWritable(-107.78));
        args[0] = valueObj;
        output = (DoubleWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for Double failed ", (Object)107.78, (Object)output.get());
    }

    public void testFloat() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableFloatObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new FloatWritable(107.78f));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertTrue((String)"abs() test for Float failed ", (Math.abs(107.78 - output.get()) < 1.0E-4 ? 1 : 0) != 0);
        valueObj = new GenericUDF.DeferredJavaObject((Object)new FloatWritable(-107.78f));
        args[0] = valueObj;
        output = (DoubleWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertTrue((String)"abs() test for Float failed ", (Math.abs(107.78 - output.get()) < 1.0E-4 ? 1 : 0) != 0);
    }

    public void testText() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new Text("123.45"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for String failed ", (String)"123.45", (String)output.toString());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new Text("-123.45"));
        args[0] = valueObj;
        output = (DoubleWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for String failed ", (String)"123.45", (String)output.toString());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new Text("foo"));
        args[0] = valueObj;
        output = (DoubleWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for String failed ", null, (Object)output);
    }

    public void testHiveDecimal() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        int prec = 12;
        int scale = 9;
        AbstractPrimitiveWritableObjectInspector valueOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)prec, (int)scale));
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        PrimitiveObjectInspector outputOI = (PrimitiveObjectInspector)udf.initialize(arguments);
        TestGenericUDFAbs.assertEquals((String)"result precision for abs()", (int)prec, (int)outputOI.precision());
        TestGenericUDFAbs.assertEquals((String)"result scale for abs()", (int)scale, (int)outputOI.scale());
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new HiveDecimalWritable(HiveDecimal.create((String)"107.123456789")));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        HiveDecimalWritable output = (HiveDecimalWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for HiveDecimal failed ", (Object)107.123456789, (Object)output.getHiveDecimal().doubleValue());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new HiveDecimalWritable(HiveDecimal.create((String)"-107.123456789")));
        args[0] = valueObj;
        output = (HiveDecimalWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() test for HiveDecimal failed ", (Object)107.123456789, (Object)output.getHiveDecimal().doubleValue());
        args[0] = new GenericUDF.DeferredJavaObject(null);
        output = (HiveDecimalWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs(null)", null, (Object)output);
        args[0] = new GenericUDF.DeferredJavaObject((Object)new HiveDecimalWritable(HiveDecimal.create((String)"-1000.123456")));
        output = (HiveDecimalWritable)udf.evaluate(args);
        TestGenericUDFAbs.assertEquals((String)"abs() of too large decimal value", null, (Object)output);
    }
}

