/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.ClearDanglingScratchDir;
import org.apache.hadoop.hive.ql.session.ClearScratchDirUtil;
import org.apache.hadoop.hive.ql.testutil.FileTestUtil;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestClearScratchDirUtil {
    private FileSystem fs;
    private HiveConf conf;
    @Mock
    private YarnClient yarnClient;
    @Mock
    private ApplicationReport applicationReport;
    @Mock
    private JobClient jobClient;
    @Mock
    private RunningJob runningJob;

    @Before
    public void setup() throws IOException {
        this.conf = new HiveConf();
        this.conf.set("fs.default.name", "file:///");
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    @Test
    public void parseTest() {
        String appIdAsString = "application_1551963414414_0047";
        long clusterTimeStamp = 1551963414414L;
        int id = 47;
        ApplicationId actualAppId = ClearScratchDirUtil.parseFrom((String)appIdAsString);
        ApplicationId expectedAppId = ApplicationId.newInstance((long)clusterTimeStamp, (int)id);
        Assert.assertEquals((Object)expectedAppId, (Object)actualAppId);
    }

    @Test
    public void hasActiveJobsTestTrue() throws IOException {
        Path activeJobsPath = new Path(FileTestUtil.getPathFromResources("cleaning/active_jobs"));
        JobID jobID_0 = JobID.forName((String)"job_1551963414414_0004");
        Mockito.when((Object)this.runningJob.isComplete()).thenReturn((Object)false);
        Mockito.when((Object)this.jobClient.getJob(jobID_0)).thenReturn((Object)this.runningJob);
        Assert.assertTrue((boolean)ClearScratchDirUtil.hasActiveJobs((FileSystem)this.fs, (Path)activeJobsPath, (JobClient)this.jobClient));
    }

    @Test
    public void hasActiveJobsTestFalse() throws IOException {
        Path activeJobsPath = new Path(FileTestUtil.getPathFromResources("cleaning/active_jobs"));
        JobID jobID_0 = JobID.forName((String)"job_1551963414414_0004");
        JobID jobID_1 = JobID.forName((String)"job_1551963414418_0005");
        Mockito.when((Object)this.runningJob.isComplete()).thenReturn((Object)true);
        Mockito.when((Object)this.jobClient.getJob(jobID_0)).thenReturn((Object)this.runningJob);
        Mockito.when((Object)this.jobClient.getJob(jobID_1)).thenReturn((Object)this.runningJob);
        Assert.assertFalse((boolean)ClearScratchDirUtil.hasActiveJobs((FileSystem)this.fs, (Path)activeJobsPath, (JobClient)this.jobClient));
    }

    @Test
    public void hasActiveAppsTestTrue() throws IOException, YarnException {
        Path activeAppsPath = new Path(FileTestUtil.getPathFromResources("cleaning/active_apps"));
        ApplicationId applicationId_0 = ClearScratchDirUtil.parseFrom((String)"application_1551963414414_0046");
        Mockito.when((Object)this.applicationReport.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        Mockito.when((Object)this.yarnClient.getApplicationReport(applicationId_0)).thenReturn((Object)this.applicationReport);
        Assert.assertTrue((boolean)ClearScratchDirUtil.hasActiveApps((FileSystem)this.fs, (Path)activeAppsPath, (YarnClient)this.yarnClient));
    }

    @Test
    public void hasActiveAppsTestFalse() throws IOException, YarnException {
        Path activeAppsPath = new Path(FileTestUtil.getPathFromResources("cleaning/active_apps"));
        ApplicationId applicationId_0 = ClearScratchDirUtil.parseFrom((String)"application_1551963414414_0046");
        ApplicationId applicationId_1 = ClearScratchDirUtil.parseFrom((String)"application_1551963414428_0056");
        Mockito.when((Object)this.applicationReport.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.FINISHED);
        Mockito.when((Object)this.yarnClient.getApplicationReport(applicationId_0)).thenReturn((Object)this.applicationReport);
        Mockito.when((Object)this.yarnClient.getApplicationReport(applicationId_1)).thenReturn((Object)this.applicationReport);
        Assert.assertFalse((boolean)ClearScratchDirUtil.hasActiveApps((FileSystem)this.fs, (Path)activeAppsPath, (YarnClient)this.yarnClient));
    }

    @Test
    public void localDanglingFilesCleaning() throws Exception {
        String appId = "appId_" + System.currentTimeMillis();
        String userName = System.getProperty("user.name");
        String hdfs = "hdfs";
        String inuse = "inuse.lck";
        String l = File.separator;
        Path hdfsRootDir = new Path(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.SCRATCHDIR) + l + userName + l + hdfs);
        Path hdfsSessionDir = new Path(hdfsRootDir + l + userName + l + appId);
        Path hdfsSessionLock = new Path(hdfsSessionDir + l + inuse);
        this.fs.create(hdfsSessionLock);
        String localTmpDir = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LOCALSCRATCHDIR);
        Path localSessionDir = new Path(localTmpDir + l + appId);
        Path localPipeOutFileRemove = new Path(localTmpDir + l + appId + "-started-with-session-name.pipeout");
        Path localPipeOutFileNotRemove = new Path(localTmpDir + l + "not-started-with-session-name" + appId + ".pipeout");
        this.fs.mkdirs(localSessionDir);
        this.fs.create(localPipeOutFileRemove);
        this.fs.create(localPipeOutFileNotRemove);
        ClearDanglingScratchDir clearDanglingScratchDirMain = new ClearDanglingScratchDir(false, false, true, hdfsRootDir.toString(), this.conf);
        clearDanglingScratchDirMain.run();
        Assert.assertFalse((String)("HDFS session dir '" + hdfsSessionDir + "' still exists, should have been removed!"), (boolean)this.fs.exists(hdfsSessionDir));
        Assert.assertFalse((String)("Local session dir '" + localSessionDir + "' still exists, should have been removed!"), (boolean)this.fs.exists(localSessionDir));
        Assert.assertFalse((String)("Local .pipeout file '" + localPipeOutFileRemove + "' still exists, should have been removed!"), (boolean)this.fs.exists(localPipeOutFileRemove));
        Assert.assertTrue((String)("Local .pipeout file '" + localPipeOutFileNotRemove + "' does not exist, should have not been removed!"), (boolean)this.fs.exists(localPipeOutFileNotRemove));
    }
}

