/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util.batchgen;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.batchgen.VectorBatchGenerator;
import org.apache.hadoop.hive.serde2.RandomTypeUtil;

public class VectorColumnGroupGenerator {
    private VectorBatchGenerator.GenerateType[] generateTypes;
    private int[] columnNums;
    private Object[] arrays;

    public VectorColumnGroupGenerator(int columnNum, VectorBatchGenerator.GenerateType generateType) {
        this.columnNums = new int[]{columnNum};
        this.generateTypes = new VectorBatchGenerator.GenerateType[]{generateType};
        this.allocateArrays(1024);
    }

    public VectorColumnGroupGenerator(int startColumnNum, VectorBatchGenerator.GenerateType[] generateTypes) {
        this.columnNums = new int[generateTypes.length];
        for (int i = 0; i < generateTypes.length; ++i) {
            this.columnNums[i] = startColumnNum + i;
        }
        this.generateTypes = generateTypes;
        this.allocateArrays(1024);
    }

    public VectorBatchGenerator.GenerateType[] generateTypes() {
        return this.generateTypes;
    }

    private void allocateArrays(int size) {
        this.arrays = new Object[this.generateTypes.length];
        for (int i = 0; i < this.generateTypes.length; ++i) {
            VectorBatchGenerator.GenerateType generateType = this.generateTypes[i];
            VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
            Object[] array = null;
            switch (category) {
                case BOOLEAN: {
                    array = new boolean[size];
                    break;
                }
                case BYTE: {
                    array = new byte[size];
                    break;
                }
                case SHORT: {
                    array = new short[size];
                    break;
                }
                case INT: {
                    array = new int[size];
                    break;
                }
                case LONG: {
                    array = new long[size];
                    break;
                }
                case FLOAT: {
                    array = new float[size];
                    break;
                }
                case DOUBLE: {
                    array = new double[size];
                    break;
                }
                case STRING: {
                    array = new String[size];
                    break;
                }
                case TIMESTAMP: {
                    array = new Timestamp[size];
                    break;
                }
            }
            this.arrays[i] = array;
        }
    }

    public void clearColumnValueArrays() {
        block11: for (int i = 0; i < this.generateTypes.length; ++i) {
            VectorBatchGenerator.GenerateType generateType = this.generateTypes[i];
            VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
            Object array = this.arrays[i];
            switch (category) {
                case BOOLEAN: {
                    Arrays.fill((boolean[])array, false);
                    continue block11;
                }
                case BYTE: {
                    Arrays.fill((byte[])array, (byte)0);
                    continue block11;
                }
                case SHORT: {
                    Arrays.fill((short[])array, (short)0);
                    continue block11;
                }
                case INT: {
                    Arrays.fill((int[])array, 0);
                    continue block11;
                }
                case LONG: {
                    Arrays.fill((long[])array, 0L);
                    continue block11;
                }
                case FLOAT: {
                    Arrays.fill((float[])array, 0.0f);
                    continue block11;
                }
                case DOUBLE: {
                    Arrays.fill((double[])array, 0.0);
                    continue block11;
                }
                case STRING: {
                    Arrays.fill((String[])array, null);
                    continue block11;
                }
                case TIMESTAMP: {
                    Arrays.fill((Timestamp[])array, null);
                    continue block11;
                }
            }
        }
    }

    public void generateRowValues(int rowIndex, Random random) {
        for (int i = 0; i < this.generateTypes.length; ++i) {
            this.generateRowColumnValue(rowIndex, i, random);
        }
    }

    private void generateRowColumnValue(int rowIndex, int columnIndex, Random random) {
        VectorBatchGenerator.GenerateType generateType = this.generateTypes[columnIndex];
        VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
        Object array = this.arrays[columnIndex];
        switch (category) {
            case BOOLEAN: {
                boolean value;
                ((boolean[])array)[rowIndex] = value = random.nextBoolean();
                break;
            }
            case BYTE: {
                byte value;
                ((byte[])array)[rowIndex] = value = (byte)(random.nextBoolean() ? -random.nextInt(129) : random.nextInt(128));
                break;
            }
            case SHORT: {
                short value;
                ((short[])array)[rowIndex] = value = (short)(random.nextBoolean() ? -random.nextInt(32769) : random.nextInt(32768));
                break;
            }
            case INT: {
                int value;
                ((int[])array)[rowIndex] = value = random.nextInt();
                break;
            }
            case LONG: {
                long value;
                ((long[])array)[rowIndex] = value = random.nextLong();
                break;
            }
            case FLOAT: {
                float value;
                ((float[])array)[rowIndex] = value = (float)random.nextLong();
                break;
            }
            case DOUBLE: {
                double value;
                ((double[])array)[rowIndex] = value = (double)random.nextLong();
                break;
            }
            case STRING: {
                String value;
                ((String[])array)[rowIndex] = value = RandomTypeUtil.getRandString((Random)random);
                break;
            }
            case TIMESTAMP: {
                Timestamp value;
                ((Timestamp[])array)[rowIndex] = value = RandomTypeUtil.getRandTimestamp((Random)random).toSqlTimestamp();
                break;
            }
        }
    }

    public void fillDownRowValues(int rowIndex, int seriesCount, Random random) {
        for (int i = 0; i < this.generateTypes.length; ++i) {
            this.fillDownRowColumnValue(rowIndex, i, seriesCount, random);
        }
    }

    private void fillDownRowColumnValue(int rowIndex, int columnIndex, int seriesCount, Random random) {
        VectorBatchGenerator.GenerateType generateType = this.generateTypes[columnIndex];
        VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
        Object array = this.arrays[columnIndex];
        switch (category) {
            case BOOLEAN: {
                boolean[] booleanArray = (boolean[])array;
                boolean value = booleanArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    booleanArray[rowIndex + i] = value;
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = (byte[])array;
                byte value = byteArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    byteArray[rowIndex + i] = value;
                }
                break;
            }
            case SHORT: {
                short[] shortArray = (short[])array;
                short value = shortArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    shortArray[rowIndex + i] = value;
                }
                break;
            }
            case INT: {
                int[] intArray = (int[])array;
                int value = intArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    intArray[rowIndex + i] = value;
                }
                break;
            }
            case LONG: {
                long[] longArray = (long[])array;
                long value = longArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    longArray[rowIndex + i] = value;
                }
                break;
            }
            case FLOAT: {
                float[] floatArray = (float[])array;
                float value = floatArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    floatArray[rowIndex + i] = value;
                }
                break;
            }
            case DOUBLE: {
                double[] doubleArray = (double[])array;
                double value = doubleArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    doubleArray[rowIndex + i] = value;
                }
                break;
            }
            case STRING: {
                String[] stringArray = (String[])array;
                String value = stringArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    stringArray[rowIndex + i] = value;
                }
                break;
            }
            case TIMESTAMP: {
                Timestamp[] timestampArray = (Timestamp[])array;
                Timestamp value = timestampArray[rowIndex];
                for (int i = 1; i < seriesCount; ++i) {
                    timestampArray[rowIndex + i] = value;
                }
                break;
            }
        }
    }

    public void generateDownRowValues(int rowIndex, int seriesCount, Random random) {
        for (int i = 0; i < this.generateTypes.length; ++i) {
            for (int g = 1; g < seriesCount; ++g) {
                this.generateRowColumnValue(rowIndex + g, i, random);
            }
        }
    }

    public void populateBatch(VectorizedRowBatch batch, int size, boolean isRepeated) {
        assert (!isRepeated);
        for (int i = 0; i < size; ++i) {
            for (int g = 0; g < this.generateTypes.length; ++g) {
                this.populateBatchColumn(batch, g, size);
            }
        }
    }

    private void populateBatchColumn(VectorizedRowBatch batch, int logicalColumnIndex, int size) {
        int columnNum = this.columnNums[logicalColumnIndex];
        ColumnVector colVector = batch.cols[columnNum];
        VectorBatchGenerator.GenerateType generateType = this.generateTypes[logicalColumnIndex];
        VectorBatchGenerator.GenerateType.GenerateCategory category = generateType.getCategory();
        Object array = this.arrays[logicalColumnIndex];
        switch (category) {
            case BOOLEAN: {
                boolean[] booleanArray = (boolean[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = booleanArray[i] ? 1 : 0;
                }
                break;
            }
            case BYTE: {
                byte[] byteArray = (byte[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = byteArray[i];
                }
                break;
            }
            case SHORT: {
                short[] shortArray = (short[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = shortArray[i];
                }
                break;
            }
            case INT: {
                int[] intArray = (int[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = intArray[i];
                }
                break;
            }
            case LONG: {
                long[] longArray = (long[])array;
                long[] vector = ((LongColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = longArray[i];
                }
                break;
            }
            case FLOAT: {
                float[] floatArray = (float[])array;
                double[] vector = ((DoubleColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = floatArray[i];
                }
                break;
            }
            case DOUBLE: {
                double[] doubleArray = (double[])array;
                double[] vector = ((DoubleColumnVector)colVector).vector;
                for (int i = 0; i < size; ++i) {
                    vector[i] = doubleArray[i];
                }
                break;
            }
            case STRING: {
                String[] stringArray = (String[])array;
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    byte[] bytes = stringArray[i].getBytes();
                    bytesColVec.setVal(i, bytes);
                }
                break;
            }
            case TIMESTAMP: {
                Timestamp[] timestampArray = (Timestamp[])array;
                TimestampColumnVector timestampColVec = (TimestampColumnVector)colVector;
                for (int i = 0; i < size; ++i) {
                    Timestamp timestamp = timestampArray[i];
                    timestampColVec.set(i, timestamp);
                }
                break;
            }
        }
    }
}

