/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.RetryUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Ignore
public class TestMsckCreatePartitionsInBatches {
    private static HiveConf hiveConf;
    private static DDLTask ddlTask;
    private final String tableName = "test_msck_batch";
    private static Hive db;
    private List<String> repairOutput;
    private Table table;

    @BeforeClass
    public static void setupClass() throws HiveException {
        hiveConf = new HiveConf(TestMsckCreatePartitionsInBatches.class);
        hiveConf.set("fs.defaultFS", "file:///");
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_MSCK_REPAIR_BATCH_SIZE, 5);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)hiveConf);
        db = Hive.get((HiveConf)hiveConf);
        ddlTask = new DDLTask();
    }

    @Before
    public void before() throws Exception {
        this.createPartitionedTable("default", "test_msck_batch");
        this.table = db.getTable("test_msck_batch");
        this.repairOutput = new ArrayList<String>();
    }

    @After
    public void after() throws Exception {
        this.cleanUpTableQuietly("default", "test_msck_batch");
    }

    private Table createPartitionedTable(String dbName, String tableName) throws Exception {
        try {
            db.dropTable(dbName, tableName);
            db.createTable(tableName, Arrays.asList("key", "value"), Arrays.asList("city"), TextInputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
            return db.getTable(dbName, tableName);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unable to drop and create table " + StatsUtils.getFullyQualifiedTableName((String)dbName, (String)tableName) + " because " + StringUtils.stringifyException((Throwable)exception)));
            throw exception;
        }
    }

    private void cleanUpTableQuietly(String dbName, String tableName) {
        try {
            db.dropTable(dbName, tableName, true, true, true);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)exception)));
        }
    }

    private Set<CheckResult.PartitionResult> createPartsNotInMs(int numOfParts) {
        HashSet<CheckResult.PartitionResult> partsNotInMs = new HashSet<CheckResult.PartitionResult>();
        for (int i = 0; i < numOfParts; ++i) {
            CheckResult.PartitionResult result = new CheckResult.PartitionResult();
            result.setPartitionName("city=dummyCity_" + String.valueOf(i));
            partsNotInMs.add(result);
        }
        return partsNotInMs;
    }

    @Test
    public void testNumberOfCreatePartitionCalls() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(10);
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        ddlTask.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 5, 2, 0);
        ArgumentCaptor argument = ArgumentCaptor.forClass(AddPartitionDesc.class);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)2))).createPartitions((AddPartitionDesc)argument.capture());
        List apds = argument.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)5L, (long)((AddPartitionDesc)apds.get(0)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)5L, (long)((AddPartitionDesc)apds.get(1)).getPartitionCount());
    }

    @Test
    public void testUnevenNumberOfCreatePartitionCalls() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(9);
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        ddlTask.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 5, 2, 0);
        ArgumentCaptor argument = ArgumentCaptor.forClass(AddPartitionDesc.class);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)2))).createPartitions((AddPartitionDesc)argument.capture());
        List apds = argument.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)5L, (long)((AddPartitionDesc)apds.get(0)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)4L, (long)((AddPartitionDesc)apds.get(1)).getPartitionCount());
    }

    @Test
    public void testEqualNumberOfPartitions() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(13);
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        ddlTask.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 13, 2, 0);
        ArgumentCaptor argument = ArgumentCaptor.forClass(AddPartitionDesc.class);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)1))).createPartitions((AddPartitionDesc)argument.capture());
        Assert.assertEquals((String)"Unexpected number of batch size", (long)13L, (long)((AddPartitionDesc)argument.getValue()).getPartitionCount());
    }

    @Test
    public void testSmallNumberOfPartitions() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(10);
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        ddlTask.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 20, 2, 0);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)1))).createPartitions((AddPartitionDesc)Mockito.anyObject());
        ArgumentCaptor argument = ArgumentCaptor.forClass(AddPartitionDesc.class);
        ((Hive)Mockito.verify((Object)spyDb)).createPartitions((AddPartitionDesc)argument.capture());
        Assert.assertEquals((String)"Unexpected number of batch size", (long)10L, (long)((AddPartitionDesc)argument.getValue()).getPartitionCount());
    }

    @Test
    public void testBatchingWhenException() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(23);
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        ((Hive)Mockito.doThrow(HiveException.class).doCallRealMethod().doCallRealMethod().when((Object)spyDb)).createPartitions((AddPartitionDesc)Mockito.any(AddPartitionDesc.class));
        ddlTask.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 30, 2, 0);
        ArgumentCaptor argument = ArgumentCaptor.forClass(AddPartitionDesc.class);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)3))).createPartitions((AddPartitionDesc)argument.capture());
        List apds = argument.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)23L, (long)((AddPartitionDesc)apds.get(0)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)15L, (long)((AddPartitionDesc)apds.get(1)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)8L, (long)((AddPartitionDesc)apds.get(2)).getPartitionCount());
    }

    @Test
    public void testRetriesExhaustedBatchSize() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(17);
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        ((Hive)Mockito.doThrow(HiveException.class).when((Object)spyDb)).createPartitions((AddPartitionDesc)Mockito.any(AddPartitionDesc.class));
        Exception ex = null;
        try {
            ddlTask.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 30, 2, 0);
        }
        catch (Exception retryEx) {
            ex = retryEx;
        }
        Assert.assertFalse((String)"Exception was expected but was not thrown", (ex == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected class of exception thrown", (boolean)(ex instanceof RetryUtilities.RetryException));
        ArgumentCaptor argument = ArgumentCaptor.forClass(AddPartitionDesc.class);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)5))).createPartitions((AddPartitionDesc)argument.capture());
        List apds = argument.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)17L, (long)((AddPartitionDesc)apds.get(0)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)15L, (long)((AddPartitionDesc)apds.get(1)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)7L, (long)((AddPartitionDesc)apds.get(2)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)3L, (long)((AddPartitionDesc)apds.get(3)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)1L, (long)((AddPartitionDesc)apds.get(4)).getPartitionCount());
    }

    @Test
    public void testMaxRetriesReached() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(17);
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        ((Hive)Mockito.doThrow(HiveException.class).when((Object)spyDb)).createPartitions((AddPartitionDesc)Mockito.any(AddPartitionDesc.class));
        Exception ex = null;
        try {
            ddlTask.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 30, 2, 2);
        }
        catch (Exception retryEx) {
            ex = retryEx;
        }
        Assert.assertFalse((String)"Exception was expected but was not thrown", (ex == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected class of exception thrown", (boolean)(ex instanceof RetryUtilities.RetryException));
        ArgumentCaptor argument = ArgumentCaptor.forClass(AddPartitionDesc.class);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)2))).createPartitions((AddPartitionDesc)argument.capture());
        List apds = argument.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)17L, (long)((AddPartitionDesc)apds.get(0)).getPartitionCount());
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)15L, (long)((AddPartitionDesc)apds.get(1)).getPartitionCount());
    }

    @Test
    public void testOneMaxRetries() throws Exception {
        Set<CheckResult.PartitionResult> partsNotInMs = this.createPartsNotInMs(17);
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        ((Hive)Mockito.doThrow(HiveException.class).when((Object)spyDb)).createPartitions((AddPartitionDesc)Mockito.any(AddPartitionDesc.class));
        Exception ex = null;
        try {
            ddlTask.createPartitionsInBatches(spyDb, this.repairOutput, partsNotInMs, this.table, 30, 2, 1);
        }
        catch (Exception retryEx) {
            ex = retryEx;
        }
        Assert.assertFalse((String)"Exception was expected but was not thrown", (ex == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Unexpected class of exception thrown", (boolean)(ex instanceof RetryUtilities.RetryException));
        ArgumentCaptor argument = ArgumentCaptor.forClass(AddPartitionDesc.class);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)1))).createPartitions((AddPartitionDesc)argument.capture());
        List apds = argument.getAllValues();
        int retryAttempt = 1;
        Assert.assertEquals((String)String.format("Unexpected batch size in retry attempt %d ", retryAttempt++), (long)17L, (long)((AddPartitionDesc)apds.get(0)).getPartitionCount());
    }
}

