/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColDivideLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColModuloLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColAddDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColAddDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColDivideDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColDivideDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColModuloDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColModuloDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColMultiplyDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColMultiplyDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColSubtractDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColSubtractDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarAddDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarDivideDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarModuloDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarMultiplyDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarSubtractDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColAddLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColAddLongColumnChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColAddLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColAddLongScalarChecked;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorArithmeticExpressions {
    @Test
    public void testLongColAddLongScalarNoNulls() throws HiveException {
        this.longColAddLongScalarNoNulls(false);
    }

    @Test
    public void testLongColAddLongScalarCheckedNoNulls() throws HiveException {
        this.longColAddLongScalarNoNulls(true);
    }

    private void longColAddLongScalarNoNulls(boolean checked) throws HiveException {
        LongColAddLongScalarChecked expr;
        VectorizedRowBatch vrg = this.getVectorizedRowBatchSingleLongVector(1024);
        if (checked) {
            expr = new LongColAddLongScalarChecked(0, 23L, 1);
            expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        } else {
            expr = new LongColAddLongScalar(0, 23L, 1);
        }
        expr.evaluate(vrg);
        for (int i = 0; i < 1024; ++i) {
            junit.framework.Assert.assertEquals((long)(i * 37 + 23), (long)((LongColumnVector)vrg.cols[1]).vector[i]);
        }
        junit.framework.Assert.assertTrue((boolean)((LongColumnVector)vrg.cols[1]).noNulls);
        junit.framework.Assert.assertFalse((boolean)((LongColumnVector)vrg.cols[1]).isRepeating);
    }

    private VectorizedRowBatch getVectorizedRowBatchSingleLongVector(int size) {
        VectorizedRowBatch vrg = new VectorizedRowBatch(2, size);
        LongColumnVector lcv = new LongColumnVector(size);
        for (int i = 0; i < size; ++i) {
            lcv.vector[i] = i * 37;
        }
        vrg.cols[0] = lcv;
        vrg.cols[1] = new LongColumnVector(size);
        vrg.size = size;
        return vrg;
    }

    public static VectorizedRowBatch getVectorizedRowBatch2LongInDoubleOut() {
        int i;
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        LongColumnVector lcv = new LongColumnVector();
        for (i = 0; i < 1024; ++i) {
            lcv.vector[i] = i * 37;
        }
        batch.cols[0] = lcv;
        LongColumnVector lcv2 = new LongColumnVector();
        batch.cols[1] = lcv2;
        for (i = 0; i < 1024; ++i) {
            lcv2.vector[i] = i * 37;
        }
        batch.cols[2] = new DoubleColumnVector();
        batch.size = 1024;
        return batch;
    }

    @Test
    public void testLongColAddLongScalarWithNulls() throws HiveException {
        this.longColAddLongScalarCheckedWithNulls(false);
    }

    @Test
    public void testLongColAddLongScalarCheckedWithNulls() throws HiveException {
        this.longColAddLongScalarCheckedWithNulls(true);
    }

    private void longColAddLongScalarCheckedWithNulls(boolean isChecked) throws HiveException {
        LongColAddLongScalarChecked expr;
        VectorizedRowBatch batch = this.getVectorizedRowBatchSingleLongVector(1024);
        LongColumnVector lcv = (LongColumnVector)batch.cols[0];
        LongColumnVector lcvOut = (LongColumnVector)batch.cols[1];
        TestVectorizedRowBatch.addRandomNulls((ColumnVector)lcv);
        if (isChecked) {
            expr = new LongColAddLongScalarChecked(0, 23L, 1);
            expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        } else {
            expr = new LongColAddLongScalar(0, 23L, 1);
        }
        expr.evaluate(batch);
        for (int i = 0; i < 1024; ++i) {
            if (!lcv.isNull[i]) {
                junit.framework.Assert.assertEquals((long)(i * 37 + 23), (long)lcvOut.vector[i]);
                continue;
            }
            junit.framework.Assert.assertTrue((boolean)lcvOut.isNull[i]);
        }
        junit.framework.Assert.assertFalse((boolean)lcvOut.noNulls);
        junit.framework.Assert.assertFalse((boolean)lcvOut.isRepeating);
        TestVectorArithmeticExpressions.verifyLongNullDataVectorEntries(lcvOut, batch.selected, batch.selectedInUse, batch.size);
    }

    @Test
    public void testLongColAddLongScalarWithRepeating() throws HiveException {
        this.longColAddLongScalarWithRepeatingUtil(false);
    }

    @Test
    public void testLongColAddLongScalarCheckedWithRepeating() throws HiveException {
        this.longColAddLongScalarWithRepeatingUtil(true);
    }

    private void longColAddLongScalarWithRepeatingUtil(boolean isChecked) throws HiveException {
        LongColAddLongScalarChecked expr;
        VectorizedRowBatch batch = this.getVectorizedRowBatchSingleLongVector(1024);
        LongColumnVector in = (LongColumnVector)batch.cols[0];
        in.isRepeating = true;
        LongColumnVector out = (LongColumnVector)batch.cols[1];
        out.isRepeating = false;
        if (isChecked) {
            expr = new LongColAddLongScalarChecked(0, 23L, 1);
            expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        } else {
            expr = new LongColAddLongScalar(0, 23L, 1);
        }
        expr.evaluate(batch);
        junit.framework.Assert.assertTrue((boolean)out.isRepeating);
        junit.framework.Assert.assertTrue((boolean)out.noNulls);
        junit.framework.Assert.assertEquals((long)out.vector[0], (long)23L);
        batch = this.getVectorizedRowBatchSingleLongVector(1024);
        in = (LongColumnVector)batch.cols[0];
        in.isRepeating = true;
        in.noNulls = false;
        in.isNull[0] = true;
        out = (LongColumnVector)batch.cols[1];
        out.isRepeating = false;
        out.isNull[0] = false;
        out.noNulls = true;
        if (isChecked) {
            expr = new LongColAddLongScalarChecked(0, 23L, 1);
            expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        } else {
            expr = new LongColAddLongScalar(0, 23L, 1);
        }
        expr.evaluate(batch);
        junit.framework.Assert.assertTrue((boolean)out.isRepeating);
        junit.framework.Assert.assertFalse((boolean)out.noNulls);
        junit.framework.Assert.assertEquals((boolean)true, (boolean)out.isNull[0]);
        TestVectorArithmeticExpressions.verifyLongNullDataVectorEntries(out, batch.selected, batch.selectedInUse, batch.size);
    }

    public static void verifyLongNullDataVectorEntries(LongColumnVector v, int[] sel, boolean selectedInUse, int n) {
        block6: {
            block5: {
                if (n == 0 || v.noNulls) {
                    return;
                }
                if (!v.isRepeating) break block5;
                if (!v.isNull[0]) break block6;
                Assert.assertEquals((long)1L, (long)v.vector[0]);
                break block6;
            }
            if (selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!v.isNull[i]) continue;
                    Assert.assertEquals((long)1L, (long)v.vector[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (!v.isNull[i]) continue;
                    Assert.assertEquals((long)1L, (long)v.vector[i]);
                }
            }
        }
    }

    @Test
    public void testLongColAddLongColumn() throws HiveException {
        this.longColAddLongColumnUtil(false);
    }

    @Test
    public void testLongColAddLongColumnChecked() throws HiveException {
        this.longColAddLongColumnUtil(true);
    }

    private void longColAddLongColumnUtil(boolean isChecked) throws HiveException {
        LongColAddLongColumnChecked expr2;
        LongColAddLongColumnChecked expr;
        int seed = 17;
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(1024, 6, seed);
        LongColumnVector lcv0 = (LongColumnVector)vrg.cols[0];
        LongColumnVector lcv1 = (LongColumnVector)vrg.cols[1];
        LongColumnVector lcv2 = (LongColumnVector)vrg.cols[2];
        LongColumnVector lcv3 = (LongColumnVector)vrg.cols[3];
        LongColumnVector lcv4 = (LongColumnVector)vrg.cols[4];
        LongColumnVector lcv5 = (LongColumnVector)vrg.cols[5];
        if (isChecked) {
            expr = new LongColAddLongColumnChecked(0, 1, 2);
            expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        } else {
            expr = new LongColAddLongColumn(0, 1, 2);
        }
        expr.evaluate(vrg);
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)((i + 1) * seed * 3), (long)lcv2.vector[i]);
        }
        Assert.assertTrue((boolean)lcv2.noNulls);
        lcv1.noNulls = false;
        lcv1.isNull[1] = true;
        lcv2.isRepeating = true;
        lcv2.noNulls = true;
        expr.evaluate(vrg);
        Assert.assertTrue((boolean)lcv2.isNull[1]);
        Assert.assertFalse((boolean)lcv2.noNulls);
        Assert.assertFalse((boolean)lcv2.isRepeating);
        TestVectorArithmeticExpressions.verifyLongNullDataVectorEntries(lcv2, vrg.selected, vrg.selectedInUse, vrg.size);
        lcv0.noNulls = false;
        lcv0.isNull[1] = true;
        lcv0.isNull[3] = true;
        expr.evaluate(vrg);
        Assert.assertTrue((boolean)lcv2.isNull[1]);
        Assert.assertTrue((boolean)lcv2.isNull[3]);
        Assert.assertFalse((boolean)lcv2.noNulls);
        TestVectorArithmeticExpressions.verifyLongNullDataVectorEntries(lcv2, vrg.selected, vrg.selectedInUse, vrg.size);
        lcv3.isRepeating = true;
        if (isChecked) {
            expr2 = new LongColAddLongColumnChecked(3, 4, 5);
            expr2.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        } else {
            expr2 = new LongColAddLongColumn(3, 4, 5);
        }
        expr2.evaluate(vrg);
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)(seed * (4 + 5 * (i + 1))), (long)lcv5.vector[i]);
        }
        lcv4.noNulls = false;
        lcv4.isNull[0] = true;
        expr2.evaluate(vrg);
        Assert.assertTrue((boolean)lcv5.isNull[0]);
        Assert.assertFalse((boolean)lcv5.noNulls);
        TestVectorArithmeticExpressions.verifyLongNullDataVectorEntries(lcv5, vrg.selected, vrg.selectedInUse, vrg.size);
        lcv3.isRepeating = true;
        lcv3.noNulls = false;
        lcv3.isNull[0] = true;
        expr2.evaluate(vrg);
        Assert.assertFalse((boolean)lcv5.noNulls);
        Assert.assertTrue((boolean)lcv5.isRepeating);
        Assert.assertTrue((boolean)lcv5.isNull[0]);
        TestVectorArithmeticExpressions.verifyLongNullDataVectorEntries(lcv5, vrg.selected, vrg.selectedInUse, vrg.size);
        vrg.selectedInUse = false;
        lcv0.noNulls = true;
        lcv1.noNulls = true;
        lcv0.isRepeating = false;
        lcv1.isRepeating = false;
        lcv2.reset();
        expr.evaluate(vrg);
        Assert.assertTrue((boolean)lcv2.noNulls);
        Assert.assertFalse((boolean)lcv2.isRepeating);
    }

    @Test
    public void testLongColDivideLongColumn() throws HiveException {
        double eps = 1.0E-7;
        VectorizedRowBatch batch = TestVectorArithmeticExpressions.getVectorizedRowBatch2LongInDoubleOut();
        LongColDivideLongColumn expr = new LongColDivideLongColumn(0, 1, 2);
        batch.cols[0].isNull[1] = true;
        batch.cols[0].noNulls = false;
        batch.cols[1].noNulls = false;
        DoubleColumnVector out = (DoubleColumnVector)batch.cols[2];
        out.noNulls = true;
        out.isRepeating = true;
        expr.evaluate(batch);
        Assert.assertFalse((boolean)out.noNulls);
        Assert.assertTrue((boolean)out.isNull[0]);
        Assert.assertTrue((boolean)Double.isNaN(out.vector[0]));
        Assert.assertTrue((boolean)out.isNull[1]);
        Assert.assertTrue((boolean)Double.isNaN(out.vector[1]));
        for (int i = 2; i != batch.size; ++i) {
            Assert.assertTrue((out.vector[i] > 0.9999999 && out.vector[i] < 1.0000001 ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)out.noNulls);
        Assert.assertFalse((boolean)out.isRepeating);
    }

    @Test
    public void testLongColModuloLongColumn() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatch2LongInLongOut();
        LongColModuloLongColumn expr = new LongColModuloLongColumn(0, 1, 2);
        batch.cols[0].isNull[1] = true;
        batch.cols[0].noNulls = false;
        batch.cols[1].noNulls = false;
        LongColumnVector out = (LongColumnVector)batch.cols[2];
        out.noNulls = true;
        out.isRepeating = true;
        expr.evaluate(batch);
        Assert.assertFalse((boolean)out.noNulls);
        Assert.assertTrue((boolean)out.isNull[0]);
        Assert.assertTrue((boolean)out.isNull[1]);
        for (int i = 2; i != batch.size; ++i) {
            Assert.assertTrue((out.vector[i] == 0L ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)out.noNulls);
        Assert.assertFalse((boolean)out.isRepeating);
    }

    private VectorizedRowBatch getVectorizedRowBatch2LongInLongOut() {
        int i;
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        LongColumnVector lcv = new LongColumnVector();
        for (i = 0; i < 1024; ++i) {
            lcv.vector[i] = i * 37;
        }
        batch.cols[0] = lcv;
        LongColumnVector lcv2 = new LongColumnVector();
        batch.cols[1] = lcv2;
        for (i = 0; i < 1024; ++i) {
            lcv2.vector[i] = i * 37;
        }
        batch.cols[2] = new LongColumnVector();
        batch.size = 1024;
        return batch;
    }

    @Test
    public void testDecimalColAddDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColAddDecimalColumn expr = new DecimalColAddDecimalColumn(0, 1, 2);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-2.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1.00")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector c0 = (DecimalColumnVector)b.cols[0];
        c0.noNulls = false;
        c0.isNull[0] = true;
        r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((!r.noNulls && r.isNull[0] ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.01")));
        b = this.getVectorizedRowBatch3DecimalCols();
        c0 = (DecimalColumnVector)b.cols[0];
        c0.vector[0].set(HiveDecimal.create((String)"9999999999999999.99"));
        r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((!r.noNulls && r.isNull[0] ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.01")));
        b = this.getVectorizedRowBatch3DecimalCols();
        c0 = (DecimalColumnVector)b.cols[0];
        c0.isRepeating = true;
        r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        DecimalColumnVector c1 = (DecimalColumnVector)b.cols[1];
        c1.isRepeating = true;
        expr.evaluate(b);
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        b = this.getVectorizedRowBatch3DecimalCols();
        c1 = (DecimalColumnVector)b.cols[1];
        c1.isRepeating = true;
        c1.vector[0].set(HiveDecimal.create((String)"2.00"));
        r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.00")));
    }

    @Test
    public void testDecimalColSubtractDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColSubtractDecimalColumn expr = new DecimalColSubtractDecimalColumn(0, 1, 2);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-4.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1.00")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector c0 = (DecimalColumnVector)b.cols[0];
        c0.vector[0].set(HiveDecimal.create((String)"-9999999999999999.99"));
        r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((!r.noNulls && r.isNull[0] ? 1 : 0) != 0);
    }

    @Test
    public void testDecimalColMultiplyDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColMultiplyDecimalColumn expr = new DecimalColMultiplyDecimalColumn(0, 1, 2);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-3.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.00")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector c0 = (DecimalColumnVector)b.cols[0];
        c0.vector[0].set(HiveDecimal.create((String)"9999999999999999.99"));
        DecimalColumnVector c1 = (DecimalColumnVector)b.cols[1];
        c1.vector[0].set(HiveDecimal.create((String)"2.00"));
        r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertTrue((!r.noNulls && r.isNull[0] ? 1 : 0) != 0);
    }

    @Test
    public void testDecimalColAddDecimalScalar() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((int)1);
        DecimalColAddDecimalScalar expr = new DecimalColAddDecimalScalar(0, d, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-2.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        r = (DecimalColumnVector)b.cols[2];
        in.noNulls = false;
        in.isNull[0] = true;
        expr.evaluate(b);
        Assert.assertTrue((!r.noNulls ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.isRepeating = true;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.isRepeating = true;
        in.isNull[0] = true;
        in.noNulls = false;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((!r.noNulls ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.vector[0].set(HiveDecimal.create((String)"9999999999999999.99"));
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testDecimalColDivideDecimalScalar() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((String)"2.00");
        DecimalColDivideDecimalScalar expr = new DecimalColDivideDecimalScalar(0, d, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.6")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1.65")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        r = (DecimalColumnVector)b.cols[2];
        in.noNulls = false;
        in.isNull[0] = true;
        expr.evaluate(b);
        Assert.assertTrue((!r.noNulls ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.isRepeating = true;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.6")));
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.isRepeating = true;
        in.isNull[0] = true;
        in.noNulls = false;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((!r.noNulls ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        expr = new DecimalColDivideDecimalScalar(0, HiveDecimal.create((String)"0"), 2);
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
        Assert.assertTrue((boolean)r.isRepeating);
    }

    @Test
    public void testDecimalScalarDivideDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((String)"3.96");
        DecimalScalarDivideDecimalColumn expr = new DecimalScalarDivideDecimalColumn(d, 0, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"3.3")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1.2")));
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[2]);
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        r = (DecimalColumnVector)b.cols[2];
        in.noNulls = false;
        in.isNull[0] = true;
        expr.evaluate(b);
        Assert.assertTrue((!r.noNulls ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.isRepeating = true;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"3.3")));
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.isRepeating = true;
        in.isNull[0] = true;
        in.noNulls = false;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((!r.noNulls ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testDecimalColModuloDecimalScalar() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((String)"2.00");
        DecimalColModuloDecimalScalar expr = new DecimalColModuloDecimalScalar(0, d, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        in.vector[0].set(HiveDecimal.create((String)"15.40"));
        in.vector[1].set(HiveDecimal.create((String)"-17.20"));
        in.vector[2].set(HiveDecimal.create((String)"70.00"));
        d = HiveDecimal.create((String)"4.75");
        expr = new DecimalColModuloDecimalScalar(0, d, 2);
        expr.evaluate(b);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1.15")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-2.95")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"3.50")));
        d = HiveDecimal.create((String)"0.00");
        expr = new DecimalColModuloDecimalScalar(0, d, 2);
        expr.evaluate(b);
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
        Assert.assertTrue((boolean)r.isRepeating);
    }

    @Test
    public void testDecimalScalarModuloDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((String)"2.00");
        DecimalScalarModuloDecimalColumn expr = new DecimalScalarModuloDecimalColumn(d, 0, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.80")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.00")));
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[2]);
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        expr = new DecimalScalarModuloDecimalColumn(d, 0, 2);
        in.vector[0].set(HiveDecimal.create((String)"0.50"));
        in.vector[1].set(HiveDecimal.create((String)"0.80"));
        in.vector[2].set(HiveDecimal.create((String)"0.70"));
        expr.evaluate(b);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.00")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.40")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.60")));
    }

    @Test
    public void testDecimalColDivideDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in1 = (DecimalColumnVector)b.cols[1];
        for (int i = 0; i < 3; ++i) {
            in1.vector[i].set(HiveDecimal.create((String)"0.50"));
        }
        DecimalColDivideDecimalColumn expr = new DecimalColDivideDecimalColumn(0, 1, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.4")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-6.6")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        b.cols[1].noNulls = false;
        b.cols[1].isNull[0] = true;
        r = (DecimalColumnVector)b.cols[2];
        expr.evaluate(b);
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        b.cols[1].noNulls = false;
        b.cols[1].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
        Assert.assertFalse((boolean)r.isNull[1]);
        Assert.assertFalse((boolean)r.isNull[2]);
        b = this.getVectorizedRowBatch3DecimalCols();
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1.2")));
        b = this.getVectorizedRowBatch3DecimalCols();
        b.cols[1].isRepeating = true;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
        b = this.getVectorizedRowBatch3DecimalCols();
        b.cols[0].isRepeating = true;
        b.cols[1].isRepeating = true;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1.2")));
        b = this.getVectorizedRowBatch3DecimalCols();
        ((DecimalColumnVector)b.cols[1]).vector[0].set(HiveDecimal.create((String)"0"));
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testDecimalColModuloDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in1 = (DecimalColumnVector)b.cols[1];
        for (int i = 0; i < 3; ++i) {
            in1.vector[i].set(HiveDecimal.create((String)"0.50"));
        }
        DecimalColModuloDecimalColumn expr = new DecimalColModuloDecimalColumn(0, 1, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-0.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
    }

    @Test
    public void testDecimalColSubtractDecimalScalar() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((int)1);
        DecimalColSubtractDecimalScalar expr = new DecimalColSubtractDecimalScalar(0, d, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-4.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-1")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        in.vector[0].set(HiveDecimal.create((String)"-9999999999999999.99"));
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testDecimalColMultiplyDecimalScalar() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((int)2);
        DecimalColMultiplyDecimalScalar expr = new DecimalColMultiplyDecimalScalar(0, d, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.40")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-6.60")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        in.vector[0].set(HiveDecimal.create((String)"9999999999999999.99"));
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testDecimalScalarAddDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((int)1);
        DecimalScalarAddDecimalColumn expr = new DecimalScalarAddDecimalColumn(d, 0, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-2.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        r = (DecimalColumnVector)b.cols[2];
        in.noNulls = false;
        in.isNull[0] = true;
        expr.evaluate(b);
        Assert.assertTrue((!r.noNulls ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.isRepeating = true;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.20")));
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.isRepeating = true;
        in.isNull[0] = true;
        in.noNulls = false;
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.isRepeating);
        Assert.assertTrue((!r.noNulls ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r.isNull[0]);
        b = this.getVectorizedRowBatch3DecimalCols();
        in = (DecimalColumnVector)b.cols[0];
        in.vector[0].set(HiveDecimal.create((String)"9999999999999999.99"));
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testDecimalScalarSubtractDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((int)1);
        DecimalScalarSubtractDecimalColumn expr = new DecimalScalarSubtractDecimalColumn(d, 0, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-0.20")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"4.30")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"1")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        in.vector[0].set(HiveDecimal.create((String)"-9999999999999999.99"));
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    @Test
    public void testDecimalScalarMultiplyDecimalColumn() throws HiveException {
        VectorizedRowBatch b = this.getVectorizedRowBatch3DecimalCols();
        HiveDecimal d = HiveDecimal.create((int)2);
        DecimalScalarMultiplyDecimalColumn expr = new DecimalScalarMultiplyDecimalColumn(d, 0, 2);
        expr.evaluate(b);
        DecimalColumnVector r = (DecimalColumnVector)b.cols[2];
        Assert.assertTrue((boolean)r.vector[0].getHiveDecimal().equals((Object)HiveDecimal.create((String)"2.40")));
        Assert.assertTrue((boolean)r.vector[1].getHiveDecimal().equals((Object)HiveDecimal.create((String)"-6.60")));
        Assert.assertTrue((boolean)r.vector[2].getHiveDecimal().equals((Object)HiveDecimal.create((String)"0")));
        b = this.getVectorizedRowBatch3DecimalCols();
        DecimalColumnVector in = (DecimalColumnVector)b.cols[0];
        in.vector[0].set(HiveDecimal.create((String)"9999999999999999.99"));
        expr.evaluate(b);
        r = (DecimalColumnVector)b.cols[2];
        Assert.assertFalse((boolean)r.noNulls);
        Assert.assertTrue((boolean)r.isNull[0]);
    }

    private VectorizedRowBatch getVectorizedRowBatch3DecimalCols() {
        VectorizedRowBatch b = new VectorizedRowBatch(3);
        DecimalColumnVector v0 = new DecimalColumnVector(18, 2);
        b.cols[0] = v0;
        DecimalColumnVector v1 = new DecimalColumnVector(18, 2);
        b.cols[1] = v1;
        b.cols[2] = new DecimalColumnVector(18, 2);
        v0.vector[0].set(HiveDecimal.create((String)"1.20"));
        v0.vector[1].set(HiveDecimal.create((String)"-3.30"));
        v0.vector[2].set(HiveDecimal.create((String)"0"));
        v1.vector[0].set(HiveDecimal.create((String)"1.00"));
        v1.vector[1].set(HiveDecimal.create((String)"1.00"));
        v1.vector[2].set(HiveDecimal.create((String)"1.00"));
        b.size = 3;
        return b;
    }
}

