/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateFormat;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;

public class TestGenericUDFDateFormat
extends TestCase {
    public void testDateFormatStr() throws HiveException {
        GenericUDFDateFormat udf = new GenericUDFDateFormat();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text fmtText = new Text("EEEE");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)fmtText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("2015-04-05", fmtText, "Sunday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-06", fmtText, "Monday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-07", fmtText, "Tuesday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-08", fmtText, "Wednesday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-09", fmtText, "Thursday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-10", fmtText, "Friday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-11", fmtText, "Saturday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-12", fmtText, "Sunday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-05 10:30:45", fmtText, "Sunday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-06 10:30:45", fmtText, "Monday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-07 10:30:45", fmtText, "Tuesday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-08 10:30:45", fmtText, "Wednesday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-09 10:30", fmtText, "Thursday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-10 10:30:45.123", fmtText, "Friday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-11T10:30:45", fmtText, "Saturday", (GenericUDF)udf);
        this.runAndVerifyStr("2015-04-12 10", fmtText, "Sunday", (GenericUDF)udf);
    }

    public void testWrongDateStr() throws HiveException {
        GenericUDFDateFormat udf = new GenericUDFDateFormat();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text fmtText = new Text("EEEE");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)fmtText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("2016-02-30 10:30:45", fmtText, "Tuesday", (GenericUDF)udf);
        this.runAndVerifyStr("2014-01-32", fmtText, "Saturday", (GenericUDF)udf);
        this.runAndVerifyStr("01/14/2014", fmtText, null, (GenericUDF)udf);
        this.runAndVerifyStr(null, fmtText, null, (GenericUDF)udf);
    }

    public void testDateFormatDate() throws HiveException {
        GenericUDFDateFormat udf = new GenericUDFDateFormat();
        WritableDateObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        Text fmtText = new Text("EEEE");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)fmtText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyDate("2015-04-05", fmtText, "Sunday", (GenericUDF)udf);
        this.runAndVerifyDate("2015-04-06", fmtText, "Monday", (GenericUDF)udf);
        this.runAndVerifyDate("2015-04-07", fmtText, "Tuesday", (GenericUDF)udf);
        this.runAndVerifyDate("2015-04-08", fmtText, "Wednesday", (GenericUDF)udf);
        this.runAndVerifyDate("2015-04-09", fmtText, "Thursday", (GenericUDF)udf);
        this.runAndVerifyDate("2015-04-10", fmtText, "Friday", (GenericUDF)udf);
        this.runAndVerifyDate("2015-04-11", fmtText, "Saturday", (GenericUDF)udf);
        this.runAndVerifyDate("2015-04-12", fmtText, "Sunday", (GenericUDF)udf);
    }

    public void testDateFormatTs() throws HiveException {
        GenericUDFDateFormat udf = new GenericUDFDateFormat();
        WritableTimestampObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        Text fmtText = new Text("EEEE");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)fmtText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyTs("2015-04-08 10:30:45", fmtText, "Wednesday", (GenericUDF)udf);
        this.runAndVerifyTs("2015-04-05 10:30:45", fmtText, "Sunday", (GenericUDF)udf);
        this.runAndVerifyTs("2015-04-06 10:30:45", fmtText, "Monday", (GenericUDF)udf);
        this.runAndVerifyTs("2015-04-07 10:30:45", fmtText, "Tuesday", (GenericUDF)udf);
        this.runAndVerifyTs("2015-04-08 10:30:45", fmtText, "Wednesday", (GenericUDF)udf);
        this.runAndVerifyTs("2015-04-09 10:30:45", fmtText, "Thursday", (GenericUDF)udf);
        this.runAndVerifyTs("2015-04-10 10:30:45.123", fmtText, "Friday", (GenericUDF)udf);
        this.runAndVerifyTs("2015-04-11 10:30:45.123456789", fmtText, "Saturday", (GenericUDF)udf);
        this.runAndVerifyTs("2015-04-12 10:30:45", fmtText, "Sunday", (GenericUDF)udf);
    }

    public void testNullFmt() throws HiveException {
        GenericUDFDateFormat udf = new GenericUDFDateFormat();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text fmtText = null;
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, fmtText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("2015-04-05", fmtText, null, (GenericUDF)udf);
    }

    public void testWrongFmt() throws HiveException {
        GenericUDFDateFormat udf = new GenericUDFDateFormat();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text fmtText = new Text("Q");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)fmtText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyStr("2015-04-05", fmtText, null, (GenericUDF)udf);
    }

    private void runAndVerifyStr(String str, Text fmtText, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)fmtText);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFDateFormat.assertEquals((String)"date_format() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerifyDate(String str, Text fmtText, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new DateWritableV2(Date.valueOf((String)str)) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)fmtText);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFDateFormat.assertEquals((String)"date_format() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerifyTs(String str, Text fmtText, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new TimestampWritableV2(Timestamp.valueOf((String)str)) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)fmtText);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFDateFormat.assertEquals((String)"date_format() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }
}

