/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.Initiator;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.thrift.TException;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactorTest {
    private static final String CLASS_NAME = CompactorTest.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected TxnStore txnHandler;
    protected IMetaStoreClient ms;
    protected HiveConf conf;
    private final AtomicBoolean stop = new AtomicBoolean();
    protected File tmpdir;

    @Before
    public void setup() throws Exception {
        this.conf = new HiveConf();
        this.conf.set("fs.defaultFS", "file:///");
        TxnDbUtil.setConfValues((Configuration)this.conf);
        TxnDbUtil.cleanDb((Configuration)this.conf);
        this.ms = new HiveMetaStoreClient((Configuration)this.conf);
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
        this.tmpdir = new File(Files.createTempDirectory("compactor_test_table_", new FileAttribute[0]).toString());
    }

    protected void compactorTestCleanup() throws IOException {
        FileUtils.deleteDirectory((File)this.tmpdir);
    }

    protected void startInitiator() throws Exception {
        this.startThread('i', true);
    }

    protected void startWorker() throws Exception {
        this.startThread('w', true);
    }

    protected void startCleaner() throws Exception {
        this.startThread('c', true);
    }

    protected void startCleaner(AtomicBoolean looped) throws Exception {
        this.startThread('c', false, looped);
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned) throws TException {
        return this.newTable(dbName, tableName, partitioned, new HashMap<String, String>(), null, false);
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned, Map<String, String> parameters) throws TException {
        return this.newTable(dbName, tableName, partitioned, parameters, null, false);
    }

    protected Table newTempTable(String tableName) throws TException {
        return this.newTable("default", tableName, false, null, null, true);
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned, Map<String, String> parameters, List<Order> sortCols, boolean isTemporary) throws TException {
        Table table = new Table();
        table.setTableType(TableType.MANAGED_TABLE.name());
        table.setTableName(tableName);
        table.setDbName(dbName);
        table.setOwner("me");
        table.setSd(this.newStorageDescriptor(this.getLocation(tableName, null), sortCols));
        ArrayList<FieldSchema> partKeys = new ArrayList<FieldSchema>(1);
        if (partitioned) {
            partKeys.add(new FieldSchema("ds", "string", "no comment"));
            table.setPartitionKeys(partKeys);
        }
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("transactional", "true");
        if (sortCols != null) {
            parameters.put("transactional_properties", "insert_only");
        }
        table.setParameters(parameters);
        if (isTemporary) {
            table.setTemporary(true);
        }
        this.ms.dropTable(dbName, tableName);
        this.ms.createTable(table);
        return table;
    }

    protected Partition newPartition(Table t, String value) throws Exception {
        return this.newPartition(t, value, null);
    }

    protected Partition newPartition(Table t, String value, List<Order> sortCols) throws Exception {
        Partition part = new Partition();
        part.addToValues(value);
        part.setDbName(t.getDbName());
        part.setTableName(t.getTableName());
        part.setSd(this.newStorageDescriptor(this.getLocation(t.getTableName(), value), sortCols));
        part.setParameters(new HashMap());
        this.ms.add_partition(part);
        return part;
    }

    protected long openTxn() throws MetaException {
        List txns = this.txnHandler.openTxns(new OpenTxnRequest(1, System.getProperty("user.name"), Worker.hostname())).getTxn_ids();
        return (Long)txns.get(0);
    }

    protected long allocateWriteId(String dbName, String tblName, long txnid) throws MetaException, TxnAbortedException, NoSuchTxnException {
        AllocateTableWriteIdsRequest awiRqst = new AllocateTableWriteIdsRequest(dbName, tblName);
        awiRqst.setTxnIds(Collections.singletonList(txnid));
        AllocateTableWriteIdsResponse awiResp = this.txnHandler.allocateTableWriteIds(awiRqst);
        return ((TxnToWriteId)awiResp.getTxnToWriteIds().get(0)).getWriteId();
    }

    protected void addDeltaFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords) throws Exception {
        this.addFile(t, p, minTxn, maxTxn, numRecords, FileType.DELTA, 2, true);
    }

    protected void addLengthFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords) throws Exception {
        this.addFile(t, p, minTxn, maxTxn, numRecords, FileType.LENGTH_FILE, 2, true);
    }

    protected void addBaseFile(Table t, Partition p, long maxTxn, int numRecords) throws Exception {
        this.addFile(t, p, 0L, maxTxn, numRecords, FileType.BASE, 2, true);
    }

    protected void addLegacyFile(Table t, Partition p, int numRecords) throws Exception {
        this.addFile(t, p, 0L, 0L, numRecords, FileType.LEGACY, 2, true);
    }

    protected void addDeltaFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords, int numBuckets, boolean allBucketsPresent) throws Exception {
        this.addFile(t, p, minTxn, maxTxn, numRecords, FileType.DELTA, numBuckets, allBucketsPresent);
    }

    protected void addBaseFile(Table t, Partition p, long maxTxn, int numRecords, int numBuckets, boolean allBucketsPresent) throws Exception {
        this.addFile(t, p, 0L, maxTxn, numRecords, FileType.BASE, numBuckets, allBucketsPresent);
    }

    protected List<Path> getDirectories(HiveConf conf, Table t, Partition p) throws Exception {
        String partValue = p == null ? null : (String)p.getValues().get(0);
        String location = this.getLocation(t.getTableName(), partValue);
        Path dir = new Path(location);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stats = fs.listStatus(dir);
        ArrayList<Path> paths = new ArrayList<Path>(stats.length);
        for (int i = 0; i < stats.length; ++i) {
            paths.add(stats[i].getPath());
        }
        return paths;
    }

    protected void burnThroughTransactions(String dbName, String tblName, int num) throws MetaException, NoSuchTxnException, TxnAbortedException {
        this.burnThroughTransactions(dbName, tblName, num, null, null);
    }

    protected void burnThroughTransactions(String dbName, String tblName, int num, Set<Long> open, Set<Long> aborted) throws MetaException, NoSuchTxnException, TxnAbortedException {
        OpenTxnsResponse rsp = this.txnHandler.openTxns(new OpenTxnRequest(num, "me", "localhost"));
        AllocateTableWriteIdsRequest awiRqst = new AllocateTableWriteIdsRequest(dbName, tblName);
        awiRqst.setTxnIds(rsp.getTxn_ids());
        AllocateTableWriteIdsResponse awiResp = this.txnHandler.allocateTableWriteIds(awiRqst);
        int i = 0;
        Iterator iterator = rsp.getTxn_ids().iterator();
        while (iterator.hasNext()) {
            long tid = (Long)iterator.next();
            assert (((TxnToWriteId)awiResp.getTxnToWriteIds().get(i++)).getTxnId() == tid);
            if (aborted != null && aborted.contains(tid)) {
                this.txnHandler.abortTxn(new AbortTxnRequest(tid));
                continue;
            }
            if (open != null && (open == null || open.contains(tid))) continue;
            this.txnHandler.commitTxn(new CommitTxnRequest(tid));
        }
    }

    protected void stopThread() {
        this.stop.set(true);
    }

    private StorageDescriptor newStorageDescriptor(String location, List<Order> sortCols) {
        StorageDescriptor sd = new StorageDescriptor();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>(2);
        cols.add(new FieldSchema("a", "varchar(25)", "still no comment"));
        cols.add(new FieldSchema("b", "int", "comment"));
        sd.setCols(cols);
        sd.setLocation(location);
        sd.setInputFormat(MockInputFormat.class.getName());
        sd.setOutputFormat(MockOutputFormat.class.getName());
        sd.setNumBuckets(1);
        SerDeInfo serde = new SerDeInfo();
        serde.setSerializationLib(LazySimpleSerDe.class.getName());
        sd.setSerdeInfo(serde);
        ArrayList<String> bucketCols = new ArrayList<String>(1);
        bucketCols.add("a");
        sd.setBucketCols(bucketCols);
        if (sortCols != null) {
            sd.setSortCols(sortCols);
        }
        return sd;
    }

    private void startThread(char type, boolean stopAfterOne) throws Exception {
        this.startThread(type, stopAfterOne, new AtomicBoolean());
    }

    private void startThread(char type, boolean stopAfterOne, AtomicBoolean looped) throws Exception {
        TxnDbUtil.setConfValues((Configuration)this.conf);
        Initiator t = null;
        switch (type) {
            case 'i': {
                t = new Initiator();
                break;
            }
            case 'w': {
                t = new Worker();
                break;
            }
            case 'c': {
                t = new Cleaner();
                break;
            }
            default: {
                throw new RuntimeException("Huh? Unknown thread type.");
            }
        }
        t.setThreadId((int)t.getId());
        t.setConf((Configuration)this.conf);
        this.stop.set(stopAfterOne);
        t.init(this.stop, looped);
        if (stopAfterOne) {
            t.run();
        } else {
            t.start();
        }
    }

    private String getLocation(String tableName, String partValue) {
        String location = this.tmpdir.getAbsolutePath() + System.getProperty("file.separator") + tableName;
        if (partValue != null) {
            location = location + System.getProperty("file.separator") + "ds=" + partValue;
        }
        return location;
    }

    private void addFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords, FileType type, int numBuckets, boolean allBucketsPresent) throws Exception {
        String partValue = p == null ? null : (String)p.getValues().get(0);
        Path location = new Path(this.getLocation(t.getTableName(), partValue));
        Object filename = null;
        switch (type) {
            case BASE: {
                filename = "base_" + maxTxn;
                break;
            }
            case LENGTH_FILE: 
            case DELTA: {
                filename = this.makeDeltaDirName(minTxn, maxTxn);
                break;
            }
        }
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        for (int bucket = 0; bucket < numBuckets; ++bucket) {
            if (bucket == 0 && !allBucketsPresent) continue;
            Path partFile = null;
            if (type == FileType.LEGACY) {
                partFile = new Path(location, String.format("%06d", bucket) + "_0");
            } else {
                Path dir = new Path(location, (String)filename);
                fs.mkdirs(dir);
                partFile = AcidUtils.createBucketFile((Path)dir, (int)bucket);
                if (type == FileType.LENGTH_FILE) {
                    partFile = new Path(partFile.toString() + "_flush_length");
                }
            }
            FSDataOutputStream out = fs.create(partFile);
            if (type == FileType.LENGTH_FILE) {
                out.writeInt(numRecords);
            } else {
                for (int i = 0; i < numRecords; ++i) {
                    RecordIdentifier ri = new RecordIdentifier(maxTxn - 1L, bucket, (long)i);
                    ri.write((DataOutput)out);
                    out.writeBytes("mary had a little lamb its fleece was white as snow\n");
                }
            }
            out.close();
        }
    }

    abstract boolean useHive130DeltaDirName();

    String makeDeltaDirName(long minTxnId, long maxTxnId) {
        if (minTxnId != maxTxnId) {
            return this.makeDeltaDirNameCompacted(minTxnId, maxTxnId);
        }
        return this.useHive130DeltaDirName() ? AcidUtils.deltaSubdir((long)minTxnId, (long)maxTxnId, (int)0) : AcidUtils.deltaSubdir((long)minTxnId, (long)maxTxnId);
    }

    String makeDeltaDirNameCompacted(long minTxnId, long maxTxnId) {
        return AcidUtils.deltaSubdir((long)minTxnId, (long)maxTxnId);
    }

    String makeDeleteDeltaDirNameCompacted(long minTxnId, long maxTxnId) {
        return AcidUtils.deleteDeltaSubdir((long)minTxnId, (long)maxTxnId);
    }

    static class MockRecordWriter
    implements FileSinkOperator.RecordWriter {
        private final FSDataOutputStream os;

        MockRecordWriter(Path basedir, AcidOutputFormat.Options options) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)options.getConfiguration());
            Path p = AcidUtils.createFilename((Path)basedir, (AcidOutputFormat.Options)options);
            this.os = fs.create(p);
        }

        public void write(Writable w) throws IOException {
            Text t = (Text)w;
            this.os.writeBytes(t.toString());
            this.os.writeBytes("\n");
        }

        public void close(boolean abort) throws IOException {
            this.os.close();
        }
    }

    static class MockOutputFormat
    implements AcidOutputFormat<WritableComparable, Text> {
        MockOutputFormat() {
        }

        public RecordUpdater getRecordUpdater(Path path, AcidOutputFormat.Options options) throws IOException {
            return null;
        }

        public FileSinkOperator.RecordWriter getRawRecordWriter(Path path, AcidOutputFormat.Options options) throws IOException {
            return new MockRecordWriter(path, options);
        }

        public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
            return null;
        }

        public RecordWriter<WritableComparable, Text> getRecordWriter(FileSystem fileSystem, JobConf entries, String s, Progressable progressable) throws IOException {
            return null;
        }

        public void checkOutputSpecs(FileSystem fileSystem, JobConf entries) throws IOException {
        }
    }

    static class MockRawReader
    implements AcidInputFormat.RawReader<Text> {
        private final Stack<Path> filesToRead = new Stack();
        private final Configuration conf;
        private FSDataInputStream is = null;
        private final FileSystem fs;
        private boolean lastWasDelete = true;

        MockRawReader(Configuration conf, List<Path> files) throws IOException {
            for (Path file : files) {
                this.filesToRead.push(file);
            }
            this.conf = conf;
            this.fs = FileSystem.get((Configuration)conf);
        }

        public ObjectInspector getObjectInspector() {
            return null;
        }

        public boolean isDelete(Text value) {
            this.lastWasDelete = !this.lastWasDelete;
            return this.lastWasDelete;
        }

        public boolean next(RecordIdentifier identifier, Text text) throws IOException {
            if (this.is == null) {
                if (this.filesToRead.empty()) {
                    return false;
                }
                Path p = this.filesToRead.pop();
                LOG.debug("Reading records from " + p.toString());
                this.is = this.fs.open(p);
            }
            String line = null;
            try {
                identifier.readFields((DataInput)this.is);
                line = this.is.readLine();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            if (line == null) {
                this.is = null;
                return this.next(identifier, text);
            }
            text.set(line);
            return true;
        }

        public RecordIdentifier createKey() {
            return new RecordIdentifier();
        }

        public Text createValue() {
            return new Text();
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }
    }

    static class MockInputFormat
    implements AcidInputFormat<WritableComparable, Text> {
        MockInputFormat() {
        }

        public AcidInputFormat.RowReader<Text> getReader(InputSplit split, AcidInputFormat.Options options) throws IOException {
            return null;
        }

        public AcidInputFormat.RawReader<Text> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidWriteIdList validWriteIdList, Path baseDirectory, Path ... deltaDirectory) throws IOException {
            ArrayList<Path> filesToRead = new ArrayList<Path>();
            if (baseDirectory != null) {
                if (baseDirectory.getName().startsWith("base_")) {
                    Path p = AcidUtils.createBucketFile((Path)baseDirectory, (int)bucket);
                    FileSystem fs = p.getFileSystem(conf);
                    if (fs.exists(p)) {
                        filesToRead.add(p);
                    }
                } else {
                    filesToRead.add(new Path(baseDirectory, "000000_0"));
                }
            }
            for (int i = 0; i < deltaDirectory.length; ++i) {
                Path p = AcidUtils.createBucketFile((Path)deltaDirectory[i], (int)bucket);
                FileSystem fs = p.getFileSystem(conf);
                if (!fs.exists(p)) continue;
                filesToRead.add(p);
            }
            return new MockRawReader(conf, filesToRead);
        }

        public InputSplit[] getSplits(JobConf entries, int i) throws IOException {
            return new InputSplit[0];
        }

        public RecordReader<WritableComparable, Text> getRecordReader(InputSplit inputSplit, JobConf entries, Reporter reporter) throws IOException {
            return null;
        }

        public boolean validateInput(FileSystem fs, HiveConf conf, List<FileStatus> files) throws IOException {
            return false;
        }
    }

    private static enum FileType {
        BASE,
        DELTA,
        LEGACY,
        LENGTH_FILE;

    }
}

