/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import org.apache.hadoop.hive.ql.log.HiveEventCounter;
import org.apache.hadoop.hive.ql.metadata.StringAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLog4j2Appenders {
    @Before
    public void setup() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(Level.INFO);
        ctx.updateLoggers();
    }

    @Test
    public void testStringAppender() throws Exception {
        Logger logger = LogManager.getRootLogger();
        StringAppender appender = StringAppender.createStringAppender("%m");
        appender.addToLogger(logger.getName(), Level.INFO);
        appender.start();
        logger.info("Hello!");
        logger.info(" World");
        Assert.assertEquals((Object)"Hello! World", (Object)appender.getOutput());
        appender.removeFromLogger(LogManager.getRootLogger().getName());
    }

    @Test
    public void testHiveEventCounterAppender() throws Exception {
        Logger logger = LogManager.getRootLogger();
        HiveEventCounter appender = HiveEventCounter.createInstance((String)"EventCounter", (boolean)true, null, null);
        appender.addToLogger(logger.getName(), Level.INFO);
        appender.start();
        logger.info("Test");
        logger.info("Test");
        logger.info("Test");
        logger.info("Test");
        logger.error("Test");
        logger.error("Test");
        logger.error("Test");
        logger.warn("Test");
        logger.warn("Test");
        logger.fatal("Test");
        Assert.assertEquals((long)4L, (long)appender.getInfo());
        Assert.assertEquals((long)3L, (long)appender.getError());
        Assert.assertEquals((long)2L, (long)appender.getWarn());
        Assert.assertEquals((long)1L, (long)appender.getFatal());
        appender.removeFromLogger(LogManager.getRootLogger().getName());
    }
}

