/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import junit.framework.TestCase;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.EmbeddedLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.junit.Assert;

public class TestEmbeddedLockManager
extends TestCase {
    private int counter;
    private HiveConf conf = new HiveConf();

    public void testLocking() throws LockException {
        HiveConf conf = new HiveConf();
        conf.set("hive.lock.numretries", "0");
        conf.set("hive.unlock.numretries", "0");
        EmbeddedLockManager manager = new EmbeddedLockManager();
        manager.setContext(new HiveLockManagerCtx(conf));
        String path1 = "database1/table1/x=100";
        String path2 = "database1/table1/x=200";
        String path3 = "database1/table2";
        String path4 = "database2";
        HiveLockObject path1sel1 = this.lockObj(path1, "select");
        HiveLock path1sel1Lock = manager.lock(path1sel1, HiveLockMode.SHARED, false);
        Assert.assertNotNull((Object)path1sel1Lock);
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel1, false, false).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel1, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(false, true).size());
        HiveLockObject path1up1 = this.lockObj(path1, "update");
        Assert.assertNull((Object)manager.lock(path1up1, HiveLockMode.EXCLUSIVE, false));
        HiveLockObject path1sel2 = this.lockObj(path1, "select");
        HiveLock path1sel2Lock = manager.lock(path1sel2, HiveLockMode.SHARED, false);
        Assert.assertNotNull((Object)path1sel2Lock);
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel1, false, false).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(path1sel1, false, true).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(path1sel2, false, true).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(false, true).size());
        HiveLockObject path1up2 = this.lockObj(path1, "update");
        Assert.assertNull((Object)manager.lock(path1up2, HiveLockMode.EXCLUSIVE, false));
        HiveLockObject path2sel1 = this.lockObj(path2, "select");
        HiveLock path2sel1Lock = manager.lock(path2sel1, HiveLockMode.SHARED, false);
        Assert.assertNotNull((Object)path2sel1Lock);
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel1, false, false).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(path1sel1, false, true).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(path1sel2, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path2sel1, false, true).size());
        Assert.assertEquals((long)3L, (long)manager.getLocks(false, true).size());
        HiveLockObject path3sel = this.lockObj(path3, "select");
        HiveLock path3selLock = manager.lock(path3sel, HiveLockMode.SHARED, false);
        Assert.assertNotNull((Object)path3selLock);
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel1, false, false).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(path1sel1, false, true).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(path1sel2, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path2sel1, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path3sel, false, true).size());
        Assert.assertEquals((long)4L, (long)manager.getLocks(false, true).size());
        manager.unlock(path1sel1Lock);
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel1, false, false).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel1, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel2, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path2sel1, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path3sel, false, true).size());
        Assert.assertEquals((long)3L, (long)manager.getLocks(false, true).size());
        manager.unlock(path1sel2Lock);
        Assert.assertEquals((long)1L, (long)manager.getLocks(path2sel1, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path3sel, false, true).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(false, true).size());
        manager.unlock(path2sel1Lock);
        Assert.assertEquals((long)1L, (long)manager.getLocks(path3sel, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(false, true).size());
        manager.unlock(path3selLock);
        Assert.assertEquals((long)0L, (long)manager.getLocks(false, true).size());
        HiveLockObject path2up1 = this.lockObj(path2, "update");
        HiveLock path2up1Lock = manager.lock(path2up1, HiveLockMode.EXCLUSIVE, false);
        Assert.assertNotNull((Object)path2up1Lock);
        Assert.assertEquals((long)1L, (long)manager.getLocks(path2up1, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(false, true).size());
        Assert.assertNull((Object)manager.lock(path2up1, HiveLockMode.EXCLUSIVE, false));
        HiveLockObject path1sel3 = this.lockObj(path1, "select");
        HiveLockObject path2sel2 = this.lockObj(path2, "select");
        Assert.assertNotNull((Object)manager.lock(path1sel3, HiveLockMode.SHARED, false));
        Assert.assertNull((Object)manager.lock(path2sel2, HiveLockMode.SHARED, false));
        Assert.assertEquals((long)1L, (long)manager.getLocks(path2up1, false, true).size());
        Assert.assertEquals((long)1L, (long)manager.getLocks(path1sel3, false, true).size());
        Assert.assertEquals((long)2L, (long)manager.getLocks(false, true).size());
    }

    private HiveLockObject lockObj(String path, String query) {
        HiveLockObject.HiveLockObjectData data = new HiveLockObject.HiveLockObjectData(String.valueOf(++this.counter), null, null, query, this.conf);
        return new HiveLockObject(path.split("/"), data);
    }
}

