/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.junit.Assert;
import org.junit.Test;

public class TestRuleRegExp {
    @Test
    public void testPatternWithoutWildCardChar() {
        String patternStr = ReduceSinkOperator.getOperatorName() + "%" + SelectOperator.getOperatorName() + "%" + FileSinkOperator.getOperatorName() + "%";
        RuleRegExp rule1 = new RuleRegExp("R1", patternStr);
        Assert.assertEquals((Object)rule1.rulePatternIsValidWithoutWildCardChar(), (Object)true);
        Assert.assertEquals((Object)rule1.rulePatternIsValidWithWildCardChar(), (Object)false);
        Stack<TestNode> ns1 = new Stack<TestNode>();
        ns1.push(new TestNode(ReduceSinkOperator.getOperatorName()));
        ns1.push(new TestNode(SelectOperator.getOperatorName()));
        ns1.push(new TestNode(FileSinkOperator.getOperatorName()));
        try {
            Assert.assertEquals((long)rule1.cost(ns1), (long)patternStr.length());
        }
        catch (SemanticException e) {
            Assert.fail((String)e.getMessage());
        }
        Stack<TestNode> ns2 = new Stack<TestNode>();
        ns2.push(new TestNode(ReduceSinkOperator.getOperatorName()));
        ns1.push(new TestNode(TableScanOperator.getOperatorName()));
        ns1.push(new TestNode(FileSinkOperator.getOperatorName()));
        try {
            Assert.assertEquals((long)rule1.cost(ns2), (long)-1L);
        }
        catch (SemanticException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPatternWithWildCardChar() {
        RuleRegExp rule1 = new RuleRegExp("R1", "(" + TableScanOperator.getOperatorName() + "%" + FilterOperator.getOperatorName() + "%)|(" + TableScanOperator.getOperatorName() + "%" + FileSinkOperator.getOperatorName() + "%)");
        Assert.assertEquals((Object)rule1.rulePatternIsValidWithoutWildCardChar(), (Object)false);
        Assert.assertEquals((Object)rule1.rulePatternIsValidWithWildCardChar(), (Object)true);
        Stack<TestNode> ns1 = new Stack<TestNode>();
        ns1.push(new TestNode(TableScanOperator.getOperatorName()));
        ns1.push(new TestNode(FilterOperator.getOperatorName()));
        Stack<TestNode> ns2 = new Stack<TestNode>();
        ns2.push(new TestNode(TableScanOperator.getOperatorName()));
        ns2.push(new TestNode(FileSinkOperator.getOperatorName()));
        try {
            Assert.assertNotEquals((long)rule1.cost(ns1), (long)-1L);
            Assert.assertNotEquals((long)rule1.cost(ns2), (long)-1L);
        }
        catch (SemanticException e) {
            Assert.fail((String)e.getMessage());
        }
        Stack<TestNode> ns3 = new Stack<TestNode>();
        ns3.push(new TestNode(ReduceSinkOperator.getOperatorName()));
        ns3.push(new TestNode(ReduceSinkOperator.getOperatorName()));
        ns3.push(new TestNode(FileSinkOperator.getOperatorName()));
        try {
            Assert.assertEquals((long)rule1.cost(ns3), (long)-1L);
        }
        catch (SemanticException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public class TestNode
    implements Node {
        private String name;

        TestNode(String name) {
            this.name = name;
        }

        public List<? extends Node> getChildren() {
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

