/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde.primitive;

import org.apache.hadoop.hive.ql.io.parquet.serde.primitive.ParquetByteInspector;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestParquetByteInspector {
    private ParquetByteInspector inspector;

    @Before
    public void setUp() {
        this.inspector = new ParquetByteInspector();
    }

    @Test
    public void testByteWritable() {
        ByteWritable obj = new ByteWritable(5);
        Assert.assertEquals((Object)obj, (Object)this.inspector.getPrimitiveWritableObject((Object)obj));
        Assert.assertEquals((Object)5, (Object)this.inspector.getPrimitiveJavaObject((Object)obj));
    }

    @Test
    public void testIntWritable() {
        IntWritable obj = new IntWritable(10);
        Assert.assertEquals((Object)new ByteWritable(10), (Object)this.inspector.getPrimitiveWritableObject((Object)obj));
        Assert.assertEquals((Object)10, (Object)this.inspector.getPrimitiveJavaObject((Object)obj));
    }

    @Test
    public void testNull() {
        Assert.assertNull((Object)this.inspector.getPrimitiveWritableObject(null));
        Assert.assertNull((Object)this.inspector.getPrimitiveJavaObject(null));
    }

    @Test
    public void testCreate() {
        Assert.assertEquals((Object)new ByteWritable(8), (Object)this.inspector.create((byte)8));
    }

    @Test
    public void testSet() {
        ByteWritable obj = new ByteWritable();
        Assert.assertEquals((Object)new ByteWritable(12), (Object)this.inspector.set((Object)obj, (byte)12));
    }

    @Test
    public void testGet() {
        ByteWritable obj = new ByteWritable(15);
        Assert.assertEquals((long)15L, (long)this.inspector.get((Object)obj));
    }
}

