/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.write.ParquetRecordWriterWrapper;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMapredParquetOutputFormat {
    @Test
    public void testConstructor() {
        new MapredParquetOutputFormat();
    }

    @Test
    public void testConstructorWithFormat() {
        new MapredParquetOutputFormat((OutputFormat)((ParquetOutputFormat)Mockito.mock(ParquetOutputFormat.class)));
    }

    @Test
    public void testGetHiveRecordWriter() throws IOException {
        Properties tableProps = new Properties();
        tableProps.setProperty("columns", "foo,bar");
        tableProps.setProperty("columns.types", "int:int");
        final Progressable mockProgress = (Progressable)Mockito.mock(Progressable.class);
        final ParquetOutputFormat outputFormat = (ParquetOutputFormat)Mockito.mock(ParquetOutputFormat.class);
        JobConf jobConf = new JobConf();
        try {
            new MapredParquetOutputFormat((OutputFormat)outputFormat){

                protected ParquetRecordWriterWrapper getParquerRecordWriterWrapper(ParquetOutputFormat<ParquetHiveRecord> realOutputFormat, JobConf jobConf, String finalOutPath, Progressable progress, Properties tableProperties) throws IOException {
                    Assert.assertEquals((Object)outputFormat, realOutputFormat);
                    Assert.assertNotNull((Object)jobConf.get("parquet.hive.schema"));
                    Assert.assertEquals((Object)"/foo", (Object)finalOutPath.toString());
                    Assert.assertEquals((Object)mockProgress, (Object)progress);
                    throw new RuntimeException("passed tests");
                }
            }.getHiveRecordWriter(jobConf, new Path("/foo"), null, false, tableProps, mockProgress);
            Assert.fail((String)"should throw runtime exception.");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"passed tests", (Object)e.getMessage());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCompressionTableProperties() throws IOException {
        Properties tableProps = new Properties();
        tableProps.setProperty("parquet.compression", "unsupported");
        tableProps.setProperty("columns", "foo,bar");
        tableProps.setProperty("columns.types", "int:int");
        JobConf jobConf = new JobConf();
        new MapredParquetOutputFormat().getHiveRecordWriter(jobConf, new Path("/foo"), null, false, tableProps, null);
    }
}

