/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.io.NonSyncDataInputBuffer;
import org.apache.hadoop.hive.ql.io.NonSyncDataOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveInputOutputBuffer
extends TestCase {
    private static final int numCases = 14;
    private static final String asciiLine1 = "Foo 12345 moo";
    private static final String asciiLine2 = "Line two";
    private static final String asciiString = "Foo 12345 moo\nLine two\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadAndWrite() throws IOException {
        String testString = "test_hive_input_output_number_0";
        byte[] string_bytes = testString.getBytes();
        NonSyncDataInputBuffer inBuffer = new NonSyncDataInputBuffer();
        NonSyncDataOutputBuffer outBuffer = new NonSyncDataOutputBuffer();
        try {
            outBuffer.write(string_bytes);
            inBuffer.reset(outBuffer.getData(), 0, outBuffer.getLength());
            byte[] readBytes = new byte[string_bytes.length];
            inBuffer.read(readBytes);
            String readString = new String(readBytes);
            TestHiveInputOutputBuffer.assertEquals((String)"Field testReadAndWrite()", (String)readString, (String)testString);
        }
        finally {
            inBuffer.close();
            outBuffer.close();
        }
    }

    private static void readJunk(NonSyncDataInputBuffer in, Random r, long seed, int iter) throws IOException {
        r.setSeed(seed);
        block16: for (int i = 0; i < iter; ++i) {
            switch (r.nextInt(14)) {
                case 0: {
                    TestHiveInputOutputBuffer.assertEquals((byte)((byte)(r.nextInt() & 0xFF)), (byte)in.readByte());
                    continue block16;
                }
                case 1: {
                    TestHiveInputOutputBuffer.assertEquals((short)((short)(r.nextInt() & 0xFFFF)), (short)in.readShort());
                    continue block16;
                }
                case 2: {
                    TestHiveInputOutputBuffer.assertEquals((int)r.nextInt(), (int)in.readInt());
                    continue block16;
                }
                case 3: {
                    TestHiveInputOutputBuffer.assertEquals((long)r.nextLong(), (long)in.readLong());
                    continue block16;
                }
                case 4: {
                    TestHiveInputOutputBuffer.assertEquals((long)Double.doubleToLongBits(r.nextDouble()), (long)Double.doubleToLongBits(in.readDouble()));
                    continue block16;
                }
                case 5: {
                    TestHiveInputOutputBuffer.assertEquals((int)Float.floatToIntBits(r.nextFloat()), (int)Float.floatToIntBits(in.readFloat()));
                    continue block16;
                }
                case 6: {
                    int len = r.nextInt(1024);
                    byte[] vb = new byte[len];
                    r.nextBytes(vb);
                    byte[] b = new byte[len];
                    in.readFully(b, 0, len);
                    Assert.assertArrayEquals((byte[])vb, (byte[])b);
                    r.nextBytes(vb);
                    in.read(b, 0, len);
                    Assert.assertArrayEquals((byte[])vb, (byte[])b);
                    r.nextBytes(vb);
                    in.readFully(b);
                    Assert.assertArrayEquals((byte[])vb, (byte[])b);
                    continue block16;
                }
                case 7: {
                    TestHiveInputOutputBuffer.assertEquals((boolean)r.nextBoolean(), (boolean)in.readBoolean());
                    continue block16;
                }
                case 8: {
                    TestHiveInputOutputBuffer.assertEquals((char)((char)r.nextInt()), (char)in.readChar());
                    continue block16;
                }
                case 9: {
                    int actualUB = in.readUnsignedByte();
                    TestHiveInputOutputBuffer.assertTrue((actualUB >= 0 ? 1 : 0) != 0);
                    TestHiveInputOutputBuffer.assertTrue((actualUB <= 255 ? 1 : 0) != 0);
                    TestHiveInputOutputBuffer.assertEquals((int)(r.nextInt() & 0xFF), (int)actualUB);
                    continue block16;
                }
                case 10: {
                    int actualUS = in.readUnsignedShort();
                    TestHiveInputOutputBuffer.assertTrue((actualUS >= 0 ? 1 : 0) != 0);
                    TestHiveInputOutputBuffer.assertTrue((actualUS <= 65535 ? 1 : 0) != 0);
                    TestHiveInputOutputBuffer.assertEquals((int)(r.nextInt() & 0xFFFF), (int)actualUS);
                    continue block16;
                }
                case 11: {
                    String expectedString1 = TestHiveInputOutputBuffer.composeString(1024, r);
                    TestHiveInputOutputBuffer.assertEquals((String)expectedString1, (String)in.readUTF());
                    String expectedString2 = TestHiveInputOutputBuffer.composeString(1024, r);
                    TestHiveInputOutputBuffer.assertEquals((String)expectedString2, (String)NonSyncDataInputBuffer.readUTF((DataInput)in));
                    continue block16;
                }
                case 12: {
                    TestHiveInputOutputBuffer.assertEquals((String)asciiLine1, (String)in.readLine());
                    TestHiveInputOutputBuffer.assertEquals((String)asciiLine2, (String)in.readLine());
                    continue block16;
                }
                case 13: {
                    in.skipBytes(8);
                    r.nextLong();
                    TestHiveInputOutputBuffer.assertEquals((long)r.nextLong(), (long)in.readLong());
                }
            }
        }
    }

    private static void writeJunk(DataOutput out, Random r, long seed, int iter) throws IOException {
        r.setSeed(seed);
        block16: for (int i = 0; i < iter; ++i) {
            switch (r.nextInt(14)) {
                case 0: {
                    out.writeByte(r.nextInt());
                    continue block16;
                }
                case 1: {
                    out.writeShort((short)(r.nextInt() & 0xFFFF));
                    continue block16;
                }
                case 2: {
                    out.writeInt(r.nextInt());
                    continue block16;
                }
                case 3: {
                    out.writeLong(r.nextLong());
                    continue block16;
                }
                case 4: {
                    out.writeDouble(r.nextDouble());
                    continue block16;
                }
                case 5: {
                    out.writeFloat(r.nextFloat());
                    continue block16;
                }
                case 6: {
                    byte[] b = new byte[r.nextInt(1024)];
                    r.nextBytes(b);
                    out.write(b);
                    r.nextBytes(b);
                    out.write(b);
                    r.nextBytes(b);
                    out.write(b);
                    continue block16;
                }
                case 7: {
                    out.writeBoolean(r.nextBoolean());
                    continue block16;
                }
                case 8: {
                    out.writeChar((char)r.nextInt());
                    continue block16;
                }
                case 9: {
                    out.writeByte((byte)r.nextInt());
                    continue block16;
                }
                case 10: {
                    out.writeShort((short)r.nextInt());
                    continue block16;
                }
                case 11: {
                    String string = TestHiveInputOutputBuffer.composeString(1024, r);
                    out.writeUTF(string);
                    String string2 = TestHiveInputOutputBuffer.composeString(1024, r);
                    out.writeUTF(string2);
                    continue block16;
                }
                case 12: {
                    byte[] bb = asciiString.getBytes("UTF-8");
                    out.write(bb);
                    continue block16;
                }
                case 13: {
                    out.writeLong(r.nextLong());
                    out.writeLong(r.nextLong());
                }
            }
        }
    }

    private static String composeString(int len, Random r) {
        char[] cc = new char[len];
        for (int i = 0; i < len; ++i) {
            char ch;
            while (!Character.isDefined(ch = (char)r.nextInt()) || Character.isHighSurrogate(ch) || Character.isLowSurrogate(ch)) {
            }
            cc[i] = ch;
        }
        return new String(cc);
    }

    @Test
    public void testBaseBuffers() throws IOException {
        NonSyncDataOutputBuffer dob = new NonSyncDataOutputBuffer();
        Random r = new Random();
        long seed = 81985529216486895L;
        r.setSeed(81985529216486895L);
        System.out.println("SEED: 81985529216486895");
        TestHiveInputOutputBuffer.writeJunk((DataOutput)dob, r, 81985529216486895L, 1000);
        NonSyncDataInputBuffer dib = new NonSyncDataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        TestHiveInputOutputBuffer.assertEquals((int)0, (int)dib.getPosition());
        TestHiveInputOutputBuffer.assertEquals((int)dob.getLength(), (int)dib.getLength());
        TestHiveInputOutputBuffer.readJunk(dib, r, 81985529216486895L, 1000);
        dob.reset();
        TestHiveInputOutputBuffer.writeJunk((DataOutput)dob, r, 81985529216486895L, 1000);
        dib.reset(dob.getData(), dob.getLength());
        TestHiveInputOutputBuffer.assertEquals((int)0, (int)dib.getPosition());
        TestHiveInputOutputBuffer.assertEquals((int)dob.getLength(), (int)dib.getLength());
        TestHiveInputOutputBuffer.readJunk(dib, r, 81985529216486895L, 1000);
    }
}

