/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.index.MockHiveInputSplits;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestHiveInputSplitComparator {
    @Parameterized.Parameter(value=0)
    public HiveInputFormat.HiveInputSplit split1;
    @Parameterized.Parameter(value=1)
    public HiveInputFormat.HiveInputSplit split2;
    @Parameterized.Parameter(value=2)
    public Integer expected;

    @Parameterized.Parameters(name="{index}: {0}<=>{1} ")
    public static Iterable<Object[]> data() {
        return Arrays.asList({MockHiveInputSplits.createMockSplit("A", 0L, 100L), MockHiveInputSplits.createMockSplit("A", 1000L, 100L), -1}, {MockHiveInputSplits.createMockSplit("A", 1000L, 100L), MockHiveInputSplits.createMockSplit("A", 100L, 100L), 1}, {MockHiveInputSplits.createMockSplit("A", 0L, 100L), MockHiveInputSplits.createMockSplit("A", 0L, 100L), 0}, {MockHiveInputSplits.createMockSplit("A", 0L, 100L), MockHiveInputSplits.createMockSplit("B", 0L, 100L), -1}, {MockHiveInputSplits.createMockSplit("A", 100L, 100L), MockHiveInputSplits.createMockSplit("B", 0L, 100L), -1}, {MockHiveInputSplits.createMockSplit("A", 100L, 100L), MockHiveInputSplits.createMockSplit("B", 0L, 100L), -1});
    }

    @Test
    public void testCompare() {
        HiveInputFormat.HiveInputSplitComparator cmp = new HiveInputFormat.HiveInputSplitComparator();
        int actual = cmp.compare(this.split1, this.split2);
        this.assertCompareResult(this.expected, actual);
    }

    private void assertCompareResult(int expected, int actual) {
        Assert.assertEquals((long)expected, (long)((int)Math.signum(actual)));
    }
}

