/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnOutputMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSourceMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOuterFilteredOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestData;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestDescription;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinCommonOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VerifyFastRow;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.ReflectionUtil;

public class MapJoinTestConfig {
    public static MapJoinDesc createMapJoinDesc(MapJoinTestDescription testDesc) {
        int joinDescType;
        MapJoinDesc mapJoinDesc = new MapJoinDesc();
        mapJoinDesc.setPosBigTable(0);
        ArrayList<ExprNodeColumnDesc> keyExpr = new ArrayList<ExprNodeColumnDesc>();
        for (int i = 0; i < testDesc.bigTableKeyColumnNums.length; ++i) {
            keyExpr.add(new ExprNodeColumnDesc(testDesc.bigTableKeyTypeInfos[i], testDesc.bigTableKeyColumnNames[i], "B", false));
        }
        HashMap keyMap = new HashMap();
        keyMap.put((byte)0, keyExpr);
        ArrayList<ExprNodeColumnDesc> smallTableExpr = new ArrayList<ExprNodeColumnDesc>();
        for (int i = 0; i < testDesc.smallTableValueColumnNames.length; ++i) {
            smallTableExpr.add(new ExprNodeColumnDesc(testDesc.smallTableValueTypeInfos[i], testDesc.smallTableValueColumnNames[i], "S", false));
        }
        keyMap.put((byte)1, smallTableExpr);
        mapJoinDesc.setKeys(keyMap);
        mapJoinDesc.setExprs(keyMap);
        Byte[] order = new Byte[]{(byte)0, (byte)1};
        mapJoinDesc.setTagOrder(order);
        mapJoinDesc.setNoOuterJoin(testDesc.vectorMapJoinVariation != VectorMapJoinDesc.VectorMapJoinVariation.OUTER);
        HashMap filterMap = new HashMap();
        filterMap.put((byte)0, new ArrayList());
        mapJoinDesc.setFilters(filterMap);
        List<Integer> bigTableRetainColumnNumsList = MapJoinTestConfig.intArrayToList(testDesc.bigTableRetainColumnNums);
        List<Integer> smallTableRetainColumnNumsList = MapJoinTestConfig.intArrayToList(testDesc.smallTableRetainValueColumnNums);
        HashMap<Byte, List<Integer>> retainListMap = new HashMap<Byte, List<Integer>>();
        retainListMap.put((byte)0, bigTableRetainColumnNumsList);
        retainListMap.put((byte)1, smallTableRetainColumnNumsList);
        mapJoinDesc.setRetainList(retainListMap);
        switch (testDesc.vectorMapJoinVariation) {
            case INNER: 
            case INNER_BIG_ONLY: {
                joinDescType = 0;
                break;
            }
            case LEFT_SEMI: {
                joinDescType = 5;
                break;
            }
            case OUTER: {
                joinDescType = 1;
                break;
            }
            default: {
                throw new RuntimeException("unknown operator variation " + testDesc.vectorMapJoinVariation);
            }
        }
        JoinCondDesc[] conds = new JoinCondDesc[]{new JoinCondDesc(0, 1, joinDescType)};
        mapJoinDesc.setConds(conds);
        TableDesc keyTableDesc = PlanUtils.getMapJoinKeyTableDesc((Configuration)testDesc.hiveConf, (List)PlanUtils.getFieldSchemasFromColumnList(keyExpr, (String)""));
        mapJoinDesc.setKeyTblDesc(keyTableDesc);
        TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc((List)PlanUtils.getFieldSchemasFromColumnList(smallTableExpr, (String)""));
        ArrayList<TableDesc> valueTableDescsList = new ArrayList<TableDesc>();
        valueTableDescsList.add(null);
        valueTableDescsList.add(valueTableDesc);
        mapJoinDesc.setValueTblDescs(valueTableDescsList);
        mapJoinDesc.setValueFilteredTblDescs(valueTableDescsList);
        mapJoinDesc.setOutputColumnNames(Arrays.asList(testDesc.outputColumnNames));
        return mapJoinDesc;
    }

    public static VectorMapJoinDesc createVectorMapJoinDesc(MapJoinTestDescription testDesc) {
        VectorMapJoinDesc.HashTableKind hashTableKind;
        VectorMapJoinDesc vectorDesc = new VectorMapJoinDesc();
        vectorDesc.setHashTableImplementationType(VectorMapJoinDesc.HashTableImplementationType.FAST);
        switch (testDesc.vectorMapJoinVariation) {
            case INNER: {
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                break;
            }
            case INNER_BIG_ONLY: {
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MULTISET;
                break;
            }
            case LEFT_SEMI: {
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_SET;
                break;
            }
            case OUTER: {
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                break;
            }
            default: {
                throw new RuntimeException("unknown operator variation " + testDesc.vectorMapJoinVariation);
            }
        }
        vectorDesc.setHashTableKind(hashTableKind);
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.MULTI_KEY;
        if (testDesc.bigTableKeyTypeInfos.length == 1) {
            switch (((PrimitiveTypeInfo)testDesc.bigTableKeyTypeInfos[0]).getPrimitiveCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.LONG;
                    break;
                }
                case STRING: {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.STRING;
                    break;
                }
            }
        }
        vectorDesc.setHashTableKeyType(hashTableKeyType);
        vectorDesc.setVectorMapJoinVariation(testDesc.vectorMapJoinVariation);
        vectorDesc.setMinMaxEnabled(false);
        VectorMapJoinInfo vectorMapJoinInfo = new VectorMapJoinInfo();
        vectorMapJoinInfo.setBigTableKeyColumnMap(testDesc.bigTableKeyColumnNums);
        vectorMapJoinInfo.setBigTableKeyColumnNames(testDesc.bigTableKeyColumnNames);
        vectorMapJoinInfo.setBigTableKeyTypeInfos(testDesc.bigTableKeyTypeInfos);
        vectorMapJoinInfo.setSlimmedBigTableKeyExpressions(null);
        vectorDesc.setAllBigTableKeyExpressions(null);
        vectorMapJoinInfo.setBigTableValueColumnMap(new int[0]);
        vectorMapJoinInfo.setBigTableValueColumnNames(new String[0]);
        vectorMapJoinInfo.setBigTableValueTypeInfos(new TypeInfo[0]);
        vectorMapJoinInfo.setSlimmedBigTableValueExpressions(null);
        vectorDesc.setAllBigTableValueExpressions(null);
        VectorColumnSourceMapping projectionMapping = new VectorColumnSourceMapping("Projection Mapping");
        VectorColumnOutputMapping bigTableRetainedMapping = new VectorColumnOutputMapping("Big Table Retained Mapping");
        for (int i = 0; i < testDesc.bigTableTypeInfos.length; ++i) {
            bigTableRetainedMapping.add(i, i, testDesc.bigTableTypeInfos[i]);
            projectionMapping.add(i, i, testDesc.bigTableKeyTypeInfos[i]);
        }
        VectorColumnOutputMapping bigTableOuterKeyMapping = new VectorColumnOutputMapping("Big Table Outer Key Mapping");
        VectorColumnSourceMapping smallTableMapping = new VectorColumnSourceMapping("Small Table Mapping");
        int outputColumn = testDesc.bigTableTypeInfos.length;
        for (int i = 0; i < testDesc.smallTableValueTypeInfos.length; ++i) {
            smallTableMapping.add(i, outputColumn, testDesc.smallTableValueTypeInfos[i]);
            projectionMapping.add(outputColumn, outputColumn, testDesc.smallTableValueTypeInfos[i]);
            ++outputColumn;
        }
        bigTableRetainedMapping.finalize();
        bigTableOuterKeyMapping.finalize();
        smallTableMapping.finalize();
        vectorMapJoinInfo.setBigTableRetainedMapping(bigTableRetainedMapping);
        vectorMapJoinInfo.setBigTableOuterKeyMapping(bigTableOuterKeyMapping);
        vectorMapJoinInfo.setSmallTableMapping(smallTableMapping);
        projectionMapping.finalize();
        assert (projectionMapping.isSourceSequenceGood());
        vectorMapJoinInfo.setProjectionMapping(projectionMapping);
        assert (projectionMapping.getCount() == testDesc.outputColumnNames.length);
        vectorDesc.setVectorMapJoinInfo(vectorMapJoinInfo);
        return vectorDesc;
    }

    public static VectorMapJoinCommonOperator createNativeVectorMapJoinOperator(VectorMapJoinDesc.VectorMapJoinVariation VectorMapJoinVariation2, MapJoinDesc mapJoinDesc, VectorMapJoinDesc vectorDesc, VectorizationContext vContext) throws HiveException {
        VectorMapJoinInnerLongOperator operator;
        block0 : switch (vectorDesc.getHashTableKeyType()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                switch (VectorMapJoinVariation2) {
                    case INNER: {
                        operator = new VectorMapJoinInnerLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case INNER_BIG_ONLY: {
                        operator = new VectorMapJoinInnerBigOnlyLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case LEFT_SEMI: {
                        operator = new VectorMapJoinLeftSemiLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case OUTER: {
                        operator = new VectorMapJoinOuterLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                }
                throw new RuntimeException("unknown operator variation " + VectorMapJoinVariation2);
            }
            case STRING: {
                switch (VectorMapJoinVariation2) {
                    case INNER: {
                        operator = new VectorMapJoinInnerStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case INNER_BIG_ONLY: {
                        operator = new VectorMapJoinInnerBigOnlyStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case LEFT_SEMI: {
                        operator = new VectorMapJoinLeftSemiStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case OUTER: {
                        operator = new VectorMapJoinOuterStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                }
                throw new RuntimeException("unknown operator variation " + VectorMapJoinVariation2);
            }
            case MULTI_KEY: {
                switch (VectorMapJoinVariation2) {
                    case INNER: {
                        operator = new VectorMapJoinInnerMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case INNER_BIG_ONLY: {
                        operator = new VectorMapJoinInnerBigOnlyMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case LEFT_SEMI: {
                        operator = new VectorMapJoinLeftSemiMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case OUTER: {
                        operator = new VectorMapJoinOuterMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                }
                throw new RuntimeException("unknown operator variation " + VectorMapJoinVariation2);
            }
            default: {
                throw new RuntimeException("Unknown hash table key type " + vectorDesc.getHashTableKeyType());
            }
        }
        return operator;
    }

    public static VectorizationContext createVectorizationContext(MapJoinTestDescription testDesc) throws HiveException {
        VectorizationContext vContext = new VectorizationContext("test", testDesc.bigTableColumnNamesList);
        for (int i = 0; i < testDesc.smallTableValueTypeInfos.length; ++i) {
            vContext.allocateScratchColumn(testDesc.smallTableValueTypeInfos[i]);
        }
        return vContext;
    }

    private static boolean hasFilter(MapJoinDesc mapJoinDesc, int alias) {
        int[][] filterMaps = mapJoinDesc.getFilterMap();
        return filterMaps != null && filterMaps[alias] != null;
    }

    public static MapJoinTableContainerSerDe createMapJoinTableContainerSerDe(MapJoinDesc mapJoinDesc) throws SerDeException {
        Byte smallTablePos = 1;
        TableDesc keyTableDesc = mapJoinDesc.getKeyTblDesc();
        AbstractSerDe keySerializer = (AbstractSerDe)ReflectionUtil.newInstance(BinarySortableSerDe.class, null);
        SerDeUtils.initializeSerDe((Deserializer)keySerializer, null, (Properties)keyTableDesc.getProperties(), null);
        MapJoinObjectSerDeContext keyContext = new MapJoinObjectSerDeContext(keySerializer, false);
        TableDesc valueTableDesc = mapJoinDesc.getNoOuterJoin() ? (TableDesc)mapJoinDesc.getValueTblDescs().get(smallTablePos.byteValue()) : (TableDesc)mapJoinDesc.getValueFilteredTblDescs().get(smallTablePos.byteValue());
        AbstractSerDe valueSerDe = (AbstractSerDe)ReflectionUtil.newInstance((Class)valueTableDesc.getDeserializerClass(), null);
        SerDeUtils.initializeSerDe((Deserializer)valueSerDe, null, (Properties)valueTableDesc.getProperties(), null);
        MapJoinObjectSerDeContext valueContext = new MapJoinObjectSerDeContext(valueSerDe, MapJoinTestConfig.hasFilter(mapJoinDesc, smallTablePos.byteValue()));
        MapJoinTableContainerSerDe mapJoinTableContainerSerDe = new MapJoinTableContainerSerDe(keyContext, valueContext);
        return mapJoinTableContainerSerDe;
    }

    public static void connectOperators(MapJoinTestDescription testDesc, Operator<? extends OperatorDesc> operator, Operator<? extends OperatorDesc> testCollectorOperator) throws HiveException {
        Operator[] parents = new Operator[]{operator};
        testCollectorOperator.setParentOperators(Arrays.asList(parents));
        Operator[] childOperators = new Operator[]{testCollectorOperator};
        operator.setChildOperators(Arrays.asList(childOperators));
        HiveConf.setBoolVar((Configuration)testDesc.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAPJOIN_TESTING_NO_HASH_TABLE_LOAD, (boolean)true);
        operator.initialize((Configuration)testDesc.hiveConf, testDesc.inputObjectInspectors);
    }

    private static List<Integer> intArrayToList(int[] intArray) {
        ArrayList<Integer> intList = new ArrayList<Integer>(intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            intList.add(intArray[i]);
        }
        return intList;
    }

    private static void loadTableContainerData(MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinTableContainer mapJoinTableContainer) throws IOException, SerDeException, HiveException {
        LazyBinarySerializeWrite valueSerializeWrite = null;
        ByteStream.Output valueOutput = null;
        if (testData.smallTableValues != null) {
            valueSerializeWrite = new LazyBinarySerializeWrite(testDesc.smallTableValueTypeInfos.length);
            valueOutput = new ByteStream.Output();
        }
        BytesWritable valueBytesWritable = new BytesWritable();
        BytesWritable keyBytesWritable = new BytesWritable();
        BinarySortableSerializeWrite keySerializeWrite = new BinarySortableSerializeWrite(testDesc.bigTableKeyTypeInfos.length);
        ByteStream.Output keyOutput = new ByteStream.Output();
        int round = 0;
        boolean atLeastOneValueAdded = false;
        while (true) {
            for (Map.Entry<RowTestObjects, Integer> testRowEntry : testData.smallTableKeyHashMap.entrySet()) {
                int smallTableKeyIndex = testRowEntry.getValue();
                int valueCount = testData.smallTableValueCounts.get(smallTableKeyIndex);
                boolean addEntry = round + 1 <= valueCount;
                if (!addEntry) continue;
                atLeastOneValueAdded = true;
                RowTestObjects valueRow = null;
                if (testData.smallTableValues != null) {
                    ArrayList<RowTestObjects> valueList = testData.smallTableValues.get(smallTableKeyIndex);
                    valueRow = valueList.get(round);
                }
                Object[] smallTableKey = testRowEntry.getKey().getRow();
                keyOutput.reset();
                keySerializeWrite.set(keyOutput);
                for (int index = 0; index < testDesc.bigTableKeyTypeInfos.length; ++index) {
                    Writable keyWritable = (Writable)smallTableKey[index];
                    VerifyFastRow.serializeWrite((SerializeWrite)keySerializeWrite, (TypeInfo)((PrimitiveTypeInfo)testDesc.bigTableKeyTypeInfos[index]), keyWritable);
                }
                keyBytesWritable.set(keyOutput.getData(), 0, keyOutput.getLength());
                if (valueRow == null) {
                    mapJoinTableContainer.putRow((Writable)keyBytesWritable, (Writable)valueBytesWritable);
                    continue;
                }
                Object[] smallTableValue = valueRow.getRow();
                valueOutput.reset();
                valueSerializeWrite.set(valueOutput);
                for (int index = 0; index < testDesc.smallTableValueTypeInfos.length; ++index) {
                    Writable valueWritable = (Writable)smallTableValue[index];
                    VerifyFastRow.serializeWrite((SerializeWrite)valueSerializeWrite, (TypeInfo)((PrimitiveTypeInfo)testDesc.smallTableValueTypeInfos[index]), valueWritable);
                }
                valueBytesWritable.set(valueOutput.getData(), 0, valueOutput.getLength());
                mapJoinTableContainer.putRow((Writable)keyBytesWritable, (Writable)valueBytesWritable);
            }
            if (testData.smallTableValues == null || !atLeastOneValueAdded) break;
            ++round;
            atLeastOneValueAdded = false;
        }
        mapJoinTableContainer.seal();
    }

    public static MapJoinOperator createMapJoin(MapJoinTestDescription testDesc, Operator<? extends OperatorDesc> collectorOperator, MapJoinTestData testData, MapJoinDesc mapJoinDesc, boolean isVectorMapJoin, boolean isOriginalMapJoin) throws SerDeException, IOException, HiveException {
        Object operator;
        Byte bigTablePos = 0;
        MapJoinTableContainerSerDe mapJoinTableContainerSerDe = MapJoinTestConfig.createMapJoinTableContainerSerDe(mapJoinDesc);
        MapJoinObjectSerDeContext valCtx = mapJoinTableContainerSerDe.getValueContext();
        HashMapWrapper mapJoinTableContainer = isOriginalMapJoin ? new HashMapWrapper((Configuration)testDesc.hiveConf, -1L) : new MapJoinBytesTableContainer((Configuration)testDesc.hiveConf, valCtx, (long)testData.smallTableKeyHashMap.size(), 0L);
        mapJoinTableContainer.setSerde(mapJoinTableContainerSerDe.getKeyContext(), mapJoinTableContainerSerDe.getValueContext());
        MapJoinTestConfig.loadTableContainerData(testDesc, testData, (MapJoinTableContainer)mapJoinTableContainer);
        if (!isVectorMapJoin) {
            operator = new MapJoinOperator(new CompilationOpContext());
            operator.setConf((OperatorDesc)mapJoinDesc);
        } else {
            VectorizationContext vContext = new VectorizationContext("test", testDesc.bigTableColumnNamesList);
            for (int i = 0; i < testDesc.smallTableValueTypeInfos.length; ++i) {
                vContext.allocateScratchColumn(testDesc.smallTableValueTypeInfos[i]);
            }
            VectorMapJoinDesc vectorMapJoinDesc = new VectorMapJoinDesc();
            byte posBigTable = (byte)mapJoinDesc.getPosBigTable();
            VectorExpression[] allBigTableKeyExpressions = vContext.getVectorExpressions((List)mapJoinDesc.getKeys().get(posBigTable));
            vectorMapJoinDesc.setAllBigTableKeyExpressions(allBigTableKeyExpressions);
            Map exprs = mapJoinDesc.getExprs();
            VectorExpression[] allBigTableValueExpressions = vContext.getVectorExpressions((List)exprs.get(posBigTable));
            vectorMapJoinDesc.setAllBigTableValueExpressions(allBigTableValueExpressions);
            List bigTableFilters = (List)mapJoinDesc.getFilters().get(bigTablePos);
            boolean isOuterAndFiltered = !mapJoinDesc.isNoOuterJoin() && bigTableFilters.size() > 0;
            operator = !isOuterAndFiltered ? new VectorMapJoinOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorMapJoinDesc) : new VectorMapJoinOuterFilteredOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorMapJoinDesc);
        }
        MapJoinTestConfig.connectOperators(testDesc, (Operator<? extends OperatorDesc>)operator, collectorOperator);
        operator.setTestMapJoinTableContainer(1, (MapJoinTableContainer)mapJoinTableContainer, mapJoinTableContainerSerDe);
        return operator;
    }

    public static MapJoinOperator createNativeVectorMapJoin(MapJoinTestDescription testDesc, Operator<? extends OperatorDesc> collectorOperator, MapJoinTestData testData, MapJoinDesc mapJoinDesc, VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType) throws SerDeException, IOException, HiveException {
        VectorMapJoinFastTableContainer mapJoinTableContainer;
        VectorMapJoinDesc vectorDesc = MapJoinTestConfig.createVectorMapJoinDesc(testDesc);
        mapJoinDesc.setVectorDesc((VectorDesc)vectorDesc);
        vectorDesc.setHashTableImplementationType(hashTableImplementationType);
        VectorMapJoinInfo vectorMapJoinInfo = vectorDesc.getVectorMapJoinInfo();
        switch (vectorDesc.getHashTableImplementationType()) {
            case OPTIMIZED: {
                mapJoinTableContainer = new MapJoinBytesTableContainer((Configuration)testDesc.hiveConf, null, (long)testData.smallTableKeyHashMap.size(), 0L);
                MapJoinTableContainerSerDe mapJoinTableContainerSerDe = MapJoinTestConfig.createMapJoinTableContainerSerDe(mapJoinDesc);
                mapJoinTableContainer.setSerde(mapJoinTableContainerSerDe.getKeyContext(), mapJoinTableContainerSerDe.getValueContext());
                break;
            }
            case FAST: {
                mapJoinTableContainer = new VectorMapJoinFastTableContainer(mapJoinDesc, (Configuration)testDesc.hiveConf, (long)testData.smallTableKeyHashMap.size());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected hash table implementation type " + vectorDesc.getHashTableImplementationType());
            }
        }
        MapJoinTestConfig.loadTableContainerData(testDesc, testData, (MapJoinTableContainer)mapJoinTableContainer);
        VectorizationContext vContext = MapJoinTestConfig.createVectorizationContext(testDesc);
        byte posBigTable = (byte)mapJoinDesc.getPosBigTable();
        VectorExpression[] slimmedBigTableKeyExpressions = vContext.getVectorExpressions((List)mapJoinDesc.getKeys().get(posBigTable));
        vectorMapJoinInfo.setSlimmedBigTableKeyExpressions(slimmedBigTableKeyExpressions);
        Map exprs = mapJoinDesc.getExprs();
        VectorExpression[] slimmedBigTableValueExpressions = vContext.getVectorExpressions((List)exprs.get(posBigTable));
        vectorMapJoinInfo.setSlimmedBigTableValueExpressions(slimmedBigTableValueExpressions);
        VectorMapJoinCommonOperator operator = MapJoinTestConfig.createNativeVectorMapJoinOperator(testDesc.vectorMapJoinVariation, mapJoinDesc, vectorDesc, vContext);
        MapJoinTestConfig.connectOperators(testDesc, (Operator<? extends OperatorDesc>)operator, collectorOperator);
        operator.setTestMapJoinTableContainer(1, (MapJoinTableContainer)mapJoinTableContainer, null);
        return operator;
    }

    public static MapJoinOperator createMapJoinImplementation(MapJoinTestImplementation mapJoinImplementation, MapJoinTestDescription testDesc, Operator<? extends OperatorDesc> testCollectorOperator, MapJoinTestData testData, MapJoinDesc mapJoinDesc) throws SerDeException, IOException, HiveException {
        MapJoinOperator operator;
        switch (mapJoinImplementation) {
            case ROW_MODE_HASH_MAP: {
                operator = MapJoinTestConfig.createMapJoin(testDesc, testCollectorOperator, testData, mapJoinDesc, false, true);
                break;
            }
            case ROW_MODE_OPTIMIZED: {
                operator = MapJoinTestConfig.createMapJoin(testDesc, testCollectorOperator, testData, mapJoinDesc, false, false);
                break;
            }
            case VECTOR_PASS_THROUGH: {
                operator = MapJoinTestConfig.createMapJoin(testDesc, testCollectorOperator, testData, mapJoinDesc, true, false);
                break;
            }
            case NATIVE_VECTOR_OPTIMIZED: {
                operator = MapJoinTestConfig.createNativeVectorMapJoin(testDesc, testCollectorOperator, testData, mapJoinDesc, VectorMapJoinDesc.HashTableImplementationType.OPTIMIZED);
                break;
            }
            case NATIVE_VECTOR_FAST: {
                operator = MapJoinTestConfig.createNativeVectorMapJoin(testDesc, testCollectorOperator, testData, mapJoinDesc, VectorMapJoinDesc.HashTableImplementationType.FAST);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected MapJoin Operator Implementation " + mapJoinImplementation);
            }
        }
        return operator;
    }

    public static enum MapJoinTestImplementation {
        ROW_MODE_HASH_MAP,
        ROW_MODE_OPTIMIZED,
        VECTOR_PASS_THROUGH,
        NATIVE_VECTOR_OPTIMIZED,
        NATIVE_VECTOR_FAST;

    }
}

