/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDayOfWeek;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class TestVectorTimestampExtract {
    @Test
    public void testTimestamp() throws Exception {
        Random random = new Random(7436L);
        this.doTimestampExtractTests(random, "timestamp");
    }

    @Test
    public void testDate() throws Exception {
        Random random = new Random(83992L);
        this.doTimestampExtractTests(random, "date");
    }

    @Test
    public void testString() throws Exception {
        Random random = new Random(378L);
        this.doTimestampExtractTests(random, "string");
    }

    private void doTimestampExtractTests(Random random, String typeName) throws Exception {
        this.doIfTestOneTimestampExtract(random, typeName, "day");
        this.doIfTestOneTimestampExtract(random, typeName, "dayofweek");
        this.doIfTestOneTimestampExtract(random, typeName, "hour");
        this.doIfTestOneTimestampExtract(random, typeName, "minute");
        this.doIfTestOneTimestampExtract(random, typeName, "month");
        this.doIfTestOneTimestampExtract(random, typeName, "second");
        this.doIfTestOneTimestampExtract(random, typeName, "yearweek");
        this.doIfTestOneTimestampExtract(random, typeName, "year");
    }

    private void doIfTestOneTimestampExtract(Random random, String dateTimeStringTypeName, String extractFunctionName) throws Exception {
        int i;
        UDFDayOfMonth udf;
        TypeInfo dateTimeStringTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)dateTimeStringTypeName);
        PrimitiveObjectInspector.PrimitiveCategory dateTimeStringPrimitiveCategory = ((PrimitiveTypeInfo)dateTimeStringTypeInfo).getPrimitiveCategory();
        boolean isStringFamily = dateTimeStringPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.STRING || dateTimeStringPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.CHAR || dateTimeStringPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR;
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 0;
        if (!isStringFamily) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(dateTimeStringTypeInfo));
        } else {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createStringFamilyOtherTypeValue(dateTimeStringTypeInfo, (TypeInfo)TypeInfoFactory.timestampTypeInfo));
        }
        explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        String columnName = "col" + columnNum++;
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(dateTimeStringTypeInfo, columnName, "table", false);
        columns.add(columnName);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, explicitDataTypePhysicalVariationList);
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        String[] columnNames = columns.toArray(new String[0]);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        if (dateTimeStringPrimitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.DATE && (extractFunctionName.equals("hour") || extractFunctionName.equals("minute") || extractFunctionName.equals("second"))) {
            return;
        }
        switch (extractFunctionName) {
            case "day": {
                udf = new UDFDayOfMonth();
                break;
            }
            case "dayofweek": {
                GenericUDFBridge dayOfWeekUDFBridge = new GenericUDFBridge();
                dayOfWeekUDFBridge.setUdfClassName(UDFDayOfWeek.class.getName());
                udf = dayOfWeekUDFBridge;
                break;
            }
            case "hour": {
                udf = new UDFHour();
                break;
            }
            case "minute": {
                udf = new UDFMinute();
                break;
            }
            case "month": {
                udf = new UDFMonth();
                break;
            }
            case "second": {
                udf = new UDFSecond();
                break;
            }
            case "yearweek": {
                GenericUDFBridge weekOfYearUDFBridge = new GenericUDFBridge();
                weekOfYearUDFBridge.setUdfClassName(UDFWeekOfYear.class.getName());
                udf = weekOfYearUDFBridge;
                break;
            }
            case "year": {
                udf = new UDFYear();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected extract function name " + extractFunctionName);
            }
        }
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)udf, children);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[TimestampExtractTestMode.count][];
        block24: for (i = 0; i < TimestampExtractTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            TimestampExtractTestMode timestampExtractTestMode = TimestampExtractTestMode.values()[i];
            switch (timestampExtractTestMode) {
                case ROW_MODE: {
                    if (this.doRowCastTest(dateTimeStringTypeInfo, columns, children, exprDesc, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), resultObjects)) continue block24;
                    return;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    if (this.doVectorCastTest(dateTimeStringTypeInfo, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, exprDesc, timestampExtractTestMode, batchSource, resultObjects)) continue block24;
                    return;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + timestampExtractTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < TimestampExtractTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " dateTimeStringTypeName " + dateTimeStringTypeName + " extractFunctionName " + extractFunctionName + " " + TimestampExtractTestMode.values()[v] + " result is NULL " + (String)(vectorResult == null ? "YES" : "NO result " + vectorResult.toString()) + " does not match row-mode expected result is NULL " + (String)(expectedResult == null ? "YES" : "NO result " + expectedResult.toString()) + " row values " + Arrays.toString(randomRows[i])));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " dateTimeStringTypeName " + dateTimeStringTypeName + " extractFunctionName " + extractFunctionName + " " + TimestampExtractTestMode.values()[v] + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i])));
            }
        }
    }

    private boolean doRowCastTest(TypeInfo dateTimeStringTypeInfo, List<String> columns, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, ObjectInspector rowInspector, Object[] resultObjects) throws Exception {
        System.out.println("*DEBUG* dateTimeStringTypeInfo " + dateTimeStringTypeInfo.toString() + " timestampExtractTestMode ROW_MODE exprDesc " + exprDesc.toString());
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        try {
            evaluator.initialize(rowInspector);
        }
        catch (HiveException e) {
            return false;
        }
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        PrimitiveObjectInspector.PrimitiveCategory dateTimeStringPrimitiveCategory = ((PrimitiveTypeInfo)dateTimeStringTypeInfo).getPrimitiveCategory();
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result;
            Object object = row[0];
            switch (dateTimeStringPrimitiveCategory) {
                case TIMESTAMP: {
                    result = evaluator.evaluate((Object)((TimestampWritableV2)object));
                    break;
                }
                case DATE: {
                    result = evaluator.evaluate((Object)((DateWritableV2)object));
                    break;
                }
                case STRING: {
                    Text text;
                    if (object == null) {
                        text = null;
                    } else if (object instanceof String) {
                        text = new Text();
                        text.set((String)object);
                    } else {
                        text = (Text)object;
                    }
                    result = evaluator.evaluate(text);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected date timestamp string primitive category " + dateTimeStringPrimitiveCategory);
                }
            }
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        return true;
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, TypeInfo targetTypeInfo, Object[] resultObjects) {
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)targetTypeInfo);
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private boolean doVectorCastTest(TypeInfo dateTimeStringTypeInfo, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, TimestampExtractTestMode timestampExtractTestMode, VectorRandomBatchSource batchSource, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        if (timestampExtractTestMode == TimestampExtractTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        vectorExpression.transientInit();
        System.out.println("*DEBUG* dateTimeStringTypeInfo " + dateTimeStringTypeInfo.toString() + " timestampExtractTestMode " + timestampExtractTestMode + " vectorExpression " + vectorExpression.getClass().getSimpleName());
        VectorRandomRowSource rowSource = batchSource.getRowSource();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, vectorizationContext.getScratchColumnTypeNames(), vectorizationContext.getScratchDataTypePhysicalVariations());
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{TypeInfoFactory.intTypeInfo}, new int[]{vectorExpression.getOutputColumnNum()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, (TypeInfo)TypeInfoFactory.intTypeInfo, resultObjects);
            rowIndex += batch.size;
        }
        return true;
    }

    public static enum TimestampExtractTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = TimestampExtractTestMode.values().length;
        }
    }
}

