/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class VectorRandomBatchSource {
    private final VectorRandomRowSource vectorRandomRowSource;
    private final Object[][] randomRows;
    private final int rowCount;
    private final int columnCount;
    private final VectorBatchPatterns vectorBatchPatterns;
    private VectorAssignRow vectorAssignRow;
    private int nextRowIndex;
    private int batchCount;

    private VectorRandomBatchSource(VectorRandomRowSource vectorRandomRowSource, Object[][] randomRows, VectorBatchPatterns vectorBatchPatterns, VectorAssignRow vectorAssignRow) {
        this.vectorRandomRowSource = vectorRandomRowSource;
        this.randomRows = randomRows;
        this.rowCount = randomRows.length;
        Object[] firstRow = randomRows[0];
        this.columnCount = firstRow.length;
        this.vectorBatchPatterns = vectorBatchPatterns;
        this.vectorAssignRow = vectorAssignRow;
    }

    private static VectorBatchPatterns chooseBatchPatterns(Random random, VectorRandomRowSource vectorRandomRowSource, Object[][] randomRows) {
        ArrayList<VectorBatchPattern> vectorBatchPatternList = new ArrayList<VectorBatchPattern>();
        int rowCount = randomRows.length;
        int rowIndex = 0;
        if (rowCount > 0) {
            int maximumRowCount;
            int columnCount = randomRows[0].length;
            int regularBatchSize = Math.min(rowCount - rowIndex, 1024);
            vectorBatchPatternList.add(VectorBatchPattern.createRegularBatch(regularBatchSize));
            rowIndex += regularBatchSize;
            Object[] nonNullRow = new Object[columnCount];
            block0: for (int c = 0; c < columnCount; ++c) {
                for (int r = 0; r < rowCount; ++r) {
                    Object object = randomRows[r][c];
                    if (object == null) continue;
                    nonNullRow[c] = object;
                    continue block0;
                }
            }
            int columnPermutationLimit = Math.min(columnCount, 64);
            boolean asSelected = false;
            while (true) {
                int columnNum;
                BitSet bitSet;
                int rowLimit;
                int randomRowCount;
                int maximumRowCount2;
                long columnPermutation;
                for (columnPermutation = 1L; columnPermutation <= (long)columnPermutationLimit && (maximumRowCount2 = Math.min(rowCount - rowIndex, 1024)) != 0; ++columnPermutation) {
                    randomRowCount = 1 + random.nextInt(maximumRowCount2);
                    rowLimit = rowIndex + randomRowCount;
                    bitSet = BitSet.valueOf(new long[]{columnPermutation});
                    columnNum = bitSet.nextSetBit(0);
                    while (columnNum >= 0) {
                        for (int r = rowIndex; r < rowLimit; ++r) {
                            randomRows[r][columnNum] = null;
                        }
                        columnNum = bitSet.nextSetBit(columnNum + 1);
                    }
                    vectorBatchPatternList.add(VectorBatchPattern.createRepeatedBatch(random, randomRowCount, bitSet, asSelected));
                    rowIndex = rowLimit;
                }
                for (columnPermutation = 1L; columnPermutation <= (long)columnPermutationLimit && (maximumRowCount2 = Math.min(rowCount - rowIndex, 1024)) != 0; ++columnPermutation) {
                    randomRowCount = 1 + random.nextInt(maximumRowCount2);
                    rowLimit = rowIndex + randomRowCount;
                    bitSet = BitSet.valueOf(new long[]{columnPermutation});
                    columnNum = bitSet.nextSetBit(0);
                    while (columnNum >= 0) {
                        Object repeatedObject = randomRows[rowIndex][columnNum];
                        if (repeatedObject == null) {
                            repeatedObject = nonNullRow[columnNum];
                        }
                        for (int r = rowIndex; r < rowLimit; ++r) {
                            randomRows[r][columnNum] = repeatedObject;
                        }
                        columnNum = bitSet.nextSetBit(columnNum + 1);
                    }
                    vectorBatchPatternList.add(VectorBatchPattern.createRepeatedBatch(random, randomRowCount, bitSet, asSelected));
                    rowIndex = rowLimit;
                }
                if (asSelected) break;
                asSelected = true;
            }
            while ((maximumRowCount = Math.min(rowCount - rowIndex, 1024)) != 0) {
                int randomRowCount = 1 + random.nextInt(maximumRowCount);
                asSelected = random.nextBoolean();
                vectorBatchPatternList.add(VectorBatchPattern.createRegularBatch(random, randomRowCount, asSelected));
                rowIndex += randomRowCount;
            }
        }
        return new VectorBatchPatterns(vectorBatchPatternList);
    }

    public static VectorRandomBatchSource createInterestingBatches(Random random, VectorRandomRowSource vectorRandomRowSource, Object[][] randomRows, VectorRandomBatchParameters vectorRandomBatchParameters) throws HiveException {
        VectorAssignRow vectorAssignRow = new VectorAssignRow();
        vectorAssignRow.init(vectorRandomRowSource.typeNames());
        VectorBatchPatterns vectorBatchPatterns = VectorRandomBatchSource.chooseBatchPatterns(random, vectorRandomRowSource, randomRows);
        return new VectorRandomBatchSource(vectorRandomRowSource, randomRows, vectorBatchPatterns, vectorAssignRow);
    }

    public VectorRandomRowSource getRowSource() {
        return this.vectorRandomRowSource;
    }

    public Object[][] getRandomRows() {
        return this.randomRows;
    }

    public void resetBatchIteration() {
        this.nextRowIndex = 0;
        this.batchCount = 0;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean fillNextBatch(VectorizedRowBatch batch) {
        int[] selected;
        boolean selectedInUse;
        if (this.nextRowIndex >= this.rowCount) {
            return false;
        }
        VectorBatchPattern vectorBatchPattern = this.vectorBatchPatterns.getTectorBatchPatternList().get(this.batchCount);
        int batchSize = vectorBatchPattern.getBatchSize();
        for (int c = 0; c < this.columnCount; ++c) {
            batch.cols[c].reset();
        }
        BitSet bitSet = vectorBatchPattern.getBitSet();
        if (bitSet != null) {
            int columnNum = bitSet.nextSetBit(0);
            while (columnNum >= 0) {
                batch.cols[columnNum].isRepeating = true;
                columnNum = bitSet.nextSetBit(columnNum + 1);
            }
        }
        batch.selectedInUse = selectedInUse = (selected = vectorBatchPattern.getSelected()) != null;
        if (selectedInUse) {
            System.arraycopy(selected, 0, batch.selected, 0, batchSize);
        }
        int rowIndex = this.nextRowIndex;
        for (int logicalIndex = 0; logicalIndex < batchSize; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            for (int c = 0; c < this.columnCount; ++c) {
                if (batch.cols[c].isRepeating) {
                    if (logicalIndex > 0) continue;
                    this.vectorAssignRow.assignRowColumn(batch, 0, c, this.randomRows[rowIndex][c]);
                    continue;
                }
                this.vectorAssignRow.assignRowColumn(batch, batchIndex, c, this.randomRows[rowIndex][c]);
            }
            ++rowIndex;
        }
        batch.size = batchSize;
        ++this.batchCount;
        this.nextRowIndex += batchSize;
        return true;
    }

    private static class VectorBatchPattern {
        final int batchSize;
        final BitSet bitSet;
        final int[] selected;

        private VectorBatchPattern(Random random, int batchSize, BitSet bitSet, boolean asSelected) {
            this.batchSize = batchSize;
            this.bitSet = bitSet;
            this.selected = (int[])(asSelected ? this.randomSelection(random, batchSize) : null);
        }

        private int[] randomSelection(Random random, int batchSize) {
            TreeSet<Integer> selectedSet = new TreeSet<Integer>();
            int currentCount = 0;
            while (true) {
                int candidateIndex;
                if (selectedSet.contains(candidateIndex = random.nextInt(1024))) {
                    continue;
                }
                selectedSet.add(candidateIndex);
                if (++currentCount == batchSize) break;
            }
            Integer[] integerArray = selectedSet.toArray(new Integer[0]);
            int[] result = new int[batchSize];
            for (int i = 0; i < batchSize; ++i) {
                result[i] = integerArray[i];
            }
            return result;
        }

        public static VectorBatchPattern createRegularBatch(int batchSize) {
            return new VectorBatchPattern(null, batchSize, null, false);
        }

        public static VectorBatchPattern createRegularBatch(Random random, int batchSize, boolean asSelected) {
            return new VectorBatchPattern(random, batchSize, null, asSelected);
        }

        public static VectorBatchPattern createRepeatedBatch(Random random, int batchSize, BitSet bitSet, boolean asSelected) {
            return new VectorBatchPattern(random, batchSize, bitSet, asSelected);
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public BitSet getBitSet() {
            return this.bitSet;
        }

        public int[] getSelected() {
            return this.selected;
        }

        public String toString() {
            String batchSizeString = "batchSize " + Integer.toString(this.batchSize);
            if (this.bitSet != null) {
                long bitMask = this.bitSet.toLongArray()[0];
                batchSizeString = batchSizeString + " repeating 0x" + Long.toHexString(bitMask);
            }
            boolean selectedInUse = this.selected != null;
            batchSizeString = batchSizeString + " selectedInUse " + selectedInUse;
            if (selectedInUse) {
                batchSizeString = batchSizeString + " selected " + Arrays.toString(this.selected);
            }
            return batchSizeString;
        }
    }

    private static class VectorBatchPatterns {
        private final List<VectorBatchPattern> vectorBatchPatternList;

        VectorBatchPatterns(List<VectorBatchPattern> vectorBatchPatternList) {
            this.vectorBatchPatternList = vectorBatchPatternList;
        }

        List<VectorBatchPattern> getTectorBatchPatternList() {
            return this.vectorBatchPatternList;
        }
    }

    public static class VectorRandomBatchParameters {
    }
}

