/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.ql.exec.tez.QueryAllocationManager;
import org.apache.hadoop.hive.ql.exec.tez.SampleTezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPool;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.UserPoolMapping;
import org.apache.hadoop.hive.ql.exec.tez.WmTezSession;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManager;
import org.apache.hadoop.hive.ql.wm.SessionTriggerProvider;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hive.common.util.RetryTestRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=RetryTestRunner.class)
public class TestWorkloadManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestWorkloadManager.class);
    private static final double EPSILON = 0.001;

    public static WMResourcePlan plan() {
        return new WMResourcePlan("rp");
    }

    public static WMPool pool(String path) {
        return TestWorkloadManager.pool(path, 4, 0.1f);
    }

    public static WMPool pool(String path, int qp, double alloc) {
        return TestWorkloadManager.pool(path, qp, alloc, "fair");
    }

    public static WMPool pool(String path, int qp, double alloc, String policy) {
        WMPool pool = new WMPool("rp", path);
        pool.setAllocFraction(alloc);
        pool.setQueryParallelism(qp);
        pool.setSchedulingPolicy(policy);
        return pool;
    }

    public static WMMapping mapping(String user, String pool) {
        return TestWorkloadManager.mapping("USER", user, pool, 0);
    }

    public static WMMapping mapping(String type, String user, String pool, int ordering) {
        WMMapping mapping = new WMMapping("rp", type, user);
        mapping.setPoolPath(pool);
        mapping.setOrdering(ordering);
        return mapping;
    }

    public static UserPoolMapping.MappingInput mappingInput(String userName) {
        return new UserPoolMapping.MappingInput(userName, null, null, null);
    }

    public static UserPoolMapping.MappingInput mappingInput(String userName, List<String> groups) {
        return new UserPoolMapping.MappingInput(userName, groups, null, null);
    }

    public static UserPoolMapping.MappingInput mappingInput(String userName, List<String> groups, String wmPool) {
        return new UserPoolMapping.MappingInput(userName, groups, wmPool, null);
    }

    private List<String> groups(String ... groups) {
        return Lists.newArrayList((Object[])groups);
    }

    @Test(timeout=10000L)
    public void testReuse() throws Exception {
        HiveConf conf = this.createConf();
        conf.set("fs.defaultFS", "file:///");
        MockQam qam = new MockQam();
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, 1, qam);
        wm.start();
        TezSessionState nonPool = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)nonPool.getConf()).thenReturn((Object)conf);
        ((TezSessionState)Mockito.doNothing().when((Object)nonPool)).close(Matchers.anyBoolean());
        WmTezSession session = wm.getSession(nonPool, TestWorkloadManager.mappingInput("user"), conf);
        ((TezSessionState)Mockito.verify((Object)nonPool)).close(Matchers.anyBoolean());
        Assert.assertNotSame((Object)nonPool, (Object)session);
        session.returnToSessionManager();
        TezSessionPoolSession diffPool = (TezSessionPoolSession)Mockito.mock(TezSessionPoolSession.class);
        Mockito.when((Object)diffPool.getConf()).thenReturn((Object)conf);
        ((TezSessionPoolSession)Mockito.doNothing().when((Object)diffPool)).returnToSessionManager();
        session = wm.getSession((TezSessionState)diffPool, TestWorkloadManager.mappingInput("user"), conf);
        ((TezSessionPoolSession)Mockito.verify((Object)diffPool)).returnToSessionManager();
        Assert.assertNotSame((Object)diffPool, (Object)session);
        WmTezSession session2 = wm.getSession((TezSessionState)session, TestWorkloadManager.mappingInput("user"), conf);
        Assert.assertSame((Object)session, (Object)session2);
    }

    @Test(timeout=10000L)
    public void testQueueName() throws Exception {
        HiveConf conf = this.createConf();
        conf.set("fs.defaultFS", "file:///");
        MockQam qam = new MockQam();
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, 1, qam);
        wm.start();
        conf.set("tez.queue.name", "test2");
        WmTezSession session = wm.getSession(null, TestWorkloadManager.mappingInput("user"), conf);
        Assert.assertEquals((Object)"test", (Object)session.getQueueName());
        Assert.assertEquals((Object)"test", (Object)conf.get("tez.queue.name"));
        session.setQueueName("test2");
        session = wm.getSession((TezSessionState)session, TestWorkloadManager.mappingInput("user"), conf);
        Assert.assertEquals((Object)"test", (Object)session.getQueueName());
    }

    @Test(timeout=10000L)
    public void testReopen() throws Exception {
        HiveConf conf = this.createConf();
        conf.set("fs.defaultFS", "file:///");
        MockQam qam = new MockQam();
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, 1, qam);
        wm.start();
        WmTezSession session = wm.getSession(null, TestWorkloadManager.mappingInput("user"), conf);
        Assert.assertEquals((double)1.0, (double)session.getClusterFraction(), (double)0.001);
        qam.assertWasCalledAndReset();
        WmTezSession session2 = (WmTezSession)session.reopen();
        Assert.assertNotSame((Object)session, (Object)session2);
        wm.addTestEvent().get();
        Assert.assertEquals((String)session2.toString(), (double)1.0, (double)session2.getClusterFraction(), (double)0.001);
        Assert.assertFalse((boolean)session.hasClusterFraction());
        qam.assertWasCalledAndReset();
    }

    @Test(timeout=10000L)
    public void testDestroyAndReturn() throws Exception {
        HiveConf conf = this.createConf();
        conf.set("fs.defaultFS", "file:///");
        MockQam qam = new MockQam();
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, 2, qam);
        wm.start();
        WmTezSession session = wm.getSession(null, TestWorkloadManager.mappingInput("user"), conf);
        Assert.assertEquals((double)1.0, (double)session.getClusterFraction(), (double)0.001);
        qam.assertWasCalledAndReset();
        WmTezSession session2 = wm.getSession(null, TestWorkloadManager.mappingInput("user"), conf);
        Assert.assertEquals((double)0.5, (double)session.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.5, (double)session2.getClusterFraction(), (double)0.001);
        qam.assertWasCalledAndReset();
        Assert.assertNotSame((Object)session, (Object)session2);
        session.destroy();
        Assert.assertEquals((double)1.0, (double)session2.getClusterFraction(), (double)0.001);
        Assert.assertFalse((boolean)session.hasClusterFraction());
        qam.assertWasCalledAndReset();
        session = wm.getSession(null, TestWorkloadManager.mappingInput("user"), conf);
        session.returnToSessionManager();
        Assert.assertEquals((double)1.0, (double)session2.getClusterFraction(), (double)0.001);
        Assert.assertFalse((boolean)session.hasClusterFraction());
        qam.assertWasCalledAndReset();
    }

    @Test(timeout=10000L)
    public void testClusterFractions() throws Exception {
        HiveConf conf = this.createConf();
        conf.set("fs.defaultFS", "file:///");
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("r1", 1, 0.6f), TestWorkloadManager.pool("r2", 1, 0.4f), TestWorkloadManager.pool("r1.p1", 1, 0.5), TestWorkloadManager.pool("r1.p2", 2, 0.3f)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("p1", "r1.p1"), TestWorkloadManager.mapping("p2", "r1.p2"), TestWorkloadManager.mapping("r1", "r1"), TestWorkloadManager.mapping("r2", "r2")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        Assert.assertEquals((long)5L, (long)wm.getNumSessions());
        WmTezSession session05of06 = wm.getSession(null, TestWorkloadManager.mappingInput("p1"), conf);
        Assert.assertEquals((double)0.3, (double)session05of06.getClusterFraction(), (double)0.001);
        WmTezSession session03of06 = wm.getSession(null, TestWorkloadManager.mappingInput("p2"), conf);
        Assert.assertEquals((double)0.18, (double)session03of06.getClusterFraction(), (double)0.001);
        WmTezSession session03of06_2 = wm.getSession(null, TestWorkloadManager.mappingInput("p2"), conf);
        Assert.assertEquals((double)0.09, (double)session03of06.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.09, (double)session03of06_2.getClusterFraction(), (double)0.001);
        WmTezSession session02of06 = wm.getSession(null, TestWorkloadManager.mappingInput("r1"), conf);
        Assert.assertEquals((double)0.12, (double)session02of06.getClusterFraction(), (double)0.001);
        WmTezSession session04 = wm.getSession(null, TestWorkloadManager.mappingInput("r2"), conf);
        Assert.assertEquals((double)0.4, (double)session04.getClusterFraction(), (double)0.001);
        session05of06.returnToSessionManager();
        session03of06.returnToSessionManager();
        session03of06_2.returnToSessionManager();
        session02of06.returnToSessionManager();
        session04.returnToSessionManager();
    }

    @Test(timeout=10000L)
    public void testMappings() throws Exception {
        WmTezSession r2;
        HiveConf conf = this.createConf();
        conf.set("fs.defaultFS", "file:///");
        conf.set(HiveConf.ConfVars.HIVE_SERVER2_WM_ALLOW_ANY_POOL_VIA_JDBC.varname, "false");
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("u0"), TestWorkloadManager.pool("g0"), TestWorkloadManager.pool("g1"), TestWorkloadManager.pool("u2"), TestWorkloadManager.pool("a0")}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("USER", "u0", "u0", 0), TestWorkloadManager.mapping("APPLICATION", "a0", "a0", 0), TestWorkloadManager.mapping("GROUP", "g0", "g0", 0), TestWorkloadManager.mapping("GROUP", "g1", "g1", 1), TestWorkloadManager.mapping("USER", "u2", "u2", 2)}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("u0", this.groups("zzz")), "u0");
        TestWorkloadManager.verifyMapping(wm, conf, new UserPoolMapping.MappingInput("u0", null, null, "a0"), "u0");
        TestWorkloadManager.verifyMapping(wm, conf, new UserPoolMapping.MappingInput("zzz", this.groups("g0"), null, "a0"), "a0");
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("zzz", this.groups("g1")), "g1");
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("u0", this.groups("g1")), "u0");
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("u0", this.groups("g0")), "u0");
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("u2", this.groups("g1")), "g1");
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("u2", this.groups("g0", "g1")), "g0");
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("u0", this.groups("g1"), "g1"), "g1");
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("u2", this.groups("g1"), "u2"), "u2");
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("zzz", this.groups("g0", "g1"), "g1"), "g1");
        try {
            r2 = wm.getSession(null, TestWorkloadManager.mappingInput("u0", this.groups("g0", "g1"), "u2"), conf);
            Assert.fail((String)("Expected failure, but got " + (TezSessionState)r2));
        }
        catch (Exception r2) {
            // empty catch block
        }
        conf.set(HiveConf.ConfVars.HIVE_SERVER2_WM_ALLOW_ANY_POOL_VIA_JDBC.varname, "true");
        wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        TestWorkloadManager.verifyMapping(wm, conf, TestWorkloadManager.mappingInput("u0", this.groups("g0", "g1"), "u2"), "u2");
        try {
            r2 = wm.getSession(null, TestWorkloadManager.mappingInput("u0", this.groups("g0", "g1"), "zzz"), conf);
            Assert.fail((String)("Expected failure, but got " + (TezSessionState)r2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void verifyMapping(WorkloadManager wm, HiveConf conf, UserPoolMapping.MappingInput mi, String result) throws Exception {
        WmTezSession session = wm.getSession(null, mi, conf, null);
        Assert.assertEquals((Object)result, (Object)session.getPoolName());
        session.returnToSessionManager();
    }

    @Test(timeout=10000L)
    public void testQueueing() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 2, 0.5), TestWorkloadManager.pool("B", 2, 0.5)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A"), TestWorkloadManager.mapping("B", "B")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        WmTezSession sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        WmTezSession sessionA2 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        WmTezSession sessionB1 = wm.getSession(null, TestWorkloadManager.mappingInput("B"), conf);
        AtomicReference<WmTezSession> sessionA3 = new AtomicReference<WmTezSession>();
        AtomicReference<WmTezSession> sessionA4 = new AtomicReference<WmTezSession>();
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        CountDownLatch cdl = new CountDownLatch(1);
        Thread t1 = new Thread(new GetSessionRunnable(sessionA3, wm, error, conf, cdl, "A"));
        Thread t2 = new Thread(new GetSessionRunnable(sessionA4, wm, error, conf, null, "A"));
        this.waitForThreadToBlock(cdl, t1);
        t2.start();
        Assert.assertNull((Object)sessionA3.get());
        Assert.assertNull((Object)sessionA4.get());
        this.checkError(error);
        WmTezSession sessionB2 = wm.getSession(null, TestWorkloadManager.mappingInput("B"), conf);
        sessionB1.returnToSessionManager();
        sessionB2.returnToSessionManager();
        Assert.assertNull((Object)sessionA3.get());
        Assert.assertNull((Object)sessionA4.get());
        this.checkError(error);
        sessionA1.returnToSessionManager();
        t1.join();
        this.checkError(error);
        Assert.assertNotNull((Object)sessionA3.get());
        Assert.assertNull((Object)sessionA4.get());
        sessionA3.get().returnToSessionManager();
        t2.join();
        this.checkError(error);
        Assert.assertNotNull((Object)sessionA4.get());
        sessionA4.get().returnToSessionManager();
        sessionA2.returnToSessionManager();
    }

    @Test(timeout=10000L)
    public void testClusterChange() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 2, 1.0)}));
        plan.getPlan().setDefaultPoolPath("A");
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        WmTezSession session1 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        WmTezSession session2 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        Assert.assertEquals((double)0.5, (double)session1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.5, (double)session2.getClusterFraction(), (double)0.001);
        qam.assertWasCalledAndReset();
        wm.notifyOfClusterStateChange();
        Assert.assertEquals((double)0.5, (double)session1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.5, (double)session2.getClusterFraction(), (double)0.001);
        qam.assertWasCalledAndReset();
        session1.returnToSessionManager();
        session2.returnToSessionManager();
    }

    @Test(timeout=10000L)
    public void testReuseWithQueueing() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, 2, qam);
        wm.start();
        WmTezSession session1 = wm.getSession(null, TestWorkloadManager.mappingInput("user"), conf);
        WmTezSession session1a = wm.getSession((TezSessionState)session1, TestWorkloadManager.mappingInput("user"), conf);
        Assert.assertSame((Object)session1, (Object)session1a);
        Assert.assertEquals((double)1.0, (double)session1.getClusterFraction(), (double)0.001);
        WmTezSession session2 = wm.getSession(null, TestWorkloadManager.mappingInput("user"), conf);
        WmTezSession session2a = wm.getSession((TezSessionState)session2, TestWorkloadManager.mappingInput("user"), conf);
        Assert.assertSame((Object)session2, (Object)session2a);
        Assert.assertEquals((double)0.5, (double)session1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.5, (double)session2.getClusterFraction(), (double)0.001);
        AtomicReference<WmTezSession> session3 = new AtomicReference<WmTezSession>();
        AtomicReference<WmTezSession> session4 = new AtomicReference<WmTezSession>(session2);
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        CountDownLatch cdl = new CountDownLatch(1);
        CountDownLatch cdl2 = new CountDownLatch(1);
        Thread t1 = new Thread((Runnable)new GetSessionRunnable(session3, wm, error, conf, cdl, null), "t1");
        Thread t2 = new Thread((Runnable)new GetSessionRunnable(session4, wm, error, conf, cdl2, null), "t2");
        this.waitForThreadToBlock(cdl, t1);
        Assert.assertNull((Object)session3.get());
        this.checkError(error);
        t2.start();
        cdl2.await();
        Assert.assertNull((Object)session4.get());
        t1.join();
        this.checkError(error);
        Assert.assertNotNull((Object)session3.get());
        Assert.assertEquals((double)0.5, (double)session3.get().getClusterFraction(), (double)0.001);
        session1.returnToSessionManager();
        t2.join();
        this.checkError(error);
        Assert.assertNotNull((Object)session4.get());
        Assert.assertNotSame((Object)session2, (Object)session4.get());
        Assert.assertEquals((double)0.5, (double)session4.get().getClusterFraction(), (double)0.001);
        session3.get().returnToSessionManager();
        session4.get().returnToSessionManager();
    }

    private void waitForThreadToBlock(CountDownLatch cdl, Thread t1) throws InterruptedException {
        Thread.State s;
        t1.start();
        cdl.await();
        while ((s = t1.getState()) != Thread.State.TIMED_WAITING && s != Thread.State.BLOCKED && s != Thread.State.WAITING) {
        }
    }

    @Test(timeout=10000L)
    public void testReuseWithDifferentPool() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 2, 0.6f), TestWorkloadManager.pool("B", 1, 0.4f)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A"), TestWorkloadManager.mapping("B", "B")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        WmTezSession sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        WmTezSession sessionA2 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        Assert.assertEquals((Object)"A", (Object)sessionA1.getPoolName());
        Assert.assertEquals((double)0.3f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"A", (Object)sessionA2.getPoolName());
        Assert.assertEquals((double)0.3f, (double)sessionA2.getClusterFraction(), (double)0.001);
        WmTezSession sessionB1 = wm.getSession((TezSessionState)sessionA1, TestWorkloadManager.mappingInput("B"), conf);
        Assert.assertSame((Object)sessionA1, (Object)sessionB1);
        Assert.assertEquals((Object)"B", (Object)sessionB1.getPoolName());
        Assert.assertEquals((double)0.4f, (double)sessionB1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.6f, (double)sessionA2.getClusterFraction(), (double)0.001);
        WmTezSession sessionA3 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        Assert.assertEquals((Object)"A", (Object)sessionA3.getPoolName());
        Assert.assertEquals((double)0.3f, (double)sessionA3.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.3f, (double)sessionA3.getClusterFraction(), (double)0.001);
        sessionA3.returnToSessionManager();
        sessionB1.returnToSessionManager();
        sessionA2.returnToSessionManager();
    }

    @Test(timeout=10000L)
    public void testApplyPlanUserMapping() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 0.5), TestWorkloadManager.pool("B", 1, 0.5)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("U", "A")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        WmTezSession sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("U"), conf);
        Assert.assertEquals((Object)"A", (Object)sessionA1.getPoolName());
        Assert.assertEquals((double)0.5, (double)sessionA1.getClusterFraction(), (double)0.001);
        AtomicReference<WmTezSession> sessionA2 = new AtomicReference<WmTezSession>();
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        CountDownLatch cdl = new CountDownLatch(1);
        Thread t1 = new Thread(new GetSessionRunnable(sessionA2, wm, error, conf, cdl, "U"));
        this.waitForThreadToBlock(cdl, t1);
        Assert.assertNull((Object)sessionA2.get());
        this.checkError(error);
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 0.6f), TestWorkloadManager.pool("B", 1, 0.4f)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("U", "B")}));
        wm.updateResourcePlanAsync(plan);
        t1.join();
        this.checkError(error);
        Assert.assertNotNull((Object)sessionA2.get());
        Assert.assertEquals((Object)"B", (Object)sessionA2.get().getPoolName());
        Assert.assertEquals((double)0.4f, (double)sessionA2.get().getClusterFraction(), (double)0.001);
        sessionA2.get().returnToSessionManager();
        WmTezSession sessionB1 = wm.getSession(null, TestWorkloadManager.mappingInput("U"), conf);
        Assert.assertEquals((Object)"B", (Object)sessionB1.getPoolName());
        Assert.assertEquals((double)0.4f, (double)sessionB1.getClusterFraction(), (double)0.001);
        sessionA1.returnToSessionManager();
        sessionB1.returnToSessionManager();
    }

    @Test(timeout=10000L)
    public void testApplyPlanQpChanges() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 0.35f), TestWorkloadManager.pool("B", 2, 0.15f), TestWorkloadManager.pool("C", 2, 0.3f), TestWorkloadManager.pool("D", 1, 0.3f)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A"), TestWorkloadManager.mapping("B", "B"), TestWorkloadManager.mapping("C", "C"), TestWorkloadManager.mapping("D", "D")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        TezSessionPool tezAmPool = wm.getTezAmPool();
        Assert.assertEquals((long)6L, (long)tezAmPool.getCurrentSize());
        WmTezSession sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        WmTezSession sessionB1 = wm.getSession(null, TestWorkloadManager.mappingInput("B"), conf);
        WmTezSession sessionB2 = wm.getSession(null, TestWorkloadManager.mappingInput("B"), conf);
        WmTezSession sessionC1 = wm.getSession(null, TestWorkloadManager.mappingInput("C"), conf);
        WmTezSession sessionD1 = wm.getSession(null, TestWorkloadManager.mappingInput("D"), conf);
        AtomicReference<WmTezSession> sessionA2 = new AtomicReference<WmTezSession>();
        AtomicReference<WmTezSession> sessionD2 = new AtomicReference<WmTezSession>();
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        CountDownLatch cdl1 = new CountDownLatch(1);
        CountDownLatch cdl2 = new CountDownLatch(1);
        Thread t1 = new Thread(new GetSessionRunnable(sessionA2, wm, error, conf, cdl1, "A"));
        Thread t2 = new Thread(new GetSessionRunnable(sessionD2, wm, error, conf, cdl2, "D"));
        this.waitForThreadToBlock(cdl1, t1);
        this.waitForThreadToBlock(cdl2, t2);
        this.checkError(error);
        Assert.assertEquals((double)0.3f, (double)sessionC1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.3f, (double)sessionD1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((long)1L, (long)tezAmPool.getCurrentSize());
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("B", 1, 0.3f), TestWorkloadManager.pool("C", 1, 0.2f), TestWorkloadManager.pool("D", 2, 0.5)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "B"), TestWorkloadManager.mapping("B", "B"), TestWorkloadManager.mapping("C", "C"), TestWorkloadManager.mapping("D", "D")}));
        wm.updateResourcePlanAsync(plan);
        wm.addTestEvent().get();
        t1.join();
        t2.join();
        this.checkError(error);
        Assert.assertNotNull((Object)sessionA2.get());
        Assert.assertNotNull((Object)sessionD2.get());
        Assert.assertEquals((Object)"D", (Object)sessionD2.get().getPoolName());
        Assert.assertEquals((Object)"B", (Object)sessionA2.get().getPoolName());
        Assert.assertEquals((Object)"C", (Object)sessionC1.getPoolName());
        Assert.assertEquals((double)0.3f, (double)sessionA2.get().getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.2f, (double)sessionC1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.25, (double)sessionD1.getClusterFraction(), (double)0.001);
        this.assertKilledByWm(sessionA1);
        this.assertKilledByWm(sessionB1);
        this.assertKilledByWm(sessionB2);
        Assert.assertEquals((long)0L, (long)tezAmPool.getCurrentSize());
        sessionA2.get().returnToSessionManager();
        Assert.assertEquals((double)0.25, (double)sessionD2.get().getClusterFraction(), (double)0.001);
        sessionD2.get().returnToSessionManager();
        sessionC1.returnToSessionManager();
        sessionD1.returnToSessionManager();
        sessionA1.returnToSessionManager();
        sessionB1.returnToSessionManager();
        sessionB2.returnToSessionManager();
        Assert.assertEquals((long)4L, (long)tezAmPool.getCurrentSize());
    }

    @Test(timeout=10000L)
    public void testFifoSchedulingPolicy() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 3, 1.0, "fair")}));
        plan.getPlan().setDefaultPoolPath("A");
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        WmTezSession sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("A", null), conf, null);
        WmTezSession sessionA2 = wm.getSession(null, TestWorkloadManager.mappingInput("A", null), conf, null);
        Assert.assertEquals((double)0.5, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.5, (double)sessionA2.getClusterFraction(), (double)0.001);
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 3, 1.0, "fifo")}));
        plan.getPlan().setDefaultPoolPath("A");
        wm.updateResourcePlanAsync(plan).get();
        Assert.assertEquals((double)1.0, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)sessionA2.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"A", (Object)sessionA2.getPoolName());
        WmTezSession sessionA3 = wm.getSession(null, TestWorkloadManager.mappingInput("A", null), conf, null);
        Assert.assertEquals((double)0.0, (double)sessionA3.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"A", (Object)sessionA3.getPoolName());
        sessionA1.returnToSessionManager();
        Assert.assertEquals((double)1.0, (double)sessionA2.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)sessionA3.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"A", (Object)sessionA3.getPoolName());
        WmTezSession sessionA4 = wm.getSession((TezSessionState)sessionA2, TestWorkloadManager.mappingInput("A", null), conf, null);
        Assert.assertSame((Object)sessionA2, (Object)sessionA4);
        Assert.assertEquals((double)1.0, (double)sessionA3.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)sessionA2.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"A", (Object)sessionA2.getPoolName());
        sessionA3.returnToSessionManager();
        Assert.assertEquals((double)1.0, (double)sessionA2.getClusterFraction(), (double)0.001);
        sessionA2.returnToSessionManager();
    }

    @Test(timeout=10000L)
    public void testDisableEnable() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 1.0)}));
        plan.getPlan().setDefaultPoolPath("A");
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        TezSessionPool tezAmPool = wm.getTezAmPool();
        WmTezSession sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("A", null), conf, null);
        AtomicReference<WmTezSession> sessionA2 = new AtomicReference<WmTezSession>();
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        CountDownLatch cdl1 = new CountDownLatch(1);
        Thread t1 = new Thread(new GetSessionRunnable(sessionA2, wm, error, conf, cdl1, "A"));
        this.waitForThreadToBlock(cdl1, t1);
        this.checkError(error);
        wm.updateResourcePlanAsync(null).get();
        t1.join();
        Assert.assertNotNull((Object)error.get());
        Assert.assertNull((Object)sessionA2.get());
        this.assertKilledByWm(sessionA1);
        Assert.assertEquals((long)0L, (long)tezAmPool.getCurrentSize());
        sessionA1.returnToSessionManager();
        Assert.assertEquals((long)0L, (long)tezAmPool.getCurrentSize());
        try {
            WmTezSession r = wm.getSession(null, TestWorkloadManager.mappingInput("A", null), conf, null);
            Assert.fail((String)("Expected an error but got " + (TezSessionState)r));
        }
        catch (WorkloadManager.NoPoolMappingException noPoolMappingException) {
            // empty catch block
        }
        wm.updateResourcePlanAsync(plan).get();
        sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("A", null), conf, null);
        Assert.assertEquals((Object)"A", (Object)sessionA1.getPoolName());
        sessionA1.returnToSessionManager();
        Assert.assertEquals((long)1L, (long)tezAmPool.getCurrentSize());
    }

    @Test(timeout=10000L)
    public void testAmPoolInteractions() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        TezSessionPool pool = wm.getTezAmPool();
        WmTezSession oob = (WmTezSession)pool.getSession();
        AtomicReference<WmTezSession> sessionA1 = new AtomicReference<WmTezSession>();
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        CountDownLatch cdl1 = new CountDownLatch(1);
        Thread t1 = new Thread(new GetSessionRunnable(sessionA1, wm, error, conf, cdl1, "A"));
        this.waitForThreadToBlock(cdl1, t1);
        this.checkError(error);
        pool.replaceSession((TezSessionPoolSession)oob);
        t1.join();
        Assert.assertNotNull((Object)sessionA1.get());
        Assert.assertEquals((Object)"A", (Object)sessionA1.get().getPoolName());
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 4, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A")}));
        wm.updateResourcePlanAsync(plan);
        WmTezSession oob2 = (WmTezSession)pool.getSession();
        WmTezSession oob3 = (WmTezSession)pool.getSession();
        WmTezSession oob4 = (WmTezSession)pool.getSession();
        pool.returnSession((TezSessionPoolSession)oob2);
        Assert.assertEquals((long)1L, (long)pool.getCurrentSize());
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A")}));
        wm.updateResourcePlanAsync(plan);
        wm.addTestEvent().get();
        Assert.assertEquals((long)0L, (long)pool.getCurrentSize());
        sessionA1.get().returnToSessionManager();
        pool.returnSession((TezSessionPoolSession)oob3);
        Assert.assertEquals((long)0L, (long)pool.getCurrentSize());
        pool.returnSession((TezSessionPoolSession)oob4);
        Assert.assertEquals((long)1L, (long)pool.getCurrentSize());
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 2, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A")}));
        wm.updateResourcePlanAsync(plan);
        oob2 = (WmTezSession)pool.getSession();
        oob3 = (WmTezSession)pool.getSession();
        Assert.assertEquals((long)0L, (long)pool.getCurrentSize());
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A")}));
        wm.updateResourcePlanAsync(plan);
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 2, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A")}));
        wm.updateResourcePlanAsync(plan);
        wm.addTestEvent().get();
        Assert.assertEquals((long)0L, (long)pool.getCurrentSize());
        pool.returnSession((TezSessionPoolSession)oob3);
        pool.returnSession((TezSessionPoolSession)oob4);
        Assert.assertEquals((long)2L, (long)pool.getCurrentSize());
    }

    @Test(timeout=10000L)
    public void testMoveSessions() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 0.6f), TestWorkloadManager.pool("B", 2, 0.4f)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A"), TestWorkloadManager.mapping("B", "B")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        WmTezSession sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        Map allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().contains(sessionA1));
        Assert.assertFalse((boolean)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().contains(sessionA1));
        Assert.assertEquals((double)0.6f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"A", (Object)sessionA1.getPoolName());
        Future future = wm.applyMoveSessionAsync(sessionA1, "B");
        Assert.assertNotNull(future.get());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        wm.addTestEvent().get();
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertFalse((boolean)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().contains(sessionA1));
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().contains(sessionA1));
        Assert.assertEquals((double)0.4f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"B", (Object)sessionA1.getPoolName());
        WmTezSession sessionA2 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().contains(sessionA2));
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().contains(sessionA1));
        Assert.assertEquals((double)0.6f, (double)sessionA2.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.4f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"A", (Object)sessionA2.getPoolName());
        Assert.assertEquals((Object)"B", (Object)sessionA1.getPoolName());
        future = wm.applyMoveSessionAsync(sessionA2, "B");
        Assert.assertNotNull(future.get());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        wm.addTestEvent().get();
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)2L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().contains(sessionA2));
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().contains(sessionA1));
        Assert.assertEquals((double)0.2f, (double)sessionA2.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.2f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"B", (Object)sessionA2.getPoolName());
        Assert.assertEquals((Object)"B", (Object)sessionA1.getPoolName());
        WmTezSession sessionA3 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)2L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().contains(sessionA3));
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().contains(sessionA2));
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().contains(sessionA1));
        Assert.assertEquals((double)0.6f, (double)sessionA3.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.2f, (double)sessionA2.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.2f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertEquals((Object)"A", (Object)sessionA3.getPoolName());
        Assert.assertEquals((Object)"B", (Object)sessionA2.getPoolName());
        Assert.assertEquals((Object)"B", (Object)sessionA1.getPoolName());
        future = wm.applyMoveSessionAsync(sessionA3, "B");
        Assert.assertNotNull(future.get());
        Assert.assertFalse((boolean)((Boolean)future.get()));
        wm.addTestEvent().get();
        while (sessionA3.isOpen()) {
            Thread.sleep(100L);
        }
        Assert.assertNull((Object)sessionA3.getPoolName());
        Assert.assertEquals((Object)"Destination pool B is full. Killing query.", (Object)sessionA3.getReasonForKill());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)2L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
    }

    @Test(timeout=10000L)
    public void testMoveSessionsMultiPool() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 0.4f), TestWorkloadManager.pool("B", 1, 0.4f), TestWorkloadManager.pool("B.x", 1, 0.2f), TestWorkloadManager.pool("B.y", 1, 0.8f), TestWorkloadManager.pool("C", 1, 0.2f)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A"), TestWorkloadManager.mapping("B", "B"), TestWorkloadManager.mapping("C", "C")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        WmTezSession sessionA1 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        Map allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.y")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("C")).getSessions().size());
        Assert.assertEquals((double)0.4f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().contains(sessionA1));
        Assert.assertEquals((Object)"A", (Object)sessionA1.getPoolName());
        Future future = wm.applyMoveSessionAsync(sessionA1, "B.y");
        Assert.assertNotNull(future.get());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        wm.addTestEvent().get();
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().size());
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("B.y")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("C")).getSessions().size());
        Assert.assertEquals((double)0.32f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B.y")).getSessions().contains(sessionA1));
        Assert.assertEquals((Object)"B.y", (Object)sessionA1.getPoolName());
        future = wm.applyMoveSessionAsync(sessionA1, "C");
        Assert.assertNotNull(future.get());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        wm.addTestEvent().get();
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.y")).getSessions().size());
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("C")).getSessions().size());
        Assert.assertEquals((double)0.2f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("C")).getSessions().contains(sessionA1));
        Assert.assertEquals((Object)"C", (Object)sessionA1.getPoolName());
        future = wm.applyMoveSessionAsync(sessionA1, "B.x");
        Assert.assertNotNull(future.get());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        wm.addTestEvent().get();
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.y")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("C")).getSessions().size());
        Assert.assertEquals((double)0.08f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().contains(sessionA1));
        Assert.assertEquals((Object)"B.x", (Object)sessionA1.getPoolName());
        WmTezSession sessionA2 = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.y")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("C")).getSessions().size());
        Assert.assertEquals((double)0.4f, (double)sessionA2.getClusterFraction(), (double)0.001);
        Assert.assertEquals((double)0.08f, (double)sessionA1.getClusterFraction(), (double)0.001);
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().contains(sessionA2));
        Assert.assertTrue((boolean)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().contains(sessionA1));
        Assert.assertEquals((Object)"A", (Object)sessionA2.getPoolName());
        Assert.assertEquals((Object)"B.x", (Object)sessionA1.getPoolName());
        future = wm.applyMoveSessionAsync(sessionA1, "A");
        Assert.assertNotNull(future.get());
        Assert.assertFalse((boolean)((Boolean)future.get()));
        wm.addTestEvent().get();
        while (sessionA1.isOpen()) {
            Thread.sleep(100L);
        }
        Assert.assertNull((Object)sessionA1.getPoolName());
        Assert.assertEquals((Object)"Destination pool A is full. Killing query.", (Object)sessionA1.getReasonForKill());
        Assert.assertEquals((long)1L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().size());
        wm.returnAfterUse((TezSessionPoolSession)sessionA2);
        wm.addTestEvent().get();
        allSessionProviders = wm.getAllSessionTriggerProviders();
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.x")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("B.y")).getSessions().size());
        Assert.assertEquals((long)0L, (long)((SessionTriggerProvider)allSessionProviders.get("C")).getSessions().size());
        Assert.assertFalse((boolean)sessionA1.hasClusterFraction());
        Assert.assertFalse((boolean)((SessionTriggerProvider)allSessionProviders.get("A")).getSessions().contains(sessionA1));
    }

    @Test(timeout=10000L)
    public void testAsyncSessionInitFailures() throws Exception {
        HiveConf conf = this.createConf();
        MockQam qam = new MockQam();
        WMFullResourcePlan plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A")}));
        WorkloadManagerForTest wm = new WorkloadManagerForTest("test", conf, qam, plan);
        wm.start();
        TezSessionPool pool = wm.getTezAmPool();
        SampleTezSessionState theOnlySession = (SampleTezSessionState)pool.getSession();
        SettableFuture blockedWait = SettableFuture.create();
        theOnlySession.setWaitForAmRegistryFuture((ListenableFuture<Boolean>)blockedWait);
        pool.returnSession((TezSessionPoolSession)theOnlySession);
        Assert.assertEquals((long)1L, (long)pool.getCurrentSize());
        AtomicReference<WmTezSession> sessionA = new AtomicReference<WmTezSession>();
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        CountDownLatch cdl = new CountDownLatch(1);
        Thread t1 = new Thread(new GetSessionRunnable(sessionA, wm, error, conf, cdl, "A"));
        this.waitForThreadToBlock(cdl, t1);
        this.checkError(error);
        wm.addTestEvent().get();
        Assert.assertEquals((long)0L, (long)pool.getCurrentSize());
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("B", 1, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "B")}));
        wm.updateResourcePlanAsync(plan);
        wm.addTestEvent().get();
        blockedWait.set((Object)true);
        t1.join();
        try {
            sessionA.get();
            Assert.fail((String)("Expected an error but got " + sessionA.get()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.checkError(error);
            Assert.fail((String)"Expected an error");
        }
        catch (Exception exception) {
            // empty catch block
        }
        error.set(null);
        theOnlySession = this.validatePoolAfterCleanup(theOnlySession, conf, wm, (TezSessionPool<WmTezSession>)pool, "B");
        SettableFuture failedWait = SettableFuture.create();
        failedWait.setException((Throwable)new Exception("foo"));
        theOnlySession.setWaitForAmRegistryFuture((ListenableFuture<Boolean>)failedWait);
        WmTezSession retriedSession = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        Assert.assertNotNull((Object)retriedSession);
        Assert.assertNotSame((Object)((Object)theOnlySession), (Object)retriedSession);
        retriedSession.returnToSessionManager();
        theOnlySession = (SampleTezSessionState)retriedSession;
        theOnlySession.setWaitForAmRegistryFuture((ListenableFuture<Boolean>)failedWait);
        wm.setNextWaitForAmRegistryFuture((SettableFuture<Boolean>)failedWait);
        try {
            WmTezSession r = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
            Assert.fail((String)("Expected an error but got " + (TezSessionState)r));
        }
        catch (Exception exception) {
            // empty catch block
        }
        theOnlySession = this.validatePoolAfterCleanup(theOnlySession, conf, wm, (TezSessionPool<WmTezSession>)pool, "B");
        failedWait = SettableFuture.create();
        theOnlySession.setWaitForAmRegistryFuture((ListenableFuture<Boolean>)failedWait);
        wm.setNextWaitForAmRegistryFuture((SettableFuture<Boolean>)failedWait);
        sessionA.set(null);
        cdl = new CountDownLatch(1);
        t1 = new Thread(new GetSessionRunnable(sessionA, wm, error, conf, cdl, "A"));
        this.waitForThreadToBlock(cdl, t1);
        wm.addTestEvent().get();
        Assert.assertEquals((long)0L, (long)pool.getCurrentSize());
        plan = new WMFullResourcePlan(TestWorkloadManager.plan(), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("A", 1, 1.0)}));
        plan.setMappings((List)Lists.newArrayList((Object[])new WMMapping[]{TestWorkloadManager.mapping("A", "A")}));
        wm.updateResourcePlanAsync(plan);
        wm.addTestEvent().get();
        failedWait.setException((Throwable)new Exception("moo"));
        t1.join();
        try {
            sessionA.get();
            Assert.fail((String)("Expected an error but got " + sessionA.get()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.checkError(error);
            Assert.fail((String)"Expected an error");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validatePoolAfterCleanup(theOnlySession, conf, wm, (TezSessionPool<WmTezSession>)pool, "A");
    }

    private SampleTezSessionState validatePoolAfterCleanup(SampleTezSessionState oldSession, HiveConf conf, WorkloadManager wm, TezSessionPool<WmTezSession> pool, String sessionPoolName) throws Exception {
        SampleTezSessionState theOnlySession = (SampleTezSessionState)pool.getSession();
        Assert.assertNotNull((Object)((Object)theOnlySession));
        theOnlySession.setWaitForAmRegistryFuture(null);
        Assert.assertNull((Object)oldSession.getPoolName());
        Assert.assertFalse((boolean)oldSession.hasClusterFraction());
        pool.returnSession((TezSessionPoolSession)theOnlySession);
        WmTezSession result = wm.getSession(null, TestWorkloadManager.mappingInput("A"), conf);
        Assert.assertEquals((Object)sessionPoolName, (Object)result.getPoolName());
        Assert.assertEquals((double)1.0, (double)result.getClusterFraction(), (double)0.001);
        result.returnToSessionManager();
        return theOnlySession;
    }

    private void assertKilledByWm(WmTezSession session) {
        Assert.assertNull((Object)session.getPoolName());
        Assert.assertFalse((boolean)session.hasClusterFraction());
        Assert.assertTrue((boolean)session.isIrrelevantForWm());
    }

    private void checkError(AtomicReference<Throwable> error) throws Exception {
        Throwable t = error.get();
        if (t == null) {
            return;
        }
        throw new Exception(t);
    }

    private HiveConf createConf() {
        HiveConf conf = new HiveConf();
        conf.set(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_LIFETIME.varname, "-1");
        conf.set(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS.varname, "false");
        conf.set(HiveConf.ConfVars.LLAP_TASK_SCHEDULER_AM_REGISTRY_NAME.varname, "");
        return conf;
    }

    public static class WorkloadManagerForTest
    extends WorkloadManager {
        private SettableFuture<Boolean> failedWait;

        public WorkloadManagerForTest(String yarnQueue, HiveConf conf, int numSessions, QueryAllocationManager qam) throws ExecutionException, InterruptedException {
            super(null, yarnQueue, conf, qam, WorkloadManagerForTest.createDummyPlan(numSessions));
        }

        public WorkloadManagerForTest(String yarnQueue, HiveConf conf, QueryAllocationManager qam, WMFullResourcePlan plan) throws ExecutionException, InterruptedException {
            super(null, yarnQueue, conf, qam, plan);
        }

        public void notifyOfClusterStateChange() {
            super.notifyOfClusterStateChange();
            try {
                this.ensureWm();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private static WMFullResourcePlan createDummyPlan(int numSessions) {
            WMFullResourcePlan plan = new WMFullResourcePlan(new WMResourcePlan("rp"), (List)Lists.newArrayList((Object[])new WMPool[]{TestWorkloadManager.pool("llap", numSessions, 1.0)}));
            plan.getPlan().setDefaultPoolPath("llap");
            return plan;
        }

        protected WmTezSession createSessionObject(String sessionId, HiveConf conf) {
            conf = conf == null ? new HiveConf(this.getConf()) : conf;
            conf.set("fs.defaultFS", "file:///");
            SampleTezSessionState sess = new SampleTezSessionState(sessionId, (TezSessionPoolSession.Manager)this, conf);
            if (this.failedWait != null) {
                sess.setWaitForAmRegistryFuture((ListenableFuture<Boolean>)this.failedWait);
                this.failedWait = null;
            }
            return sess;
        }

        public WmTezSession getSession(TezSessionState session, UserPoolMapping.MappingInput input, HiveConf conf, WmContext wmContext) throws Exception {
            WmTezSession state = super.getSession(session, input, conf, null);
            this.ensureWm();
            return state;
        }

        public void destroy(TezSessionState session) throws Exception {
            super.destroy(session);
            this.ensureWm();
        }

        private void ensureWm() throws InterruptedException, ExecutionException {
            this.addTestEvent().get();
        }

        public void returnAfterUse(TezSessionPoolSession session) throws Exception {
            super.returnAfterUse(session);
            this.ensureWm();
        }

        public TezSessionState reopen(TezSessionState session) throws Exception {
            session = super.reopen(session);
            this.ensureWm();
            return session;
        }

        public void setNextWaitForAmRegistryFuture(SettableFuture<Boolean> failedWait) {
            this.failedWait = failedWait;
        }
    }

    public static class MockQam
    implements QueryAllocationManager {
        boolean isCalled = false;

        public void start() {
        }

        public void stop() {
        }

        public int updateSessionsAsync(Double totalMaxAlloc, List<WmTezSession> sessions) {
            this.isCalled = true;
            return 0;
        }

        public void updateSessionAsync(WmTezSession session) {
        }

        void assertWasCalledAndReset() {
            Assert.assertTrue((boolean)this.isCalled);
            this.isCalled = false;
        }

        public void setClusterChangedCallback(Runnable clusterChangedCallback) {
        }

        public int translateAllocationToCpus(double allocation) {
            return 0;
        }
    }

    private final class GetSessionRunnable
    implements Runnable {
        private final AtomicReference<WmTezSession> session;
        private final WorkloadManager wm;
        private final AtomicReference<Throwable> error;
        private final HiveConf conf;
        private final CountDownLatch cdl;
        private final String userName;

        private GetSessionRunnable(AtomicReference<WmTezSession> session, WorkloadManager wm, AtomicReference<Throwable> error, HiveConf conf, CountDownLatch cdl, String userName) {
            this.session = session;
            this.wm = wm;
            this.error = error;
            this.conf = conf;
            this.cdl = cdl;
            this.userName = userName;
        }

        @Override
        public void run() {
            WmTezSession old = this.session.get();
            this.session.set(null);
            if (this.cdl != null) {
                this.cdl.countDown();
            }
            try {
                this.session.set(this.wm.getSession((TezSessionState)old, TestWorkloadManager.mappingInput(this.userName), this.conf));
            }
            catch (Throwable e) {
                this.error.compareAndSet(null, e);
            }
        }
    }
}

