/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.TestTxnLoadData;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestTxnConcatenate
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnConcatenate.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnLoadData.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Override
    String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Test
    public void testConcatenate() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(1,2),(4,5)");
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.ACIDTBL + " set b = 4");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(5,6),(8,8)");
        String testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a, b";
        String[][] expected = new String[][]{{"{\"writeid\":2,\"bucketid\":536936448,\"rowid\":1}\t1\t4", "acidtbl/delta_0000002_0000002_0000/bucket_00001"}, {"{\"writeid\":2,\"bucketid\":536936448,\"rowid\":0}\t4\t4", "acidtbl/delta_0000002_0000002_0000/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":1}\t5\t6", "acidtbl/delta_0000003_0000003_0000/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t8\t8", "acidtbl/delta_0000003_0000003_0000/bucket_00001"}};
        this.checkResult(expected, testQuery, false, "check data", LOG);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, true);
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBL + " concatenate");
        TxnStore txnStore = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        this.runWorker(this.hiveConf);
        rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        String[][] expected2 = new String[][]{{"{\"writeid\":2,\"bucketid\":536936448,\"rowid\":1}\t1\t4", "acidtbl/base_0000003/bucket_00001"}, {"{\"writeid\":2,\"bucketid\":536936448,\"rowid\":0}\t4\t4", "acidtbl/base_0000003/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":1}\t5\t6", "acidtbl/base_0000003/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t8\t8", "acidtbl/base_0000003/bucket_00001"}};
        this.checkResult(expected2, testQuery, false, "check data after concatenate", LOG);
    }

    @Test
    public void testConcatenatePart() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " values(1,2,'p1'),(4,5,'p2')");
        this.runStatementOnDriver("update " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " set b = 4 where p='p1'");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " values(5,6,'p1'),(8,8,'p2')");
        String testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b";
        String[][] expected = new String[][]{{"{\"writeid\":2,\"bucketid\":536936448,\"rowid\":0}\t1\t4", "acidtblpart/p=p1/delta_0000002_0000002_0000/bucket_00001"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t4\t5", "acidtblpart/p=p2/delta_0000001_0000001_0000/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t5\t6", "acidtblpart/p=p1/delta_0000003_0000003_0000/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t8\t8", "acidtblpart/p=p2/delta_0000003_0000003_0000/bucket_00001"}};
        this.checkResult(expected, testQuery, false, "check data", LOG);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, true);
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " PARTITION(p='p1') concatenate");
        TxnStore txnStore = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        this.runWorker(this.hiveConf);
        rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        String[][] expected2 = new String[][]{{"{\"writeid\":2,\"bucketid\":536936448,\"rowid\":0}\t1\t4", "acidtblpart/p=p1/base_0000003/bucket_00001"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t4\t5", "acidtblpart/p=p2/delta_0000001_0000001_0000/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t5\t6", "acidtblpart/p=p1/base_0000003/bucket_00001"}, {"{\"writeid\":3,\"bucketid\":536936448,\"rowid\":0}\t8\t8", "acidtblpart/p=p2/delta_0000003_0000003_0000/bucket_00001"}};
        this.checkResult(expected2, testQuery, false, "check data after concatenate", LOG);
    }

    @Test
    public void testConcatenateMM() throws Exception {
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CREATE_TABLES_AS_INSERT_ONLY, (boolean)true);
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("create table T(a int, b int)");
        this.runStatementOnDriver("insert into T values(1,2),(4,5)");
        this.runStatementOnDriver("insert into T values(5,6),(8,8)");
        String testQuery = "select a, b, INPUT__FILE__NAME from T order by a, b";
        String[][] expected = new String[][]{{"1\t2", "t/delta_0000001_0000001_0000/000000_0"}, {"4\t5", "t/delta_0000001_0000001_0000/000000_0"}, {"5\t6", "t/delta_0000002_0000002_0000/000000_0"}, {"8\t8", "t/delta_0000002_0000002_0000/000000_0"}};
        this.checkResult(expected, testQuery, false, "check data", LOG);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.TRANSACTIONAL_CONCATENATE_NOBLOCK, true);
        this.runStatementOnDriver("alter table T concatenate");
        TxnStore txnStore = TxnUtils.getTxnStore((Configuration)this.hiveConf);
        ShowCompactResponse rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        this.runWorker(this.hiveConf);
        rsp = txnStore.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        String[][] expected2 = new String[][]{{"1\t2", "t/base_0000002/000000_0"}, {"4\t5", "t/base_0000002/000000_0"}, {"5\t6", "t/base_0000002/000000_0"}, {"8\t8", "t/base_0000002/000000_0"}};
        this.checkResult(expected2, testQuery, false, "check data after concatenate", LOG);
    }

    @Test
    public void testRenameTable() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID, (boolean)true);
        this.runStatementOnDriver("drop database if exists mydb1 cascade");
        this.runStatementOnDriver("drop database if exists mydb2 cascade");
        this.runStatementOnDriver("create database mydb1");
        this.runStatementOnDriver("create database mydb2");
        this.runStatementOnDriver("create table mydb1.T(a int, b int) stored as orc");
        this.runStatementOnDriver("insert into mydb1.T values(1,2),(4,5)");
        this.runStatementOnDriver("update mydb1.T set b = 6 where b = 5");
        this.runStatementOnDriver("alter table mydb1.T compact 'minor'");
        this.runStatementOnDriver("alter table mydb1.T RENAME TO mydb1.S");
        String testQuery = "select ROW__ID, a, b, INPUT__FILE__NAME from mydb1.S";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t2", "s/delta_0000001_0000001_0000/bucket_00000"}, {"{\"writeid\":2,\"bucketid\":536870912,\"rowid\":0}\t4\t6", "s/delta_0000002_0000002_0000/bucket_00000"}};
        this.checkResult(expected, testQuery, false, "check data", LOG);
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TABLE='t'"));
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE where CQ_TABLE='t'"));
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from WRITE_SET where WS_TABLE='t'"));
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID where T2W_TABLE='t'"));
        Assert.assertEquals((long)0L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from NEXT_WRITE_ID where NWI_TABLE='t'"));
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TABLE='s'"));
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE where CQ_TABLE='s'"));
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from WRITE_SET where WS_TABLE='s'"));
        Assert.assertEquals((long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID where T2W_TABLE='s'"));
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from NEXT_WRITE_ID where NWI_TABLE='s'"));
        this.runStatementOnDriver("alter table mydb1.S RENAME TO mydb2.bar");
        Assert.assertEquals((String)TxnDbUtil.queryToString((Configuration)this.hiveConf, (String)"select * from COMPLETED_TXN_COMPONENTS"), (long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TABLE='bar'"));
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from COMPACTION_QUEUE where CQ_TABLE='bar'"));
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from WRITE_SET where WS_TABLE='bar'"));
        Assert.assertEquals((long)2L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from TXN_TO_WRITE_ID where T2W_TABLE='bar'"));
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countQueryAgent((Configuration)this.hiveConf, (String)"select count(*) from NEXT_WRITE_ID where NWI_TABLE='bar'"));
    }
}

