/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssign;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class VectorColumnAssignFactory {
    public static VectorColumnAssign[] buildAssigners(VectorizedRowBatch outputBatch) throws HiveException {
        VectorColumnAssign[] vca = new VectorColumnAssign[outputBatch.cols.length];
        for (int i = 0; i < vca.length; ++i) {
            ColumnVector cv = outputBatch.cols[i];
            if (cv == null) continue;
            if (cv instanceof LongColumnVector) {
                vca[i] = new VectorLongColumnAssign(){

                    @Override
                    protected void copyValue(LongColumnVector in, int srcIndex, int destIndex) {
                        this.assignLong(in.vector[srcIndex], destIndex);
                    }
                }.init(outputBatch, (LongColumnVector)cv);
                continue;
            }
            if (cv instanceof DoubleColumnVector) {
                vca[i] = new VectorDoubleColumnAssign(){

                    @Override
                    protected void copyValue(DoubleColumnVector in, int srcIndex, int destIndex) {
                        this.assignDouble(in.vector[srcIndex], destIndex);
                    }
                }.init(outputBatch, (DoubleColumnVector)cv);
                continue;
            }
            if (cv instanceof BytesColumnVector) {
                vca[i] = new VectorBytesColumnAssign(){

                    @Override
                    protected void copyValue(BytesColumnVector src, int srcIndex, int destIndex) {
                        this.assignBytes(src.vector[srcIndex], src.start[srcIndex], src.length[srcIndex], destIndex);
                    }
                }.init(outputBatch, (BytesColumnVector)cv);
                continue;
            }
            if (cv instanceof DecimalColumnVector) {
                vca[i] = new VectorDecimalColumnAssign(){

                    @Override
                    protected void copyValue(DecimalColumnVector src, int srcIndex, int destIndex) {
                        this.assignDecimal(src.vector[srcIndex], destIndex);
                    }
                };
                continue;
            }
            throw new HiveException("Unimplemented vector column type: " + cv.getClass().getName());
        }
        return vca;
    }

    public static VectorColumnAssign buildObjectAssign(VectorizedRowBatch outputBatch, int outColIndex, ObjectInspector objInspector) throws HiveException {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objInspector;
        return VectorColumnAssignFactory.buildObjectAssign(outputBatch, outColIndex, poi.getPrimitiveCategory());
    }

    public static VectorColumnAssign buildObjectAssign(VectorizedRowBatch outputBatch, int outColIndex, PrimitiveObjectInspector.PrimitiveCategory category) throws HiveException {
        VectorColumnAssign outVCA;
        block28: {
            ColumnVector destCol;
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block27: {
                                outVCA = null;
                                destCol = outputBatch.cols[outColIndex];
                                if (destCol != null) break block27;
                                switch (category) {
                                    case VOID: {
                                        outVCA = new VectorLongColumnAssign(){

                                            @Override
                                            public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                                assert (val == null);
                                            }
                                        };
                                        break block28;
                                    }
                                    default: {
                                        throw new HiveException("Incompatible (null) vector column and primitive category " + category);
                                    }
                                }
                            }
                            if (!(destCol instanceof LongColumnVector)) break block29;
                            switch (category) {
                                case BOOLEAN: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                BooleanWritable bw = (BooleanWritable)val;
                                                this.assignLong(bw.get() ? 1L : 0L, destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block28;
                                }
                                case BYTE: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                ByteWritable bw = (ByteWritable)((Object)val);
                                                this.assignLong(bw.get(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block28;
                                }
                                case SHORT: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                ShortWritable bw = (ShortWritable)val;
                                                this.assignLong(bw.get(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block28;
                                }
                                case INT: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                IntWritable bw = (IntWritable)val;
                                                this.assignLong(bw.get(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block28;
                                }
                                case LONG: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                LongWritable bw = (LongWritable)val;
                                                this.assignLong(bw.get(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block28;
                                }
                                case TIMESTAMP: {
                                    outVCA = new VectorTimestampColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                this.assignTimestamp((TimestampWritableV2)val, destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (TimestampColumnVector)destCol);
                                    break block28;
                                }
                                case DATE: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                DateWritableV2 bw = (DateWritableV2)val;
                                                this.assignLong(bw.getDays(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block28;
                                }
                                case INTERVAL_YEAR_MONTH: {
                                    outVCA = new VectorLongColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                HiveIntervalYearMonthWritable bw = (HiveIntervalYearMonthWritable)val;
                                                this.assignLong(bw.getHiveIntervalYearMonth().getTotalMonths(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (LongColumnVector)destCol);
                                    break block28;
                                }
                                case INTERVAL_DAY_TIME: {
                                    outVCA = new VectorIntervalDayTimeColumnAssign(){

                                        @Override
                                        public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                            if (val == null) {
                                                this.assignNull(destIndex);
                                            } else {
                                                HiveIntervalDayTimeWritable bw = (HiveIntervalDayTimeWritable)val;
                                                this.assignIntervalDayTime(bw.getHiveIntervalDayTime(), destIndex);
                                            }
                                        }
                                    }.init(outputBatch, (IntervalDayTimeColumnVector)destCol);
                                    break block28;
                                }
                                default: {
                                    throw new HiveException("Incompatible Long vector column and primitive category " + category);
                                }
                            }
                        }
                        if (!(destCol instanceof DoubleColumnVector)) break block30;
                        switch (category) {
                            case DOUBLE: {
                                outVCA = new VectorDoubleColumnAssign(){

                                    @Override
                                    public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                        if (val == null) {
                                            this.assignNull(destIndex);
                                        } else {
                                            DoubleWritable bw = (DoubleWritable)((Object)val);
                                            this.assignDouble(bw.get(), destIndex);
                                        }
                                    }
                                }.init(outputBatch, (DoubleColumnVector)destCol);
                                break block28;
                            }
                            case FLOAT: {
                                outVCA = new VectorDoubleColumnAssign(){

                                    @Override
                                    public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                        if (val == null) {
                                            this.assignNull(destIndex);
                                        } else {
                                            FloatWritable bw = (FloatWritable)val;
                                            this.assignDouble(bw.get(), destIndex);
                                        }
                                    }
                                }.init(outputBatch, (DoubleColumnVector)destCol);
                                break block28;
                            }
                            default: {
                                throw new HiveException("Incompatible Double vector column and primitive category " + category);
                            }
                        }
                    }
                    if (!(destCol instanceof BytesColumnVector)) break block31;
                    switch (category) {
                        case BINARY: {
                            outVCA = new VectorBytesColumnAssign(){

                                @Override
                                public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                    if (val == null) {
                                        this.assignNull(destIndex);
                                    } else {
                                        BytesWritable bw = (BytesWritable)val;
                                        byte[] bytes = bw.getBytes();
                                        this.assignBytes(bytes, 0, bw.getLength(), destIndex);
                                    }
                                }
                            }.init(outputBatch, (BytesColumnVector)destCol);
                            break block28;
                        }
                        case STRING: {
                            outVCA = new VectorBytesColumnAssign(){

                                @Override
                                public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                    if (val == null) {
                                        this.assignNull(destIndex);
                                    } else {
                                        Text bw = (Text)val;
                                        byte[] bytes = bw.getBytes();
                                        this.assignBytes(bytes, 0, bw.getLength(), destIndex);
                                    }
                                }
                            }.init(outputBatch, (BytesColumnVector)destCol);
                            break block28;
                        }
                        case VARCHAR: {
                            outVCA = new VectorBytesColumnAssign(){

                                @Override
                                public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                    if (val == null) {
                                        this.assignNull(destIndex);
                                    } else {
                                        HiveVarchar hiveVarchar = val instanceof HiveVarchar ? (HiveVarchar)val : ((HiveVarcharWritable)val).getHiveVarchar();
                                        byte[] bytes = hiveVarchar.getValue().getBytes();
                                        this.assignBytes(bytes, 0, bytes.length, destIndex);
                                    }
                                }
                            }.init(outputBatch, (BytesColumnVector)destCol);
                            break block28;
                        }
                        case CHAR: {
                            outVCA = new VectorBytesColumnAssign(){

                                @Override
                                public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                    if (val == null) {
                                        this.assignNull(destIndex);
                                    } else {
                                        HiveChar hiveChar = val instanceof HiveChar ? (HiveChar)val : ((HiveCharWritable)val).getHiveChar();
                                        byte[] bytes = hiveChar.getStrippedValue().getBytes();
                                        this.assignBytes(bytes, 0, bytes.length, destIndex);
                                    }
                                }
                            }.init(outputBatch, (BytesColumnVector)destCol);
                            break block28;
                        }
                        default: {
                            throw new HiveException("Incompatible Bytes vector column and primitive category " + category);
                        }
                    }
                }
                if (!(destCol instanceof DecimalColumnVector)) break block32;
                switch (category) {
                    case DECIMAL: {
                        outVCA = new VectorDecimalColumnAssign(){

                            @Override
                            public void assignObjectValue(Object val, int destIndex) throws HiveException {
                                if (val == null) {
                                    this.assignNull(destIndex);
                                } else if (val instanceof HiveDecimal) {
                                    this.assignDecimal((HiveDecimal)val, destIndex);
                                } else {
                                    this.assignDecimal((HiveDecimalWritable)val, destIndex);
                                }
                            }
                        }.init(outputBatch, (DecimalColumnVector)destCol);
                        break block28;
                    }
                    default: {
                        throw new HiveException("Incompatible Decimal vector column and primitive category " + category);
                    }
                }
            }
            throw new HiveException("Unknown vector column type " + destCol.getClass().getName());
        }
        return outVCA;
    }

    public static VectorColumnAssign[] buildAssigners(VectorizedRowBatch outputBatch, ObjectInspector outputOI, Map<String, Integer> columnMap, List<String> outputColumnNames) throws HiveException {
        StructObjectInspector soi = (StructObjectInspector)outputOI;
        VectorColumnAssign[] vcas = new VectorColumnAssign[outputColumnNames.size()];
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            String columnName = outputColumnNames.get(i);
            Integer columnIndex = columnMap.get(columnName);
            StructField columnRef = soi.getStructFieldRef(columnName);
            ObjectInspector valueOI = columnRef.getFieldObjectInspector();
            vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, (int)columnIndex, valueOI);
        }
        return vcas;
    }

    public static VectorColumnAssign[] buildAssigners(VectorizedRowBatch outputBatch, Writable[] writables) throws HiveException {
        VectorColumnAssign[] vcas = new VectorColumnAssign[outputBatch.numCols];
        for (int i = 0; i < writables.length; ++i) {
            if (writables[i] == null) {
                assert (outputBatch.cols[i] == null);
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.VOID);
                continue;
            }
            if (writables[i] instanceof ByteWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.BYTE);
                continue;
            }
            if (writables[i] instanceof ShortWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.SHORT);
                continue;
            }
            if (writables[i] instanceof IntWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.INT);
                continue;
            }
            if (writables[i] instanceof LongWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.LONG);
                continue;
            }
            if (writables[i] instanceof FloatWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
                continue;
            }
            if (writables[i] instanceof DoubleWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
                continue;
            }
            if (writables[i] instanceof Text) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.STRING);
                continue;
            }
            if (writables[i] instanceof BytesWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.BINARY);
                continue;
            }
            if (writables[i] instanceof TimestampWritableV2) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP);
                continue;
            }
            if (writables[i] instanceof HiveIntervalYearMonthWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH);
                continue;
            }
            if (writables[i] instanceof HiveIntervalDayTimeWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME);
                continue;
            }
            if (writables[i] instanceof BooleanWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN);
                continue;
            }
            if (writables[i] instanceof HiveDecimalWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.DECIMAL);
                continue;
            }
            if (writables[i] instanceof HiveCharWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.CHAR);
                continue;
            }
            if (writables[i] instanceof HiveVarcharWritable) {
                vcas[i] = VectorColumnAssignFactory.buildObjectAssign(outputBatch, i, PrimitiveObjectInspector.PrimitiveCategory.VARCHAR);
                continue;
            }
            throw new HiveException("Unimplemented vector assigner for writable type " + writables[i].getClass());
        }
        return vcas;
    }

    private static abstract class VectorIntervalDayTimeColumnAssign
    extends VectorColumnAssignVectorBase<IntervalDayTimeColumnVector> {
        private VectorIntervalDayTimeColumnAssign() {
        }

        protected void assignIntervalDayTime(HiveIntervalDayTime value, int index) {
            ((IntervalDayTimeColumnVector)this.outCol).set(index, value);
        }

        protected void assignIntervalDayTime(HiveIntervalDayTimeWritable tw, int index) {
            ((IntervalDayTimeColumnVector)this.outCol).set(index, tw.getHiveIntervalDayTime());
        }
    }

    private static abstract class VectorTimestampColumnAssign
    extends VectorColumnAssignVectorBase<TimestampColumnVector> {
        private VectorTimestampColumnAssign() {
        }

        protected void assignTimestamp(Timestamp value, int index) {
            ((TimestampColumnVector)this.outCol).set(index, value.toSqlTimestamp());
        }

        protected void assignTimestamp(TimestampWritableV2 tw, int index) {
            ((TimestampColumnVector)this.outCol).set(index, tw.getTimestamp().toSqlTimestamp());
        }
    }

    private static abstract class VectorDecimalColumnAssign
    extends VectorColumnAssignVectorBase<DecimalColumnVector> {
        private VectorDecimalColumnAssign() {
        }

        protected void assignDecimal(HiveDecimal value, int index) {
            ((DecimalColumnVector)this.outCol).set(index, value);
        }

        protected void assignDecimal(HiveDecimalWritable hdw, int index) {
            ((DecimalColumnVector)this.outCol).set(index, hdw);
        }
    }

    private static abstract class VectorBytesColumnAssign
    extends VectorColumnAssignVectorBase<BytesColumnVector> {
        byte[] pad = new byte[16384];
        int padUsed = 0;

        private VectorBytesColumnAssign() {
        }

        protected void assignBytes(byte[] buffer, int start, int length, int destIndex) {
            if (this.padUsed + length <= this.pad.length) {
                System.arraycopy(buffer, start, this.pad, this.padUsed, length);
                ((BytesColumnVector)this.outCol).vector[destIndex] = this.pad;
                ((BytesColumnVector)this.outCol).start[destIndex] = this.padUsed;
                ((BytesColumnVector)this.outCol).length[destIndex] = length;
                this.padUsed += length;
            } else {
                ((BytesColumnVector)this.outCol).vector[destIndex] = Arrays.copyOfRange(buffer, start, length);
                ((BytesColumnVector)this.outCol).start[destIndex] = 0;
                ((BytesColumnVector)this.outCol).length[destIndex] = length;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.padUsed = 0;
        }
    }

    private static abstract class VectorDoubleColumnAssign
    extends VectorColumnAssignVectorBase<DoubleColumnVector> {
        private VectorDoubleColumnAssign() {
        }

        protected void assignDouble(double value, int destIndex) {
            ((DoubleColumnVector)this.outCol).vector[destIndex] = value;
        }
    }

    private static abstract class VectorLongColumnAssign
    extends VectorColumnAssignVectorBase<LongColumnVector> {
        private VectorLongColumnAssign() {
        }

        protected void assignLong(long value, int destIndex) {
            ((LongColumnVector)this.outCol).vector[destIndex] = value;
        }
    }

    private static abstract class VectorColumnAssignVectorBase<T extends ColumnVector>
    implements VectorColumnAssign {
        protected VectorizedRowBatch outBatch;
        protected T outCol;

        private VectorColumnAssignVectorBase() {
        }

        protected void copyValue(T in, int srcIndex, int destIndex) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }

        @Override
        public void assignVectorValue(VectorizedRowBatch inBatch, int batchIndex, int valueColumnIndex, int destIndex) throws HiveException {
            ColumnVector in = inBatch.cols[valueColumnIndex];
            if (in.isRepeating) {
                if (in.noNulls) {
                    this.copyValue(in, 0, destIndex);
                } else {
                    this.assignNull(destIndex);
                }
            } else {
                int srcIndex;
                int n = srcIndex = inBatch.selectedInUse ? inBatch.selected[batchIndex] : batchIndex;
                if (in.noNulls || !in.isNull[srcIndex]) {
                    this.copyValue(in, srcIndex, destIndex);
                } else {
                    this.assignNull(destIndex);
                }
            }
        }

        public VectorColumnAssign init(VectorizedRowBatch out, T cv) {
            this.outBatch = out;
            this.outCol = cv;
            return this;
        }

        protected void assignNull(int index) {
            VectorizedBatchUtil.setNullColIsNullValue(this.outCol, index);
        }

        @Override
        public void reset() {
        }

        @Override
        public void assignObjectValue(Object value, int destIndex) throws HiveException {
            throw new HiveException("Internal error: should not reach here");
        }
    }
}

