/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFactorial;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

public class TestGenericUDFFactorial
extends TestCase {
    public void testFactorial() throws HiveException {
        GenericUDFFactorial udf = new GenericUDFFactorial();
        WritableIntObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerify(5, 120L, (GenericUDF)udf);
        this.runAndVerify(0, 1L, (GenericUDF)udf);
        this.runAndVerify(20, 2432902008176640000L, (GenericUDF)udf);
        this.runAndVerify(-1, null, (GenericUDF)udf);
        this.runAndVerify(21, null, (GenericUDF)udf);
        this.runAndVerify(null, null, (GenericUDF)udf);
    }

    public void testWrongInputType() throws HiveException {
        GenericUDFFactorial udf = new GenericUDFFactorial();
        WritableDoubleObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        try {
            udf.initialize(arguments);
            TestGenericUDFFactorial.assertTrue((String)"GenericUDFFactorial.initialize() shold throw UDFArgumentTypeException", (boolean)false);
        }
        catch (UDFArgumentTypeException uDFArgumentTypeException) {
            // empty catch block
        }
    }

    private void runAndVerify(Integer in, Long expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(in != null ? new IntWritable(in.intValue()) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        LongWritable output = (LongWritable)udf.evaluate(args);
        if (expResult == null) {
            TestGenericUDFFactorial.assertNull((String)"factorial() test ", (Object)output);
        } else {
            TestGenericUDFFactorial.assertNotNull((String)"factorial() test ", (Object)output);
            TestGenericUDFFactorial.assertEquals((String)"factorial() test ", (long)expResult, (long)output.get());
        }
    }
}

