/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.HadoopDefaultMetastoreAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.apache.hadoop.hive.ql.security.authorization.StorageBasedAuthorizationProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestStorageBasedAuthorizationProviderWarehouse {
    @Test
    public void testWarehouseUpdate() throws HiveException {
        String testWarehouseDir = System.getProperty("test.warehouse.dir");
        MetastoreConf.ConfVars warehouse = MetastoreConf.ConfVars.WAREHOUSE;
        StorageBasedAuthorizationProvider sbap = new StorageBasedAuthorizationProvider();
        Configuration metastoreConf = MetastoreConf.newMetastoreConf();
        metastoreConf.set("fs.defaultFS", "file:///");
        sbap.setConf(metastoreConf);
        sbap.setAuthenticator((HiveAuthenticationProvider)new HadoopDefaultMetastoreAuthenticator());
        Privilege[] privileges = new Privilege[1];
        Privilege privilege = new Privilege();
        privilege.setPriv(PrivilegeType.SELECT);
        privileges[0] = privilege;
        Database db = new Database();
        db.setName("default");
        MetastoreConf.setVar((Configuration)metastoreConf, (MetastoreConf.ConfVars)warehouse, (String)(testWarehouseDir + "/test1"));
        sbap.authorizeDbLevelOperations(privileges, privileges, null, null);
        MatcherAssert.assertThat((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(sbap.getDbLocation(db).toString()), (Matcher)CoreMatchers.is((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(MetastoreConf.getVar((Configuration)metastoreConf, (MetastoreConf.ConfVars)warehouse))));
        MetastoreConf.setVar((Configuration)metastoreConf, (MetastoreConf.ConfVars)warehouse, (String)(testWarehouseDir + "/test2"));
        sbap.authorizeDbLevelOperations(privileges, privileges, null, null);
        MatcherAssert.assertThat((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(sbap.getDbLocation(db).toString()), (Matcher)CoreMatchers.is((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(MetastoreConf.getVar((Configuration)metastoreConf, (MetastoreConf.ConfVars)warehouse))));
        MetastoreConf.setVar((Configuration)metastoreConf, (MetastoreConf.ConfVars)warehouse, (String)(testWarehouseDir + "/test3"));
        sbap.authorizeDbLevelOperations(privileges, privileges, null, null);
        MatcherAssert.assertThat((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(sbap.getDbLocation(db).toString()), (Matcher)CoreMatchers.is((Object)TestStorageBasedAuthorizationProviderWarehouse.normalize(MetastoreConf.getVar((Configuration)metastoreConf, (MetastoreConf.ConfVars)warehouse))));
    }

    private static String normalize(String path) {
        return path.replace("///", "/").replace("//", "/");
    }
}

