/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPrintf;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFPrintf {
    @Test
    public void testCharVarcharArgs() throws HiveException {
        GenericUDFPrintf udf = new GenericUDFPrintf();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getCharTypeInfo((int)5)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)7))};
        HiveCharWritable argChar = new HiveCharWritable();
        argChar.set("hello");
        HiveVarcharWritable argVarchar = new HiveVarcharWritable();
        argVarchar.set("world");
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new Text("1st: %s, 2nd: %s")), new GenericUDF.DeferredJavaObject((Object)argChar), new GenericUDF.DeferredJavaObject((Object)argVarchar)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)oi);
        Text res = (Text)udf.evaluate(args);
        Assert.assertEquals((Object)"1st: hello, 2nd: world", (Object)res.toString());
    }

    @Test
    public void testCharFormat() throws HiveException {
        GenericUDFPrintf udf = new GenericUDFPrintf();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getCharTypeInfo((int)10)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)7))};
        HiveCharWritable formatChar = new HiveCharWritable();
        formatChar.set("arg1=%s");
        HiveVarcharWritable argVarchar = new HiveVarcharWritable();
        argVarchar.set("world");
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)formatChar), new GenericUDF.DeferredJavaObject((Object)argVarchar)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)oi);
        Text res = (Text)udf.evaluate(args);
        Assert.assertEquals((Object)"arg1=world", (Object)res.toString());
    }

    @Test
    public void testVarcharFormat() throws HiveException {
        GenericUDFPrintf udf = new GenericUDFPrintf();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)7)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getCharTypeInfo((int)5))};
        HiveCharWritable argChar = new HiveCharWritable();
        argChar.set("hello");
        HiveVarcharWritable formatVarchar = new HiveVarcharWritable();
        formatVarchar.set("arg1=%s");
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)formatVarchar), new GenericUDF.DeferredJavaObject((Object)argChar)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)oi);
        Text res = (Text)udf.evaluate(args);
        Assert.assertEquals((Object)"arg1=hello", (Object)res.toString());
    }

    @Test
    public void testDecimalArgs() throws HiveException {
        GenericUDFPrintf udf = new GenericUDFPrintf();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)3, (int)2))};
        HiveDecimalWritable argDec1 = new HiveDecimalWritable();
        argDec1.set(HiveDecimal.create((String)"234.789"));
        HiveDecimalWritable argDec2 = new HiveDecimalWritable();
        argDec2.set(HiveDecimal.create((String)"3.5"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new Text("1st: %s, 2nd: %s")), new GenericUDF.DeferredJavaObject((Object)argDec1), new GenericUDF.DeferredJavaObject((Object)argDec2)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)oi);
        Text res = (Text)udf.evaluate(args);
        Assert.assertEquals((Object)"1st: 234.79, 2nd: 3.5", (Object)res.toString());
    }
}

