/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.exec.errors.DataConstraintViolationError;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEnforceConstraint;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.io.BooleanWritable;

public class TestGenericUDFEnforceConstraint
extends TestCase {
    public void testNull() throws HiveException {
        try {
            GenericUDFEnforceConstraint udf = new GenericUDFEnforceConstraint();
            WritableBooleanObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
            ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
            udf.initialize(arguments);
            BooleanWritable input = new BooleanWritable(false);
            GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
            udf.evaluate(args);
            TestGenericUDFEnforceConstraint.fail((String)"Unreachable line");
        }
        catch (DataConstraintViolationError e) {
            TestGenericUDFEnforceConstraint.assertTrue((boolean)e.getMessage().contains("NOT NULL constraint violated!"));
        }
    }

    public void testInvalidArgumentsLength() throws HiveException {
        try {
            GenericUDFEnforceConstraint udf = new GenericUDFEnforceConstraint();
            WritableBooleanObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
            WritableBooleanObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
            ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
            udf.initialize(arguments);
            TestGenericUDFEnforceConstraint.fail((String)"Unreachable line");
        }
        catch (HiveException e) {
            TestGenericUDFEnforceConstraint.assertTrue((boolean)e.getMessage().contains("Invalid number of arguments"));
        }
    }

    public void testCorrect() throws HiveException {
        GenericUDFEnforceConstraint udf = new GenericUDFEnforceConstraint();
        WritableBooleanObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        BooleanWritable input = new BooleanWritable(true);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)input)};
        BooleanWritable writable = (BooleanWritable)udf.evaluate(args);
        TestGenericUDFEnforceConstraint.assertTrue((String)("Not expected result: expected [true] actual  [ " + writable.get() + " ]"), (boolean)writable.get());
    }
}

