/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestConstantVectorExpression {
    @Test
    public void testConstantExpression() throws Exception {
        ConstantVectorExpression longCve = new ConstantVectorExpression(0, 17L, (TypeInfo)TypeInfoFactory.longTypeInfo);
        ConstantVectorExpression doubleCve = new ConstantVectorExpression(1, 17.34, (TypeInfo)TypeInfoFactory.doubleTypeInfo);
        String str = "alpha";
        ConstantVectorExpression bytesCve = new ConstantVectorExpression(2, str.getBytes(), (TypeInfo)TypeInfoFactory.stringTypeInfo);
        HiveDecimal decVal = HiveDecimal.create((String)"25.8");
        ConstantVectorExpression decimalCve = new ConstantVectorExpression(3, decVal, (TypeInfo)TypeInfoFactory.decimalTypeInfo);
        ConstantVectorExpression nullCve = new ConstantVectorExpression(4, (TypeInfo)TypeInfoFactory.stringTypeInfo, true);
        int size = 20;
        VectorizedRowBatch vrg = VectorizedRowGroupGenUtil.getVectorizedRowBatch(size, 5, 0);
        LongColumnVector lcv = (LongColumnVector)vrg.cols[0];
        DoubleColumnVector dcv = new DoubleColumnVector(size);
        BytesColumnVector bcv = new BytesColumnVector(size);
        DecimalColumnVector dv = new DecimalColumnVector(5, 1);
        BytesColumnVector bcvn = new BytesColumnVector(size);
        vrg.cols[1] = dcv;
        vrg.cols[2] = bcv;
        vrg.cols[3] = dv;
        vrg.cols[4] = bcvn;
        longCve.evaluate(vrg);
        doubleCve.evaluate(vrg);
        bytesCve.evaluate(vrg);
        decimalCve.evaluate(vrg);
        nullCve.evaluate(vrg);
        Assert.assertTrue((boolean)lcv.isRepeating);
        Assert.assertTrue((boolean)dcv.isRepeating);
        Assert.assertTrue((boolean)bcv.isRepeating);
        Assert.assertEquals((long)17L, (long)lcv.vector[0]);
        Assert.assertTrue((17.34 == dcv.vector[0] ? 1 : 0) != 0);
        Assert.assertTrue((boolean)bcvn.isRepeating);
        Assert.assertTrue((boolean)bcvn.isNull[0]);
        Assert.assertTrue((!bcvn.noNulls ? 1 : 0) != 0);
        byte[] alphaBytes = "alpha".getBytes();
        Assert.assertTrue((bcv.length[0] == alphaBytes.length ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.sameFirstKBytes(alphaBytes, bcv.vector[0], alphaBytes.length));
        ((BytesColumnVector)vrg.cols[2]).vector[0] = "beta".getBytes();
        bytesCve.evaluate(vrg);
        Assert.assertTrue((bcv.length[0] == alphaBytes.length ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.sameFirstKBytes(alphaBytes, bcv.vector[0], alphaBytes.length));
        Assert.assertTrue((25.8 == dv.vector[0].getHiveDecimal().doubleValue() ? 1 : 0) != 0);
        ((DecimalColumnVector)vrg.cols[3]).vector[0].set(HiveDecimal.create((String)"39.7"));
        decimalCve.evaluate(vrg);
        Assert.assertTrue((25.8 == dv.vector[0].getHiveDecimal().doubleValue() ? 1 : 0) != 0);
    }

    private boolean sameFirstKBytes(byte[] o1, byte[] o2, int k) {
        for (int i = 0; i != k; ++i) {
            if (o1[i] == o2[i]) continue;
            return false;
        }
        return true;
    }
}

