/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestTxnAddPartition
extends TxnCommandsBaseForTests {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnAddPartition.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnAddPartition.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Override
    String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Test
    public void addPartition() throws Exception {
        this.addPartition(false);
    }

    @Test
    public void addPartitionVectorized() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.addPartition(true);
    }

    private void addPartition(boolean isVectorized) throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(0,2),(0,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/2'");
        this.runStatementOnDriver("ALTER TABLE T ADD PARTITION (p=0) location '" + this.getWarehouseDir() + "/1/data' PARTITION (p=1) location '" + this.getWarehouseDir() + "/2/data' PARTITION (p=2)");
        String testQuery = isVectorized ? "select ROW__ID, p, a, b from T order by p, ROW__ID" : "select ROW__ID, p, a, b, INPUT__FILE__NAME from T order by p, ROW__ID";
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t0\t2", "warehouse/t/p=0/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t0\t0\t4", "warehouse/t/p=0/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t0\t2", "warehouse/t/p=1/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t1\t0\t4", "warehouse/t/p=1/delta_0000001_0000001_0000/000000_0"}};
        this.checkResult(expected, testQuery, isVectorized, "add 2 parts w/data and 1 empty", LOG);
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/3'");
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("ALTER TABLE T ADD PARTITION (p=0) location '" + this.getWarehouseDir() + "/3/data'");
        Assert.assertTrue((String)"add existing partition", (cpr.getErrorMessage() != null && cpr.getErrorMessage().contains("Partition already exists") ? 1 : 0) != 0);
        String stmt = "ALTER TABLE T ADD IF NOT EXISTS PARTITION (p=0) location '" + this.getWarehouseDir() + "/3/data' PARTITION (p=2) location '" + this.getWarehouseDir() + "/3/data'PARTITION (p=3) location '" + this.getWarehouseDir() + "/3/data'";
        this.runStatementOnDriver(stmt);
        String[][] expected2 = new String[][]{{"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t0\t0\t2", "warehouse/t/p=0/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t0\t0\t4", "warehouse/t/p=0/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":0}\t1\t0\t2", "warehouse/t/p=1/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":1,\"bucketid\":536870912,\"rowid\":1}\t1\t0\t4", "warehouse/t/p=1/delta_0000001_0000001_0000/000000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":0}\t3\t0\t2", "warehouse/t/p=3/delta_0000003_0000003_0000/000000_0"}, {"{\"writeid\":3,\"bucketid\":536870912,\"rowid\":1}\t3\t0\t4", "warehouse/t/p=3/delta_0000003_0000003_0000/000000_0"}};
        this.checkResult(expected2, testQuery, isVectorized, "add 2 existing parts and 1 empty", LOG);
    }

    @Test
    public void addPartitionMM() throws Exception {
        this.addPartitionMM(false);
    }

    @Test
    public void addPartitionMMVectorized() throws Exception {
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, true);
        this.addPartitionMM(true);
    }

    private void addPartitionMM(boolean isVectorized) throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int) stored as orc tblproperties('transactional'='true', 'transactional_properties'='insert_only')");
        this.runStatementOnDriver("create table Tstage (a int, b int) stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(0,2),(0,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/2'");
        this.runStatementOnDriver("ALTER TABLE T ADD PARTITION (p=0) location '" + this.getWarehouseDir() + "/1/data' PARTITION (p=1) location '" + this.getWarehouseDir() + "/2/data' PARTITION (p=2)");
        String testQuery = isVectorized ? "select p, a, b from T order by p, a, b" : "select p, a, b, INPUT__FILE__NAME from T order by p, a, b";
        String[][] expected = new String[][]{{"0\t0\t2", "warehouse/t/p=0/delta_0000001_0000001_0000/000000_0"}, {"0\t0\t4", "warehouse/t/p=0/delta_0000001_0000001_0000/000000_0"}, {"1\t0\t2", "warehouse/t/p=1/delta_0000001_0000001_0000/000000_0"}, {"1\t0\t4", "warehouse/t/p=1/delta_0000001_0000001_0000/000000_0"}};
        this.checkResult(expected, testQuery, isVectorized, "add 2 parts w/data and 1 empty", LOG);
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/3'");
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("ALTER TABLE T ADD PARTITION (p=0) location '" + this.getWarehouseDir() + "/3/data'");
        Assert.assertTrue((String)"add existing partition", (cpr.getErrorMessage() != null && cpr.getErrorMessage().contains("Partition already exists") ? 1 : 0) != 0);
        this.runStatementOnDriver("ALTER TABLE T ADD IF NOT EXISTS PARTITION (p=0) location '" + this.getWarehouseDir() + "/3/data' PARTITION (p=2) location '" + this.getWarehouseDir() + "/3/data'PARTITION (p=3) location '" + this.getWarehouseDir() + "/3/data'");
        String[][] expected2 = new String[][]{{"0\t0\t2", "warehouse/t/p=0/delta_0000001_0000001_0000/000000_0"}, {"0\t0\t4", "warehouse/t/p=0/delta_0000001_0000001_0000/000000_0"}, {"1\t0\t2", "warehouse/t/p=1/delta_0000001_0000001_0000/000000_0"}, {"1\t0\t4", "warehouse/t/p=1/delta_0000001_0000001_0000/000000_0"}, {"3\t0\t2", "warehouse/t/p=3/delta_0000003_0000003_0000/000000_0"}, {"3\t0\t4", "warehouse/t/p=3/delta_0000003_0000003_0000/000000_0"}};
        this.checkResult(expected2, testQuery, isVectorized, "add 2 existing parts and 1 empty", LOG);
    }

    @Test
    public void addPartitionBucketed() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int) clustered by (a) into 2 buckets stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("create table Tstage (a int, b int)  clustered by (a) into 2 buckets stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(0,2),(1,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        this.runStatementOnDriver("ALTER TABLE T ADD PARTITION (p=0) location '" + this.getWarehouseDir() + "/1/data'");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, p, a, b, INPUT__FILE__NAME from T order by p, ROW__ID");
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t0\t1\t4", "warehouse/t/p=0/delta_0000001_0000001_0000/000001_0"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":1}\t0\t0\t2", "warehouse/t/p=0/delta_0000001_0000001_0000/000001_0"}};
        this.checkExpected(rs, expected, "add partition (p=0)");
    }

    private void checkExpected(List<String> rs, String[][] expected, String msg) {
        super.checkExpected(rs, expected, msg, LOG, true);
    }

    @Test
    public void addPartitionRename() throws Exception {
        this.runStatementOnDriver("drop table if exists T");
        this.runStatementOnDriver("drop table if exists Tstage");
        this.runStatementOnDriver("create table T (a int, b int) partitioned by (p int) stored as orc tblproperties('transactional'='true')");
        this.runStatementOnDriver("create table Tstage (a int, b int)  clustered by (a) into 2 buckets stored as orc tblproperties('transactional'='false')");
        this.runStatementOnDriver("insert into Tstage values(0,2),(1,4)");
        this.runStatementOnDriver("export table Tstage to '" + this.getWarehouseDir() + "/1'");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileStatus[] status = fs.listStatus(new Path(this.getWarehouseDir() + "/1/data"), AcidUtils.originalBucketFilter);
        boolean b = fs.rename(new Path(this.getWarehouseDir() + "/1/data/000000_0"), new Path(this.getWarehouseDir() + "/1/data/part-m000"));
        b = fs.rename(new Path(this.getWarehouseDir() + "/1/data/000001_0"), new Path(this.getWarehouseDir() + "/1/data/part-m001"));
        this.runStatementOnDriver("ALTER TABLE T ADD PARTITION (p=0) location '" + this.getWarehouseDir() + "/1/data'");
        List<String> rs = this.runStatementOnDriver("select ROW__ID, p, a, b, INPUT__FILE__NAME from T order by p, ROW__ID");
        String[][] expected = new String[][]{{"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":0}\t0\t1\t4", "warehouse/t/p=0/delta_0000001_0000001_0000/000001_0"}, {"{\"writeid\":1,\"bucketid\":536936448,\"rowid\":1}\t0\t0\t2", "warehouse/t/p=0/delta_0000001_0000001_0000/000001_0"}};
        this.checkExpected(rs, expected, "add partition (p=0)");
    }

    @Ignore
    @Test
    public void testLocks() throws Exception {
    }
}

