/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.junit.Assert;
import org.junit.Test;

public class TestStatsUtils {
    @Test
    public void testCombinedRange1() {
        ColStatistics.Range r1 = new ColStatistics.Range((Number)0, (Number)1);
        ColStatistics.Range r2 = new ColStatistics.Range((Number)1, (Number)11);
        ColStatistics.Range r3 = StatsUtils.combineRange((ColStatistics.Range)r1, (ColStatistics.Range)r2);
        Assert.assertNotNull((Object)r3);
        this.rangeContains(r3, 0);
        this.rangeContains(r3, 1);
        this.rangeContains(r3, 11);
    }

    @Test
    public void testCombinedRange2() {
        this.checkCombinedRange(false, new ColStatistics.Range((Number)-2, (Number)-1), new ColStatistics.Range((Number)0, (Number)10));
        this.checkCombinedRange(true, new ColStatistics.Range((Number)-2, (Number)1), new ColStatistics.Range((Number)0, (Number)10));
        this.checkCombinedRange(true, new ColStatistics.Range((Number)-2, (Number)11), new ColStatistics.Range((Number)0, (Number)10));
        this.checkCombinedRange(true, new ColStatistics.Range((Number)1, (Number)2), new ColStatistics.Range((Number)0, (Number)10));
        this.checkCombinedRange(true, new ColStatistics.Range((Number)1, (Number)11), new ColStatistics.Range((Number)0, (Number)10));
        this.checkCombinedRange(false, new ColStatistics.Range((Number)11, (Number)12), new ColStatistics.Range((Number)0, (Number)10));
    }

    private void checkCombinedRange(boolean valid, ColStatistics.Range r1, ColStatistics.Range r2) {
        ColStatistics.Range r3a = StatsUtils.combineRange((ColStatistics.Range)r1, (ColStatistics.Range)r2);
        ColStatistics.Range r3b = StatsUtils.combineRange((ColStatistics.Range)r2, (ColStatistics.Range)r1);
        if (valid) {
            Assert.assertNotNull((Object)r3a);
            Assert.assertNotNull((Object)r3b);
        } else {
            Assert.assertNull((Object)r3a);
            Assert.assertNull((Object)r3b);
        }
    }

    private boolean rangeContains(ColStatistics.Range range, Number f) {
        double m = range.minValue.doubleValue();
        double M = range.maxValue.doubleValue();
        double v = f.doubleValue();
        return m <= v && v <= M;
    }

    @Test
    public void testPrimitiveSizeEstimations() throws Exception {
        Field[] serdeFields;
        HiveConf conf = new HiveConf();
        HashSet exclusions = Sets.newHashSet();
        exclusions.add("void");
        exclusions.add("array");
        exclusions.add("map");
        exclusions.add("struct");
        exclusions.add("uniontype");
        for (Field field : serdeFields = serdeConstants.class.getFields()) {
            String typeName;
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().endsWith("_TYPE_NAME") || exclusions.contains(typeName = (String)FieldUtils.readStaticField((Field)field))) continue;
            long siz = StatsUtils.getSizeOfPrimitiveTypeArraysFromType((String)typeName, (int)3, (HiveConf)conf);
            Assert.assertNotEquals((String)field.toString(), (long)0L, (long)siz);
        }
    }
}

