/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CreateCatalogRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropCatalogRequest;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.RoleBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.HadoopDefaultMetastoreAuthenticator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.DummyHiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizer;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestHiveMetaStoreAuthorizer {
    private static final String dbName = "test";
    private static final String tblName = "tmptbl";
    private static final String viewName = "tmpview";
    private static final String roleName = "tmpRole";
    private static final String catalogName = "testCatalog";
    private static final String unAuthorizedUser = "bob";
    private static final String authorizedUser = "sam";
    private static final String superUser = "hive";
    private static final String metaConfVal = "";
    private static final String TEST_DATA_DIR = new File("file:///testdata").getPath();
    private RawStore rawStore;
    private Configuration conf;
    private HiveMetaStore.HMSHandler hmsHandler;

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        this.conf.set("fs.defaultFS", "file:///");
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_ENABLED, (boolean)false);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN, (String)metaConfVal);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, (String)DummyHiveAuthorizerFactory.class.getName());
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS, (String)HiveMetaStoreAuthorizer.class.getName());
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_AUTHENTICATOR_MANAGER, (String)HadoopDefaultMetastoreAuthenticator.class.getName());
        this.conf.set("hadoop.proxyuser.hive.groups", "*");
        this.conf.set("hadoop.proxyuser.hive.hosts", "*");
        this.conf.set("hadoop.proxyuser.hive.users", "*");
        MetaStoreTestUtils.setConfForStandloneMode((Configuration)this.conf);
        this.hmsHandler = new HiveMetaStore.HMSHandler(dbName, this.conf, true);
        this.rawStore = new ObjectStore();
        this.rawStore.setConf(this.hmsHandler.getConf());
        HiveMetaStore.HMSHandler.createDefaultCatalog((RawStore)this.rawStore, (Warehouse)new Warehouse(this.conf));
        try {
            this.hmsHandler.drop_table(dbName, tblName, true);
            this.hmsHandler.drop_database(dbName, true, false);
            this.hmsHandler.drop_catalog(new DropCatalogRequest(catalogName));
            FileUtils.deleteDirectory((File)new File(TEST_DATA_DIR));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testA_CreateDatabase_unAuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
            this.hmsHandler.create_database(db);
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + HiveOperationType.CREATEDATABASE + " not allowed for user:bob";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testB_CreateTable_unAuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            Table table = ((TableBuilder)new TableBuilder().setTableName(tblName).addCol("name", "string")).setOwner(unAuthorizedUser).build(this.conf);
            this.hmsHandler.create_table(table);
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + HiveOperationType.CREATETABLE + " not allowed for user:bob";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testC_CreateView_anyUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Table viewObj = ((TableBuilder)new TableBuilder().setTableName(viewName).setType(TableType.VIRTUAL_VIEW.name()).addCol("name", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.create_table(viewObj);
            Map params = viewObj.getParameters();
            Assert.assertTrue((boolean)params.containsKey("Authorized"));
            Assert.assertTrue((boolean)"false".equalsIgnoreCase((String)params.get("Authorized")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testC2_AlterView_anyUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Table viewObj = ((TableBuilder)new TableBuilder().setTableName(viewName).setType(TableType.VIRTUAL_VIEW.name()).addCol("name", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.create_table(viewObj);
            viewObj = ((TableBuilder)new TableBuilder().setTableName(viewName).setType(TableType.VIRTUAL_VIEW.name()).addCol("dep", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.alter_table("default", viewName, viewObj);
            Map params = viewObj.getParameters();
            Assert.assertTrue((boolean)params.containsKey("Authorized"));
            Assert.assertTrue((boolean)"false".equalsIgnoreCase((String)params.get("Authorized")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testD_CreateView_SuperUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)superUser));
        try {
            Table viewObj = ((TableBuilder)new TableBuilder().setTableName(viewName).setType(TableType.VIRTUAL_VIEW.name()).addCol("name", "string")).build(this.conf);
            this.hmsHandler.create_table(viewObj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testE_CreateRole__anyUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Role role = new RoleBuilder().setRoleName(roleName).setOwnerName(authorizedUser).build();
            this.hmsHandler.create_role(role);
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + PreEventContext.PreEventType.AUTHORIZATION_API_CALL.name() + " not allowed for user:sam";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testF_CreateCatalog_anyUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Catalog catalog = new CatalogBuilder().setName(catalogName).setLocation(TEST_DATA_DIR).build();
            this.hmsHandler.create_catalog(new CreateCatalogRequest(catalog));
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + PreEventContext.PreEventType.CREATE_CATALOG.name() + " not allowed for user:sam";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testG_CreateCatalog_SuperUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)superUser));
        try {
            Catalog catalog = new CatalogBuilder().setName(catalogName).setLocation(TEST_DATA_DIR).build();
            this.hmsHandler.create_catalog(new CreateCatalogRequest(catalog));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testH_CreateDatabase_authorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
            this.hmsHandler.create_database(db);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testI_CreateTable_authorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Table table = ((TableBuilder)new TableBuilder().setTableName(tblName).addCol("name", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.create_table(table);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testJ_AlterTable_AuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Table table = ((TableBuilder)new TableBuilder().setTableName(tblName).addCol("name", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.create_table(table);
            Table alteredTable = ((TableBuilder)new TableBuilder().addCol("dep", "string")).build(this.conf);
            this.hmsHandler.alter_table("default", tblName, alteredTable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testK_DropTable_authorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            this.hmsHandler.drop_table(dbName, tblName, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testL_DropDatabase_authorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            this.hmsHandler.drop_database(dbName, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testM_DropCatalog_SuperUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)superUser));
        try {
            this.hmsHandler.drop_catalog(new DropCatalogRequest(catalogName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNShowDatabaseAuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            this.hmsHandler.get_all_databases();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testOShowDatabaseUnauthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            this.hmsHandler.get_all_databases();
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)err)) {
                // empty if block
            }
        }
    }

    @Test
    public void testPShowTablesAuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            this.hmsHandler.get_all_tables("default");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testQShowTablesUnauthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            this.hmsHandler.get_all_tables("default");
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)err)) {
                // empty if block
            }
        }
    }
}

