/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.HiveParquetSchemaTestUtils;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveSchemaConverter {
    @Test
    public void testSimpleType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a,b,c,d", "int,bigint,double,boolean", "message hive_schema {\n  optional int32 a;\n  optional int64 b;\n  optional double c;\n  optional boolean d;\n}\n");
    }

    @Test
    public void testSpecialIntType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a,b", "tinyint,smallint", "message hive_schema {\n  optional int32 a (INT_8);\n  optional int32 b (INT_16);\n}\n");
    }

    @Test
    public void testDecimalType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a", "decimal(5,2)", "message hive_schema {\n  optional fixed_len_byte_array(3) a (DECIMAL(5,2));\n}\n");
    }

    @Test
    public void testCharType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a", "char(5)", "message hive_schema {\n  optional binary a (UTF8);\n}\n");
    }

    @Test
    public void testVarcharType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a", "varchar(10)", "message hive_schema {\n  optional binary a (UTF8);\n}\n");
    }

    @Test
    public void testDateType() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("a", "date", "message hive_schema {\n  optional int32 a (DATE);\n}\n");
    }

    @Test
    public void testArray() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("arrayCol", "array<int>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional int32 array_element;\n    }\n  }\n}\n");
    }

    @Test
    public void testArrayDecimal() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("arrayCol", "array<decimal(5,2)>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional fixed_len_byte_array(3) array_element (DECIMAL(5,2));\n    }\n  }\n}\n");
    }

    @Test
    public void testStruct() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("structCol", "struct<a:int,b:double,c:boolean,d:decimal(5,2)>", "message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional double b;\n    optional boolean c;\n    optional fixed_len_byte_array(3) d (DECIMAL(5,2));\n  }\n}\n");
    }

    @Test
    public void testMap() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("mapCol", "map<string,string>", "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional binary value (UTF8);\n    }\n  }\n}\n");
    }

    @Test
    public void testMapDecimal() throws Exception {
        HiveParquetSchemaTestUtils.testConversion("mapCol", "map<string,decimal(5,2)>", "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional fixed_len_byte_array(3) value (DECIMAL(5,2));\n    }\n  }\n}\n");
    }

    @Test
    public void testMapOriginalType() throws Exception {
        String hiveColumnTypes = "map<string,string>";
        String hiveColumnNames = "mapCol";
        List<String> columnNames = HiveParquetSchemaTestUtils.createHiveColumnsFrom("mapCol");
        List<TypeInfo> columnTypes = HiveParquetSchemaTestUtils.createHiveTypeInfoFrom("map<string,string>");
        MessageType messageTypeFound = HiveSchemaConverter.convert(columnNames, columnTypes);
        Assert.assertEquals((long)1L, (long)messageTypeFound.getFieldCount());
        Type topLevel = (Type)messageTypeFound.getFields().get(0);
        Assert.assertEquals((Object)"mapCol", (Object)topLevel.getName());
        Assert.assertEquals((Object)OriginalType.MAP, (Object)topLevel.getOriginalType());
        Assert.assertEquals((Object)Type.Repetition.OPTIONAL, (Object)topLevel.getRepetition());
        Assert.assertEquals((long)1L, (long)topLevel.asGroupType().getFieldCount());
        Type secondLevel = (Type)topLevel.asGroupType().getFields().get(0);
        Assert.assertEquals((Object)"map", (Object)secondLevel.getName());
        Assert.assertEquals((Object)OriginalType.MAP_KEY_VALUE, (Object)secondLevel.getOriginalType());
        Assert.assertEquals((Object)Type.Repetition.REPEATED, (Object)secondLevel.getRepetition());
    }
}

