/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.junit.Test;

public class TestVectorizedRowBatch {
    static final String[] COLORS = new String[]{"red", "yellow", "green", "blue", "violet", "orange"};
    private static byte[][] colorsBytes;

    private VectorizedRowBatch makeBatch() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        LongColumnVector lv = new LongColumnVector();
        DoubleColumnVector dv = new DoubleColumnVector();
        BytesColumnVector bv = new BytesColumnVector();
        TestVectorizedRowBatch.setSampleStringCol(bv);
        batch.cols[0] = lv;
        batch.cols[1] = dv;
        batch.cols[2] = bv;
        TestVectorizedRowBatch.addRandomNulls(batch);
        return batch;
    }

    @Test
    public void testVectorizedRowBatchCreate() {
        VectorizedRowBatch batch = this.makeBatch();
        Assert.assertEquals((int)3, (int)batch.numCols);
        Assert.assertEquals((int)1024, (int)batch.size);
        Assert.assertEquals((int)((LongColumnVector)batch.cols[0]).vector.length, (int)1024);
        Assert.assertEquals((int)((DoubleColumnVector)batch.cols[1]).vector.length, (int)1024);
        Assert.assertEquals((int)((BytesColumnVector)batch.cols[2]).vector.length, (int)1024);
    }

    public static void setRandom(VectorizedRowBatch batch) {
        batch.size = 1024;
        for (int i = 0; i != batch.numCols; ++i) {
            batch.cols[i] = new LongColumnVector(1024);
            TestVectorizedRowBatch.setRandomLongCol((LongColumnVector)batch.cols[i]);
        }
    }

    public static void setSample(VectorizedRowBatch batch) {
        batch.size = 1024;
        for (int i = 0; i != batch.numCols; ++i) {
            TestVectorizedRowBatch.setSampleLongCol((LongColumnVector)batch.cols[i]);
        }
    }

    public static void setSampleOverwrite(VectorizedRowBatch batch) {
        for (int i = 0; i != batch.numCols; ++i) {
            TestVectorizedRowBatch.setSampleLongCol((LongColumnVector)batch.cols[i]);
        }
        batch.selectedInUse = false;
        batch.size = 1024;
    }

    public static void addRandomNulls(ColumnVector col) {
        col.noNulls = false;
        Random rand = new Random();
        for (int i = 0; i != col.isNull.length; ++i) {
            col.isNull[i] = Math.abs(rand.nextInt() % 11) == 0;
        }
    }

    public void addSampleNulls(ColumnVector col) {
        col.noNulls = false;
        assert (col.isNull != null);
        for (int i = 0; i != col.isNull.length; ++i) {
            col.isNull[i] = i % 11 == 0;
        }
    }

    public static void addRandomNulls(VectorizedRowBatch batch) {
        for (int i = 0; i != batch.numCols; ++i) {
            TestVectorizedRowBatch.addRandomNulls(batch.cols[i]);
        }
    }

    public void addSampleNulls(VectorizedRowBatch batch) {
        for (int i = 0; i != batch.numCols; ++i) {
            this.addSampleNulls(batch.cols[i]);
        }
    }

    public static void setSampleStringCol(BytesColumnVector col) {
        TestVectorizedRowBatch.initColors();
        int size = col.vector.length;
        for (int i = 0; i != size; ++i) {
            int pos = i % colorsBytes.length;
            col.setRef(i, colorsBytes[pos], 0, colorsBytes[pos].length);
        }
    }

    private static void initColors() {
        if (colorsBytes == null) {
            colorsBytes = new byte[COLORS.length][];
            for (int i = 0; i != COLORS.length; ++i) {
                TestVectorizedRowBatch.colorsBytes[i] = COLORS[i].getBytes();
            }
        }
    }

    public static void setSampleLongCol(LongColumnVector col) {
        int size = col.vector.length;
        for (int i = 0; i != size; ++i) {
            col.vector[i] = i % 100;
        }
    }

    public static void setRandomLongCol(LongColumnVector col) {
        int size = col.vector.length;
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i != size; ++i) {
            col.vector[i] = Math.abs(rand.nextInt() % 100);
        }
    }

    public static void setRepeatingLongCol(LongColumnVector col) {
        col.isRepeating = true;
        col.vector[0] = 50L;
    }

    public static void setSampleDoubleCol(DoubleColumnVector col) {
        int size = col.vector.length;
        for (int i = 0; i != size; ++i) {
            col.vector[i] = i % 100;
        }
    }

    public static void setRandomDoubleCol(DoubleColumnVector col) {
        int size = col.vector.length;
        Random rand = new Random();
        for (int i = 0; i != size; ++i) {
            col.vector[i] = Math.abs(rand.nextInt() % 100);
        }
    }

    public static void setRepeatingDoubleCol(DoubleColumnVector col) {
        col.isRepeating = true;
        col.vector[0] = 50.0;
    }

    @Test
    public void testFlatten() {
        this.verifyFlatten((ColumnVector)new LongColumnVector());
        this.verifyFlatten((ColumnVector)new DoubleColumnVector());
        this.verifyFlatten((ColumnVector)new BytesColumnVector());
    }

    private void verifyFlatten(ColumnVector v) {
        v.noNulls = true;
        v.isNull[1] = true;
        int[] sel = new int[]{0, 2};
        int size = 2;
        v.flatten(true, sel, size);
        Assert.assertFalse((boolean)v.noNulls);
        Assert.assertFalse((v.isNull[0] || v.isNull[2] ? 1 : 0) != 0);
        v.unFlatten();
        Assert.assertTrue((boolean)v.noNulls);
        v.isRepeating = true;
        v.noNulls = false;
        v.isNull[0] = true;
        v.flatten(true, sel, 2);
        Assert.assertFalse((boolean)v.noNulls);
        Assert.assertTrue((v.isNull[0] && v.isNull[2] ? 1 : 0) != 0);
        Assert.assertFalse((boolean)v.isRepeating);
        v.unFlatten();
        Assert.assertFalse((boolean)v.noNulls);
        Assert.assertTrue((boolean)v.isRepeating);
        v.noNulls = true;
        if (v instanceof LongColumnVector) {
            ((LongColumnVector)v).vector[0] = 100L;
            v.flatten(true, sel, 2);
            Assert.assertTrue((((LongColumnVector)v).vector[2] == 100L ? 1 : 0) != 0);
        } else if (v instanceof DoubleColumnVector) {
            ((DoubleColumnVector)v).vector[0] = 200.0;
            v.flatten(true, sel, 2);
            Assert.assertTrue((((DoubleColumnVector)v).vector[2] == 200.0 ? 1 : 0) != 0);
        } else if (v instanceof BytesColumnVector) {
            BytesColumnVector bv = (BytesColumnVector)v;
            byte[] b = null;
            try {
                b = "foo".getBytes("UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            bv.setRef(0, b, 0, b.length);
            bv.flatten(true, sel, 2);
            Assert.assertEquals((Object)bv.vector[0], (Object)bv.vector[2]);
            Assert.assertEquals((int)bv.start[0], (int)bv.start[2]);
            Assert.assertEquals((int)bv.length[0], (int)bv.length[2]);
        }
    }
}

