/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapRDbJsonFetchByIdTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapRDbJsonFetchByIdWork;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMapRDbJsonFetchByIdTask {
    private MapRDbJsonFetchByIdTask mapRDbJsonFetchByIdTask;
    private FetchOperator fetch = (FetchOperator)Mockito.mock(FetchOperator.class);
    private QueryState queryState = (QueryState)Mockito.mock(QueryState.class);
    private HiveConf conf = (HiveConf)Mockito.spy(HiveConf.class);
    private QueryPlan queryPlan = (QueryPlan)Mockito.mock(QueryPlan.class);
    private DriverContext ctx = (DriverContext)Mockito.mock(DriverContext.class);
    private CompilationOpContext opContext = (CompilationOpContext)Mockito.mock(CompilationOpContext.class);
    private MapRDbJsonFetchByIdWork work = (MapRDbJsonFetchByIdWork)Mockito.mock(MapRDbJsonFetchByIdWork.class);
    private Operator source = (Operator)Mockito.mock(Operator.class);
    private ListSinkOperator sink = (ListSinkOperator)Mockito.mock(ListSinkOperator.class);

    @Before
    public void setUp() throws Exception {
        this.mapRDbJsonFetchByIdTask = (MapRDbJsonFetchByIdTask)Mockito.spy((Object)new MapRDbJsonFetchByIdTask());
        Mockito.when((Object)this.queryState.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.work.getSource()).thenReturn((Object)this.source);
        Mockito.when((Object)this.work.getSink()).thenReturn((Object)this.sink);
        ((MapRDbJsonFetchByIdTask)Mockito.doReturn((Object)this.fetch).when((Object)this.mapRDbJsonFetchByIdTask)).createFetchOperator();
        this.mapRDbJsonFetchByIdTask.setWork((Serializable)this.work);
        this.mapRDbJsonFetchByIdTask.initialize(this.queryState, this.queryPlan, this.ctx, this.opContext);
    }

    @Test
    public void testFetchPositive() throws Exception {
        Mockito.when((Object)this.fetch.pushRow()).thenReturn((Object)true);
        boolean actual = this.mapRDbJsonFetchByIdTask.fetch(new ArrayList());
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testFetchNegative() throws Exception {
        Mockito.when((Object)this.fetch.pushRow()).thenReturn((Object)false);
        boolean actual = this.mapRDbJsonFetchByIdTask.fetch(new ArrayList());
        Assert.assertFalse((boolean)actual);
    }

    @Test(expected=IOException.class)
    public void testFetchExceptionCatch() throws Exception {
        Mockito.when((Object)this.fetch.pushRow()).thenThrow(new Throwable[]{new HiveException()});
        this.mapRDbJsonFetchByIdTask.fetch(new ArrayList());
    }
}

