/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

@Description(name="named_struct", value="_FUNC_(name1, val1, name2, val2, ...) - Creates a struct with the given field names and values")
public class GenericUDFNamedStruct
extends GenericUDF {
    private transient Object[] ret;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int numFields = arguments.length;
        if (numFields % 2 == 1) {
            throw new UDFArgumentLengthException("NAMED_STRUCT expects an even number of arguments.");
        }
        this.ret = new Object[numFields / 2];
        ArrayList<String> fname = new ArrayList<String>(numFields / 2);
        ArrayList<ObjectInspector> retOIs = new ArrayList<ObjectInspector>(numFields / 2);
        boolean constantStruct = true;
        for (int f = 0; f < numFields; f += 2) {
            if (!(arguments[f] instanceof ConstantObjectInspector)) {
                throw new UDFArgumentTypeException(f, "Even arguments to NAMED_STRUCT must be a constant STRING." + arguments[f].toString());
            }
            ConstantObjectInspector constantOI = (ConstantObjectInspector)arguments[f];
            fname.add(constantOI.getWritableConstantValue().toString());
            int valueIndex = f + 1;
            ObjectInspector valueOI = arguments[valueIndex];
            retOIs.add(valueOI);
            if (!(constantStruct &= valueOI.getCategory() == ObjectInspector.Category.PRIMITIVE && valueOI instanceof ConstantObjectInspector)) continue;
            this.ret[f / 2] = ((ConstantObjectInspector)valueOI).getWritableConstantValue();
        }
        if (constantStruct) {
            return ObjectInspectorFactory.getStandardConstantStructObjectInspector(fname, retOIs, Arrays.asList(this.ret));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fname, retOIs);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        for (int i = 0; i < arguments.length / 2; ++i) {
            this.ret[i] = arguments[2 * i + 1].get();
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("named_struct", children, ",");
    }
}

